/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.advancements.critereon;

import com.google.gson.JsonElement;
import com.google.gson.JsonNull;
import com.google.gson.JsonObject;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.JsonOps;
import java.util.Optional;
import javax.annotation.Nullable;
import net.minecraft.advancements.critereon.CriterionConditionBlock;
import net.minecraft.advancements.critereon.CriterionConditionFluid;
import net.minecraft.advancements.critereon.CriterionConditionLight;
import net.minecraft.advancements.critereon.CriterionConditionValue;
import net.minecraft.core.BlockPosition;
import net.minecraft.core.IRegistry;
import net.minecraft.resources.MinecraftKey;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.level.WorldServer;
import net.minecraft.util.ChatDeserializer;
import net.minecraft.world.level.World;
import net.minecraft.world.level.biome.BiomeBase;
import net.minecraft.world.level.block.BlockCampfire;
import net.minecraft.world.level.levelgen.feature.StructureGenerator;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class CriterionConditionLocation {
    private static final Logger b = LogManager.getLogger();
    public static final CriterionConditionLocation a = new CriterionConditionLocation(CriterionConditionValue.DoubleRange.e, CriterionConditionValue.DoubleRange.e, CriterionConditionValue.DoubleRange.e, null, null, null, null, CriterionConditionLight.a, CriterionConditionBlock.a, CriterionConditionFluid.a);
    private final CriterionConditionValue.DoubleRange c;
    private final CriterionConditionValue.DoubleRange d;
    private final CriterionConditionValue.DoubleRange e;
    @Nullable
    private final ResourceKey<BiomeBase> f;
    @Nullable
    private final StructureGenerator<?> g;
    @Nullable
    private final ResourceKey<World> h;
    @Nullable
    private final Boolean i;
    private final CriterionConditionLight j;
    private final CriterionConditionBlock k;
    private final CriterionConditionFluid l;

    public CriterionConditionLocation(CriterionConditionValue.DoubleRange x2, CriterionConditionValue.DoubleRange y2, CriterionConditionValue.DoubleRange z2, @Nullable ResourceKey<BiomeBase> biome, @Nullable StructureGenerator<?> feature, @Nullable ResourceKey<World> dimension, @Nullable Boolean smokey, CriterionConditionLight light, CriterionConditionBlock block, CriterionConditionFluid fluid) {
        this.c = x2;
        this.d = y2;
        this.e = z2;
        this.f = biome;
        this.g = feature;
        this.h = dimension;
        this.i = smokey;
        this.j = light;
        this.k = block;
        this.l = fluid;
    }

    public static CriterionConditionLocation a(ResourceKey<BiomeBase> biome) {
        return new CriterionConditionLocation(CriterionConditionValue.DoubleRange.e, CriterionConditionValue.DoubleRange.e, CriterionConditionValue.DoubleRange.e, biome, null, null, null, CriterionConditionLight.a, CriterionConditionBlock.a, CriterionConditionFluid.a);
    }

    public static CriterionConditionLocation b(ResourceKey<World> dimension) {
        return new CriterionConditionLocation(CriterionConditionValue.DoubleRange.e, CriterionConditionValue.DoubleRange.e, CriterionConditionValue.DoubleRange.e, null, null, dimension, null, CriterionConditionLight.a, CriterionConditionBlock.a, CriterionConditionFluid.a);
    }

    public static CriterionConditionLocation a(StructureGenerator<?> feature) {
        return new CriterionConditionLocation(CriterionConditionValue.DoubleRange.e, CriterionConditionValue.DoubleRange.e, CriterionConditionValue.DoubleRange.e, null, feature, null, null, CriterionConditionLight.a, CriterionConditionBlock.a, CriterionConditionFluid.a);
    }

    public static CriterionConditionLocation a(CriterionConditionValue.DoubleRange y2) {
        return new CriterionConditionLocation(CriterionConditionValue.DoubleRange.e, y2, CriterionConditionValue.DoubleRange.e, null, null, null, null, CriterionConditionLight.a, CriterionConditionBlock.a, CriterionConditionFluid.a);
    }

    public boolean a(WorldServer world, double x2, double y2, double z2) {
        if (!this.c.d(x2)) {
            return false;
        }
        if (!this.d.d(y2)) {
            return false;
        }
        if (!this.e.d(z2)) {
            return false;
        }
        if (this.h != null && this.h != world.aa()) {
            return false;
        }
        BlockPosition blockPos = new BlockPosition(x2, y2, z2);
        boolean bl = world.n(blockPos);
        Optional<ResourceKey<BiomeBase>> optional = world.t().d(IRegistry.aR).c(world.v(blockPos));
        if (!optional.isPresent()) {
            return false;
        }
        if (!(this.f == null || bl && this.f == optional.get())) {
            return false;
        }
        if (!(this.g == null || bl && world.a().b(blockPos, this.g).b())) {
            return false;
        }
        if (!(this.i == null || bl && this.i == BlockCampfire.a(world, blockPos))) {
            return false;
        }
        if (!this.j.a(world, blockPos)) {
            return false;
        }
        if (!this.k.a(world, blockPos)) {
            return false;
        }
        return this.l.a(world, blockPos);
    }

    public JsonElement a() {
        if (this == a) {
            return JsonNull.INSTANCE;
        }
        JsonObject jsonObject = new JsonObject();
        if (!(this.c.c() && this.d.c() && this.e.c())) {
            JsonObject jsonObject2 = new JsonObject();
            jsonObject2.add("x", this.c.d());
            jsonObject2.add("y", this.d.d());
            jsonObject2.add("z", this.e.d());
            jsonObject.add("position", (JsonElement)jsonObject2);
        }
        if (this.h != null) {
            World.e.encodeStart((DynamicOps)JsonOps.INSTANCE, this.h).resultOrPartial(arg_0 -> ((Logger)b).error(arg_0)).ifPresent(jsonElement -> jsonObject.add("dimension", jsonElement));
        }
        if (this.g != null) {
            jsonObject.addProperty("feature", this.g.f());
        }
        if (this.f != null) {
            jsonObject.addProperty("biome", this.f.a().toString());
        }
        if (this.i != null) {
            jsonObject.addProperty("smokey", this.i);
        }
        jsonObject.add("light", this.j.a());
        jsonObject.add("block", this.k.a());
        jsonObject.add("fluid", this.l.a());
        return jsonObject;
    }

    public static CriterionConditionLocation a(@Nullable JsonElement json) {
        if (json == null || json.isJsonNull()) {
            return a;
        }
        JsonObject jsonObject = ChatDeserializer.m(json, "location");
        JsonObject jsonObject2 = ChatDeserializer.a(jsonObject, "position", new JsonObject());
        CriterionConditionValue.DoubleRange doubles = CriterionConditionValue.DoubleRange.a(jsonObject2.get("x"));
        CriterionConditionValue.DoubleRange doubles2 = CriterionConditionValue.DoubleRange.a(jsonObject2.get("y"));
        CriterionConditionValue.DoubleRange doubles3 = CriterionConditionValue.DoubleRange.a(jsonObject2.get("z"));
        ResourceKey resourceKey = jsonObject.has("dimension") ? (ResourceKey)MinecraftKey.a.parse((DynamicOps)JsonOps.INSTANCE, (Object)jsonObject.get("dimension")).resultOrPartial(arg_0 -> ((Logger)b).error(arg_0)).map(resourceLocation -> ResourceKey.a(IRegistry.R, resourceLocation)).orElse(null) : null;
        StructureGenerator structureFeature = jsonObject.has("feature") ? (StructureGenerator)StructureGenerator.b.get((Object)ChatDeserializer.h(jsonObject, "feature")) : null;
        ResourceKey<BiomeBase> resourceKey2 = null;
        if (jsonObject.has("biome")) {
            MinecraftKey resourceLocation2 = new MinecraftKey(ChatDeserializer.h(jsonObject, "biome"));
            resourceKey2 = ResourceKey.a(IRegistry.aR, resourceLocation2);
        }
        Boolean boolean_ = jsonObject.has("smokey") ? Boolean.valueOf(jsonObject.get("smokey").getAsBoolean()) : null;
        CriterionConditionLight lightPredicate = CriterionConditionLight.a(jsonObject.get("light"));
        CriterionConditionBlock blockPredicate = CriterionConditionBlock.a(jsonObject.get("block"));
        CriterionConditionFluid fluidPredicate = CriterionConditionFluid.a(jsonObject.get("fluid"));
        return new CriterionConditionLocation(doubles, doubles2, doubles3, resourceKey2, structureFeature, resourceKey, boolean_, lightPredicate, blockPredicate, fluidPredicate);
    }

    public static class a {
        private CriterionConditionValue.DoubleRange a = CriterionConditionValue.DoubleRange.e;
        private CriterionConditionValue.DoubleRange b = CriterionConditionValue.DoubleRange.e;
        private CriterionConditionValue.DoubleRange c = CriterionConditionValue.DoubleRange.e;
        @Nullable
        private ResourceKey<BiomeBase> d;
        @Nullable
        private StructureGenerator<?> e;
        @Nullable
        private ResourceKey<World> f;
        @Nullable
        private Boolean g;
        private CriterionConditionLight h = CriterionConditionLight.a;
        private CriterionConditionBlock i = CriterionConditionBlock.a;
        private CriterionConditionFluid j = CriterionConditionFluid.a;

        public static a a() {
            return new a();
        }

        public a a(CriterionConditionValue.DoubleRange x2) {
            this.a = x2;
            return this;
        }

        public a b(CriterionConditionValue.DoubleRange y2) {
            this.b = y2;
            return this;
        }

        public a c(CriterionConditionValue.DoubleRange z2) {
            this.c = z2;
            return this;
        }

        public a a(@Nullable ResourceKey<BiomeBase> biome) {
            this.d = biome;
            return this;
        }

        public a a(@Nullable StructureGenerator<?> feature) {
            this.e = feature;
            return this;
        }

        public a b(@Nullable ResourceKey<World> dimension) {
            this.f = dimension;
            return this;
        }

        public a a(CriterionConditionLight light) {
            this.h = light;
            return this;
        }

        public a a(CriterionConditionBlock block) {
            this.i = block;
            return this;
        }

        public a a(CriterionConditionFluid fluid) {
            this.j = fluid;
            return this;
        }

        public a a(Boolean smokey) {
            this.g = smokey;
            return this;
        }

        public CriterionConditionLocation b() {
            return new CriterionConditionLocation(this.a, this.b, this.c, this.d, this.e, this.f, this.g, this.h, this.i, this.j);
        }
    }
}

