/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft;

import com.google.common.collect.Maps;
import java.util.List;
import java.util.Map;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import net.minecraft.SharedConstants;
import net.minecraft.SystemUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import oshi.SystemInfo;
import oshi.hardware.CentralProcessor;
import oshi.hardware.GlobalMemory;
import oshi.hardware.GraphicsCard;
import oshi.hardware.HardwareAbstractionLayer;
import oshi.hardware.PhysicalMemory;
import oshi.hardware.VirtualMemory;

public class SystemReport {
    public static final long a = 0x100000L;
    private static final long b = 1000000000L;
    private static final Logger c = LogManager.getLogger();
    private static final String d = System.getProperty("os.name") + " (" + System.getProperty("os.arch") + ") version " + System.getProperty("os.version");
    private static final String e = System.getProperty("java.version") + ", " + System.getProperty("java.vendor");
    private static final String f = System.getProperty("java.vm.name") + " (" + System.getProperty("java.vm.info") + "), " + System.getProperty("java.vm.vendor");
    private final Map<String, String> g = Maps.newLinkedHashMap();

    public SystemReport() {
        this.a("Minecraft Version", SharedConstants.b().getName());
        this.a("Minecraft Version ID", SharedConstants.b().getId());
        this.a("Operating System", d);
        this.a("Java Version", e);
        this.a("Java VM Version", f);
        this.a("Memory", () -> {
            Runtime runtime = Runtime.getRuntime();
            long l2 = runtime.maxMemory();
            long m2 = runtime.totalMemory();
            long n2 = runtime.freeMemory();
            long o2 = l2 / 0x100000L;
            long p2 = m2 / 0x100000L;
            long q2 = n2 / 0x100000L;
            return n2 + " bytes (" + q2 + " MiB) / " + m2 + " bytes (" + p2 + " MiB) up to " + l2 + " bytes (" + o2 + " MiB)";
        });
        this.a("CPUs", () -> String.valueOf(Runtime.getRuntime().availableProcessors()));
        this.a("hardware", () -> this.a(new SystemInfo()));
        this.a("JVM Flags", () -> {
            List list = SystemUtils.k().collect(Collectors.toList());
            return String.format("%d total; %s", list.size(), String.join((CharSequence)" ", list));
        });
    }

    public void a(String name, String value) {
        this.g.put(name, value);
    }

    public void a(String name, Supplier<String> valueSupplier) {
        try {
            this.a(name, valueSupplier.get());
        }
        catch (Exception exception) {
            c.warn("Failed to get system info for {}", (Object)name, (Object)exception);
            this.a(name, "ERR");
        }
    }

    private void a(SystemInfo systemInfo) {
        HardwareAbstractionLayer hardwareAbstractionLayer = systemInfo.getHardware();
        this.a("processor", () -> this.a(hardwareAbstractionLayer.getProcessor()));
        this.a("graphics", () -> this.b(hardwareAbstractionLayer.getGraphicsCards()));
        this.a("memory", () -> this.a(hardwareAbstractionLayer.getMemory()));
    }

    private void a(String name, Runnable adder) {
        try {
            adder.run();
        }
        catch (Throwable throwable) {
            c.warn("Failed retrieving info for group {}", (Object)name, (Object)throwable);
        }
    }

    private void a(List<PhysicalMemory> memories) {
        int i2 = 0;
        for (PhysicalMemory physicalMemory : memories) {
            String string = String.format("Memory slot #%d ", i2++);
            this.a(string + "capacity (MB)", () -> String.format("%.2f", Float.valueOf((float)physicalMemory.getCapacity() / 1048576.0f)));
            this.a(string + "clockSpeed (GHz)", () -> String.format("%.2f", Float.valueOf((float)physicalMemory.getClockSpeed() / 1.0E9f)));
            this.a(string + "type", () -> ((PhysicalMemory)physicalMemory).getMemoryType());
        }
    }

    private void a(VirtualMemory virtualMemory) {
        this.a("Virtual memory max (MB)", () -> String.format("%.2f", Float.valueOf((float)virtualMemory.getVirtualMax() / 1048576.0f)));
        this.a("Virtual memory used (MB)", () -> String.format("%.2f", Float.valueOf((float)virtualMemory.getVirtualInUse() / 1048576.0f)));
        this.a("Swap memory total (MB)", () -> String.format("%.2f", Float.valueOf((float)virtualMemory.getSwapTotal() / 1048576.0f)));
        this.a("Swap memory used (MB)", () -> String.format("%.2f", Float.valueOf((float)virtualMemory.getSwapUsed() / 1048576.0f)));
    }

    private void a(GlobalMemory globalMemory) {
        this.a("physical memory", () -> this.a(globalMemory.getPhysicalMemory()));
        this.a("virtual memory", () -> this.a(globalMemory.getVirtualMemory()));
    }

    private void b(List<GraphicsCard> graphicsCards) {
        int i2 = 0;
        for (GraphicsCard graphicsCard : graphicsCards) {
            String string = String.format("Graphics card #%d ", i2++);
            this.a(string + "name", () -> ((GraphicsCard)graphicsCard).getName());
            this.a(string + "vendor", () -> ((GraphicsCard)graphicsCard).getVendor());
            this.a(string + "VRAM (MB)", () -> String.format("%.2f", Float.valueOf((float)graphicsCard.getVRam() / 1048576.0f)));
            this.a(string + "deviceId", () -> ((GraphicsCard)graphicsCard).getDeviceId());
            this.a(string + "versionInfo", () -> ((GraphicsCard)graphicsCard).getVersionInfo());
        }
    }

    private void a(CentralProcessor centralProcessor) {
        CentralProcessor.ProcessorIdentifier processorIdentifier = centralProcessor.getProcessorIdentifier();
        this.a("Processor Vendor", () -> ((CentralProcessor.ProcessorIdentifier)processorIdentifier).getVendor());
        this.a("Processor Name", () -> ((CentralProcessor.ProcessorIdentifier)processorIdentifier).getName());
        this.a("Identifier", () -> ((CentralProcessor.ProcessorIdentifier)processorIdentifier).getIdentifier());
        this.a("Microarchitecture", () -> ((CentralProcessor.ProcessorIdentifier)processorIdentifier).getMicroarchitecture());
        this.a("Frequency (GHz)", () -> String.format("%.2f", Float.valueOf((float)processorIdentifier.getVendorFreq() / 1.0E9f)));
        this.a("Number of physical packages", () -> String.valueOf(centralProcessor.getPhysicalPackageCount()));
        this.a("Number of physical CPUs", () -> String.valueOf(centralProcessor.getPhysicalProcessorCount()));
        this.a("Number of logical CPUs", () -> String.valueOf(centralProcessor.getLogicalProcessorCount()));
    }

    public void a(StringBuilder stringBuilder) {
        stringBuilder.append("-- ").append("System Details").append(" --\n");
        stringBuilder.append("Details:");
        this.g.forEach((name, value) -> {
            stringBuilder.append("\n\t");
            stringBuilder.append((String)name);
            stringBuilder.append(": ");
            stringBuilder.append((String)value);
        });
    }

    public String a() {
        return this.g.entrySet().stream().map(entry -> (String)entry.getKey() + ": " + (String)entry.getValue()).collect(Collectors.joining(System.lineSeparator()));
    }
}

