/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft;

import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.mojang.bridge.game.PackType;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.time.ZonedDateTime;
import java.util.Date;
import java.util.UUID;
import net.minecraft.SharedConstants;
import net.minecraft.WorldVersion;
import net.minecraft.util.ChatDeserializer;
import net.minecraft.world.level.storage.DataVersion;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class MinecraftVersion
implements WorldVersion {
    private static final Logger b = LogManager.getLogger();
    public static final WorldVersion a = new MinecraftVersion();
    private final String c;
    private final String d;
    private final boolean e;
    private final DataVersion f;
    private final int g;
    private final int h;
    private final int i;
    private final Date j;
    private final String k;

    private MinecraftVersion() {
        this.c = UUID.randomUUID().toString().replaceAll("-", "");
        this.d = "1.18.1";
        this.e = true;
        this.f = new DataVersion(2865, "main");
        this.g = SharedConstants.c();
        this.h = 8;
        this.i = 8;
        this.j = new Date();
        this.k = "1.18.1";
    }

    private MinecraftVersion(JsonObject json) {
        this.c = ChatDeserializer.h(json, "id");
        this.d = ChatDeserializer.h(json, "name");
        this.k = ChatDeserializer.h(json, "release_target");
        this.e = ChatDeserializer.j(json, "stable");
        this.f = new DataVersion(ChatDeserializer.n(json, "world_version"), ChatDeserializer.a(json, "series_id", DataVersion.a));
        this.g = ChatDeserializer.n(json, "protocol_version");
        JsonObject jsonObject = ChatDeserializer.t(json, "pack_version");
        this.h = ChatDeserializer.n(jsonObject, "resource");
        this.i = ChatDeserializer.n(jsonObject, "data");
        this.j = Date.from(ZonedDateTime.parse(ChatDeserializer.h(json, "build_time")).toInstant());
    }

    /*
     * Enabled aggressive exception aggregation
     */
    public static WorldVersion a() {
        try (InputStream inputStream = MinecraftVersion.class.getResourceAsStream("/version.json");){
            MinecraftVersion minecraftVersion;
            if (inputStream == null) {
                b.warn("Missing version information!");
                WorldVersion worldVersion = a;
                return worldVersion;
            }
            try (InputStreamReader inputStreamReader = new InputStreamReader(inputStream);){
                minecraftVersion = new MinecraftVersion(ChatDeserializer.a(inputStreamReader));
            }
            return minecraftVersion;
        }
        catch (JsonParseException | IOException exception) {
            throw new IllegalStateException("Game version information is corrupt", exception);
        }
    }

    public String getId() {
        return this.c;
    }

    public String getName() {
        return this.d;
    }

    public String getReleaseTarget() {
        return this.k;
    }

    @Override
    @Override
    public DataVersion b() {
        return this.f;
    }

    public int getProtocolVersion() {
        return this.g;
    }

    public int getPackVersion(PackType packType) {
        return packType == PackType.DATA ? this.i : this.h;
    }

    public Date getBuildTime() {
        return this.j;
    }

    public boolean isStable() {
        return this.e;
    }
}

