/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft;

import com.destroystokyo.paper.util.SneakyThrow;
import com.google.common.collect.Lists;
import io.papermc.paper.util.StacktraceDeobfuscator;
import java.io.File;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.io.Writer;
import java.nio.charset.StandardCharsets;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.List;
import java.util.concurrent.CompletionException;
import net.minecraft.CrashReportSystemDetails;
import net.minecraft.ReportedException;
import net.minecraft.SystemReport;
import net.minecraft.SystemUtils;
import net.minecraft.util.MemoryReserve;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.bukkit.craftbukkit.v1_18_R1.CraftCrashReport;

public class CrashReport {
    private static final Logger a = LogManager.getLogger();
    private final String b;
    private final Throwable c;
    private final List<CrashReportSystemDetails> d = Lists.newArrayList();
    private File e;
    private boolean f = true;
    private StackTraceElement[] g = new StackTraceElement[0];
    private final SystemReport h = new SystemReport();

    public CrashReport(String message, Throwable cause) {
        StacktraceDeobfuscator.INSTANCE.deobfuscateThrowable(cause);
        this.b = message;
        this.c = cause;
        this.h.a("CraftBukkit Information", new CraftCrashReport());
    }

    public String a() {
        return this.b;
    }

    public Throwable b() {
        return this.c;
    }

    public String c() {
        StringBuilder stringbuilder = new StringBuilder();
        this.a(stringbuilder);
        return stringbuilder.toString();
    }

    public void a(StringBuilder crashReportBuilder) {
        if (!(this.g != null && this.g.length > 0 || this.d.isEmpty())) {
            this.g = (StackTraceElement[])ArrayUtils.subarray((Object[])this.d.get(0).a(), (int)0, (int)1);
        }
        if (this.g != null && this.g.length > 0) {
            crashReportBuilder.append("-- Head --\n");
            crashReportBuilder.append("Thread: ").append(Thread.currentThread().getName()).append("\n");
            crashReportBuilder.append("Stacktrace:\n");
            for (StackTraceElement stacktraceelement : this.g) {
                crashReportBuilder.append("\t").append("at ").append(stacktraceelement);
                crashReportBuilder.append("\n");
            }
            crashReportBuilder.append("\n");
        }
        for (CrashReportSystemDetails crashreportsystemdetails : this.d) {
            crashreportsystemdetails.a(crashReportBuilder);
            crashReportBuilder.append("\n\n");
        }
        this.h.a(crashReportBuilder);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String d() {
        String s2;
        StringWriter stringwriter = null;
        PrintWriter printwriter = null;
        Throwable object = this.c;
        if (object.getMessage() == null) {
            if (object instanceof NullPointerException) {
                object = new NullPointerException(this.b);
            } else if (object instanceof StackOverflowError) {
                object = new StackOverflowError(this.b);
            } else if (object instanceof OutOfMemoryError) {
                object = new OutOfMemoryError(this.b);
            }
            object.setStackTrace(this.c.getStackTrace());
        }
        try {
            stringwriter = new StringWriter();
            printwriter = new PrintWriter(stringwriter);
            object.printStackTrace(printwriter);
            s2 = stringwriter.toString();
        }
        catch (Throwable throwable) {
            IOUtils.closeQuietly((Writer)stringwriter);
            IOUtils.closeQuietly(printwriter);
            throw throwable;
        }
        IOUtils.closeQuietly((Writer)stringwriter);
        IOUtils.closeQuietly((Writer)printwriter);
        return s2;
    }

    public String e() {
        StringBuilder stringbuilder = new StringBuilder();
        stringbuilder.append("---- Minecraft Crash Report ----\n");
        stringbuilder.append("// ");
        stringbuilder.append(CrashReport.i());
        stringbuilder.append("\n\n");
        stringbuilder.append("Time: ");
        stringbuilder.append(new SimpleDateFormat().format(new Date()));
        stringbuilder.append("\n");
        stringbuilder.append("Description: ");
        stringbuilder.append(this.b);
        stringbuilder.append("\n\n");
        stringbuilder.append(this.d());
        stringbuilder.append("\n\nA detailed walkthrough of the error, its code path and all known details is as follows:\n");
        for (int i2 = 0; i2 < 87; ++i2) {
            stringbuilder.append("-");
        }
        stringbuilder.append("\n\n");
        this.a(stringbuilder);
        return stringbuilder.toString();
    }

    public File f() {
        return this.e;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean a(File file) {
        boolean bl;
        if (this.e != null) {
            return false;
        }
        if (file.getParentFile() != null) {
            file.getParentFile().mkdirs();
        }
        OutputStreamWriter outputstreamwriter = null;
        try {
            boolean flag1;
            outputstreamwriter = new OutputStreamWriter((OutputStream)new FileOutputStream(file), StandardCharsets.UTF_8);
            outputstreamwriter.write(this.e());
            this.e = file;
            bl = flag1 = true;
        }
        catch (Throwable throwable) {
            boolean flag;
            try {
                a.error("Could not save crash report to {}", (Object)file, (Object)throwable);
                flag = false;
            }
            catch (Throwable throwable2) {
                IOUtils.closeQuietly(outputstreamwriter);
                throw throwable2;
            }
            IOUtils.closeQuietly((Writer)outputstreamwriter);
            return flag;
        }
        IOUtils.closeQuietly((Writer)outputstreamwriter);
        return bl;
    }

    public SystemReport g() {
        return this.h;
    }

    public CrashReportSystemDetails a(String name) {
        return this.a(name, 1);
    }

    public CrashReportSystemDetails a(String name, int ignoredStackTraceCallCount) {
        CrashReportSystemDetails crashreportsystemdetails = new CrashReportSystemDetails(name);
        if (this.f) {
            int j2 = crashreportsystemdetails.a(ignoredStackTraceCallCount);
            StackTraceElement[] astacktraceelement = this.c.getStackTrace();
            StackTraceElement stacktraceelement = null;
            StackTraceElement stacktraceelement1 = null;
            int k2 = astacktraceelement.length - j2;
            if (k2 < 0) {
                System.out.println("Negative index in crash report handler (" + astacktraceelement.length + "/" + j2 + ")");
            }
            if (astacktraceelement != null && 0 <= k2 && k2 < astacktraceelement.length) {
                stacktraceelement = astacktraceelement[k2];
                if (astacktraceelement.length + 1 - j2 < astacktraceelement.length) {
                    stacktraceelement1 = astacktraceelement[astacktraceelement.length + 1 - j2];
                }
            }
            this.f = crashreportsystemdetails.a(stacktraceelement, stacktraceelement1);
            if (astacktraceelement != null && astacktraceelement.length >= j2 && 0 <= k2 && k2 < astacktraceelement.length) {
                this.g = new StackTraceElement[k2];
                System.arraycopy(astacktraceelement, 0, this.g, 0, this.g.length);
            } else {
                this.f = false;
            }
        }
        this.d.add(crashreportsystemdetails);
        return crashreportsystemdetails;
    }

    private static String i() {
        String[] astring = new String[]{"Who set us up the TNT?", "Everything's going to plan. No, really, that was supposed to happen.", "Uh... Did I do that?", "Oops.", "Why did you do that?", "I feel sad now :(", "My bad.", "I'm sorry, Dave.", "I let you down. Sorry :(", "On the bright side, I bought you a teddy bear!", "Daisy, daisy...", "Oh - I know what I did wrong!", "Hey, that tickles! Hehehe!", "I blame Dinnerbone.", "You should try our sister game, Minceraft!", "Don't be sad. I'll do better next time, I promise!", "Don't be sad, have a hug! <3", "I just don't know what went wrong :(", "Shall we play a game?", "Quite honestly, I wouldn't worry myself about that.", "I bet Cylons wouldn't have this problem.", "Sorry :(", "Surprise! Haha. Well, this is awkward.", "Would you like a cupcake?", "Hi. I'm Minecraft, and I'm a crashaholic.", "Ooh. Shiny.", "This doesn't make any sense!", "Why is it breaking :(", "Don't do that.", "Ouch. That hurt :(", "You're mean.", "This is a token for 1 free hug. Redeem at your nearest Mojangsta: [~~HUG~~]", "There are four lights!", "But it works on my machine."};
        try {
            return astring[(int)(SystemUtils.d() % (long)astring.length)];
        }
        catch (Throwable throwable) {
            return "Witty comment unavailable :(";
        }
    }

    public static CrashReport a(Throwable cause, String title) {
        if (cause instanceof ThreadDeath) {
            SneakyThrow.sneaky((Throwable)cause);
        }
        while (cause instanceof CompletionException && cause.getCause() != null) {
            cause = cause.getCause();
        }
        CrashReport crashreport = cause instanceof ReportedException ? ((ReportedException)cause).a() : new CrashReport(title, cause);
        return crashreport;
    }

    public static void h() {
        MemoryReserve.a();
        new CrashReport("Don't panic!", new Throwable()).e();
    }
}

