/*
 * Decompiled with CFR 0.152.
 */
package io.papermc.paper.util.math;

import java.util.Random;

public final class ThreadUnsafeRandom
extends Random {
    private static final long multiplier = 25214903917L;
    private static final long addend = 11L;
    private static final long mask = 0xFFFFFFFFFFFFL;
    private long seed;

    private static long initialScramble(long seed) {
        return (seed ^ 0x5DEECE66DL) & 0xFFFFFFFFFFFFL;
    }

    @Override
    public void setSeed(long seed) {
        this.seed = ThreadUnsafeRandom.initialScramble(seed);
    }

    @Override
    protected int next(int bits) {
        this.seed = this.seed * 25214903917L + 11L;
        return (int)((this.seed & 0xFFFFFFFFFFFFL) >>> 48 - bits);
    }

    public static int fastRandomBounded(long randomInteger, long limit) {
        return (int)(randomInteger * limit >>> 32);
    }

    @Override
    public int nextInt(int bound) {
        return ThreadUnsafeRandom.fastRandomBounded((long)this.next(32) & 0xFFFFFFFFL, bound);
    }
}

