/*
 * Decompiled with CFR 0.152.
 */
package io.papermc.paper.util;

public final class IntervalledCounter {
    protected long[] times = new long[8];
    protected final long interval;
    protected long minTime;
    protected int sum;
    protected int head;
    protected int tail;

    public IntervalledCounter(long interval) {
        this.interval = interval;
    }

    public void updateCurrentTime() {
        this.updateCurrentTime(System.nanoTime());
    }

    public void updateCurrentTime(long currentTime) {
        int sum = this.sum;
        int head = this.head;
        int tail = this.tail;
        long minTime = currentTime - this.interval;
        int arrayLen = this.times.length;
        while (head != tail && this.times[head] - minTime < 0L) {
            head = (head + 1) % arrayLen;
            --sum;
        }
        this.sum = sum;
        this.head = head;
        this.minTime = minTime;
    }

    public void addTime(long currTime) {
        if (currTime - this.minTime < 0L) {
            return;
        }
        int nextTail = (this.tail + 1) % this.times.length;
        if (nextTail == this.head) {
            this.resize();
            nextTail = (this.tail + 1) % this.times.length;
        }
        this.times[this.tail] = currTime;
        this.tail = nextTail;
    }

    public void updateAndAdd(int count) {
        long currTime = System.nanoTime();
        this.updateCurrentTime(currTime);
        for (int i2 = 0; i2 < count; ++i2) {
            this.addTime(currTime);
        }
    }

    public void updateAndAdd(int count, long currTime) {
        this.updateCurrentTime(currTime);
        for (int i2 = 0; i2 < count; ++i2) {
            this.addTime(currTime);
        }
    }

    private void resize() {
        long[] oldElements = this.times;
        long[] newElements = new long[this.times.length * 2];
        this.times = newElements;
        int tail = this.tail;
        int head = this.head;
        int size = tail >= head ? tail - head : tail + (oldElements.length - head);
        this.head = 0;
        this.tail = size;
        if (tail >= head) {
            System.arraycopy(oldElements, head, newElements, 0, size);
        } else {
            System.arraycopy(oldElements, head, newElements, 0, oldElements.length - head);
            System.arraycopy(oldElements, 0, newElements, oldElements.length - head, tail);
        }
    }

    public double getRate() {
        return (double)this.size() / ((double)this.interval * 1.0E-9);
    }

    public int size() {
        int tail = this.tail;
        int head = this.head;
        return tail >= head ? tail - head : tail + (this.times.length - head);
    }
}

