/*
 * Decompiled with CFR 0.152.
 */
package io.papermc.paper.console;

import com.mojang.brigadier.ParseResults;
import com.mojang.brigadier.context.ParsedCommandNode;
import com.mojang.brigadier.tree.LiteralCommandNode;
import io.papermc.paper.console.BrigadierCommandCompleter;
import java.util.Iterator;
import java.util.regex.Pattern;
import net.minecraft.commands.CommandListenerWrapper;
import net.minecraft.server.dedicated.DedicatedServer;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.jline.reader.Highlighter;
import org.jline.reader.LineReader;
import org.jline.utils.AttributedString;
import org.jline.utils.AttributedStringBuilder;
import org.jline.utils.AttributedStyle;

public final class BrigadierCommandHighlighter
implements Highlighter {
    private static final int[] COLORS = new int[]{6, 3, 2, 5, 4};
    private final CommandListenerWrapper commandSourceStack;
    private final DedicatedServer server;

    public BrigadierCommandHighlighter(@NonNull DedicatedServer server, @NonNull CommandListenerWrapper commandSourceStack) {
        this.server = server;
        this.commandSourceStack = commandSourceStack;
    }

    public AttributedString highlight(@NonNull LineReader reader, @NonNull String buffer) {
        ParsedCommandNode node;
        AttributedStringBuilder builder = new AttributedStringBuilder();
        ParseResults<CommandListenerWrapper> results = this.server.aA().a().parse(BrigadierCommandCompleter.prepareStringReader(buffer), this.commandSourceStack);
        int pos = 0;
        if (buffer.startsWith("/")) {
            builder.append((CharSequence)"/", AttributedStyle.DEFAULT);
            pos = 1;
        }
        int component = -1;
        Iterator iterator = results.getContext().getLastChild().getNodes().iterator();
        while (iterator.hasNext() && (node = (ParsedCommandNode)iterator.next()).getRange().getStart() < buffer.length()) {
            int start = node.getRange().getStart();
            int end = Math.min(node.getRange().getEnd(), buffer.length());
            builder.append((CharSequence)buffer.substring(pos, start), AttributedStyle.DEFAULT);
            if (node.getNode() instanceof LiteralCommandNode) {
                builder.append((CharSequence)buffer.substring(start, end), AttributedStyle.DEFAULT);
            } else {
                if (++component >= COLORS.length) {
                    component = 0;
                }
                builder.append((CharSequence)buffer.substring(start, end), AttributedStyle.DEFAULT.foreground(COLORS[component]));
            }
            pos = end;
        }
        if (pos < buffer.length()) {
            builder.append((CharSequence)buffer.substring(pos), AttributedStyle.DEFAULT.foreground(1));
        }
        return builder.toAttributedString();
    }

    public void setErrorPattern(Pattern errorPattern) {
    }

    public void setErrorIndex(int errorIndex) {
    }
}

