/*
 * Decompiled with CFR 0.152.
 */
package io.papermc.paper.adventure;

import io.papermc.paper.adventure.LazyChatAudienceSet;
import io.papermc.paper.adventure.PaperAdventure;
import io.papermc.paper.chat.ChatRenderer;
import io.papermc.paper.event.player.AbstractChatEvent;
import io.papermc.paper.event.player.AsyncChatEvent;
import io.papermc.paper.event.player.ChatEvent;
import java.util.HashSet;
import java.util.Set;
import java.util.concurrent.ExecutionException;
import java.util.function.Consumer;
import java.util.regex.Pattern;
import net.kyori.adventure.audience.Audience;
import net.kyori.adventure.audience.MessageType;
import net.kyori.adventure.identity.Identified;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.TextReplacementConfig;
import net.kyori.adventure.text.event.ClickEvent;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.EntityPlayer;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.craftbukkit.v1_18_R1.CraftWorld;
import org.bukkit.craftbukkit.v1_18_R1.entity.CraftPlayer;
import org.bukkit.craftbukkit.v1_18_R1.util.LazyPlayerSet;
import org.bukkit.craftbukkit.v1_18_R1.util.Waitable;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;
import org.bukkit.event.HandlerList;
import org.bukkit.event.player.AsyncPlayerChatEvent;
import org.bukkit.event.player.PlayerChatEvent;

public final class ChatProcessor {
    private static final Pattern DEFAULT_URL_PATTERN = Pattern.compile("(?:(https?)://)?([-\\w_.]+\\.\\w{2,})(/\\S*)?");
    private static final Pattern URL_SCHEME_PATTERN = Pattern.compile("^[a-z][a-z0-9+\\-.]*:");
    private static final TextReplacementConfig URL_REPLACEMENT_CONFIG = (TextReplacementConfig)TextReplacementConfig.builder().match(DEFAULT_URL_PATTERN).replacement(url -> {
        Object clickUrl = url.content();
        if (!URL_SCHEME_PATTERN.matcher((CharSequence)clickUrl).find()) {
            clickUrl = "http://" + (String)clickUrl;
        }
        return url.clickEvent(ClickEvent.openUrl((String)clickUrl));
    }).build();
    private static final String DEFAULT_LEGACY_FORMAT = "<%1$s> %2$s";
    final MinecraftServer server;
    final EntityPlayer player;
    final String message;
    final boolean async;
    final Component originalMessage;

    public ChatProcessor(MinecraftServer server, EntityPlayer player, String message, boolean async) {
        this.server = server;
        this.player = player;
        this.message = message;
        this.async = async;
        this.originalMessage = Component.text((String)message);
    }

    public void process() {
        this.processingLegacyFirst(event -> this.processModern(ChatProcessor.legacyRenderer(event.getFormat()), this.viewersFromLegacy(event.getRecipients()), (Component)PaperAdventure.LEGACY_SECTION_UXRC.deserialize(event.getMessage()), event.isCancelled()), event -> this.processModern(ChatProcessor.legacyRenderer(event.getFormat()), this.viewersFromLegacy(event.getRecipients()), (Component)PaperAdventure.LEGACY_SECTION_UXRC.deserialize(event.getMessage()), event.isCancelled()), () -> this.processModern(ChatRenderer.defaultRenderer(), new LazyChatAudienceSet(this.server), Component.text((String)this.message).replaceText(URL_REPLACEMENT_CONFIG), false));
    }

    private Set<Audience> viewersFromLegacy(Set<Player> recipients) {
        LazyPlayerSet lazyPlayerSet;
        if (recipients instanceof LazyPlayerSet && (lazyPlayerSet = (LazyPlayerSet)recipients).isLazy()) {
            return new LazyChatAudienceSet(this.server);
        }
        HashSet<Player> viewers = new HashSet<Player>(recipients);
        viewers.add((Player)this.server.console);
        return viewers;
    }

    private void processingLegacyFirst(Consumer<AsyncPlayerChatEvent> continueAfterAsync, Consumer<PlayerChatEvent> continueAfterAsyncAndSync, Runnable modernOnly) {
        boolean listenersOnAsyncEvent = ChatProcessor.anyListeners(AsyncPlayerChatEvent.getHandlerList());
        boolean listenersOnSyncEvent = ChatProcessor.anyListeners(PlayerChatEvent.getHandlerList());
        if (listenersOnAsyncEvent || listenersOnSyncEvent) {
            CraftPlayer player = this.player.getBukkitEntity();
            AsyncPlayerChatEvent ae = new AsyncPlayerChatEvent(this.async, (Player)player, this.message, (Set)new LazyPlayerSet(this.server));
            ChatProcessor.post((Event)ae);
            if (listenersOnSyncEvent) {
                final PlayerChatEvent se = new PlayerChatEvent((Player)player, ae.getMessage(), ae.getFormat(), ae.getRecipients());
                se.setCancelled(ae.isCancelled());
                this.queueIfAsyncOrRunImmediately(new Waitable<Void>(){

                    @Override
                    protected Void evaluate() {
                        ChatProcessor.post((Event)se);
                        return null;
                    }
                });
                continueAfterAsyncAndSync.accept(se);
            } else {
                continueAfterAsync.accept(ae);
            }
        } else {
            modernOnly.run();
        }
    }

    private void processModern(ChatRenderer renderer, Set<Audience> viewers, Component message, boolean cancelled) {
        AsyncChatEvent ae = this.createAsync(renderer, viewers, message);
        ae.setCancelled(cancelled);
        ChatProcessor.post((Event)ae);
        boolean listenersOnSyncEvent = ChatProcessor.anyListeners(ChatEvent.getHandlerList());
        if (listenersOnSyncEvent) {
            this.continueWithSyncFromWhereAsyncLeftOff(ae);
        } else {
            this.complete((AbstractChatEvent)ae);
        }
    }

    private void continueWithSyncFromWhereAsyncLeftOff(final AsyncChatEvent ae) {
        this.queueIfAsyncOrRunImmediately(new Waitable<Void>(){

            @Override
            protected Void evaluate() {
                ChatEvent se = ChatProcessor.this.createSync(ae.renderer(), ae.viewers(), ae.message());
                se.setCancelled(ae.isCancelled());
                ChatProcessor.post((Event)se);
                ChatProcessor.this.complete((AbstractChatEvent)se);
                return null;
            }
        });
    }

    private void complete(AbstractChatEvent event) {
        LazyChatAudienceSet lazyAudienceSet;
        if (event.isCancelled()) {
            return;
        }
        CraftPlayer player = this.player.getBukkitEntity();
        Component displayName = ChatProcessor.displayName(player);
        Component message = event.message();
        ChatRenderer renderer = event.renderer();
        Set viewers = event.viewers();
        if (viewers instanceof LazyChatAudienceSet && (lazyAudienceSet = (LazyChatAudienceSet)viewers).isLazy()) {
            this.server.console.sendMessage((Identified)player, renderer.render((Player)player, displayName, message, (Audience)this.server.console), MessageType.CHAT);
            for (EntityPlayer viewer : this.server.ac().t()) {
                CraftPlayer bukkit = viewer.getBukkitEntity();
                bukkit.sendMessage((Identified)player, renderer.render((Player)player, displayName, message, (Audience)bukkit), MessageType.CHAT);
            }
        } else {
            for (Audience viewer : viewers) {
                viewer.sendMessage((Identified)player, renderer.render((Player)player, displayName, message, viewer), MessageType.CHAT);
            }
        }
    }

    private AsyncChatEvent createAsync(ChatRenderer renderer, Set<Audience> viewers, Component message) {
        return new AsyncChatEvent(this.async, (Player)this.player.getBukkitEntity(), viewers, renderer, message, this.originalMessage);
    }

    private ChatEvent createSync(ChatRenderer renderer, Set<Audience> viewers, Component message) {
        return new ChatEvent((Player)this.player.getBukkitEntity(), viewers, renderer, message, this.originalMessage);
    }

    private static String legacyDisplayName(CraftPlayer player) {
        if (((CraftWorld)player.getWorld()).getHandle().paperConfig.useVanillaScoreboardColoring) {
            return PaperAdventure.LEGACY_SECTION_UXRC.serialize(player.teamDisplayName()) + ChatColor.RESET;
        }
        return player.getDisplayName();
    }

    private static Component displayName(CraftPlayer player) {
        if (((CraftWorld)player.getWorld()).getHandle().paperConfig.useVanillaScoreboardColoring) {
            return player.teamDisplayName();
        }
        return player.displayName();
    }

    private static ChatRenderer legacyRenderer(String format) {
        if (DEFAULT_LEGACY_FORMAT.equals(format)) {
            return ChatRenderer.defaultRenderer();
        }
        return ChatRenderer.viewerUnaware((player, displayName, message) -> PaperAdventure.LEGACY_SECTION_UXRC.deserialize(String.format(format, ChatProcessor.legacyDisplayName((CraftPlayer)player), PaperAdventure.LEGACY_SECTION_UXRC.serialize(message))).replaceText(URL_REPLACEMENT_CONFIG));
    }

    private void queueIfAsyncOrRunImmediately(Waitable<Void> waitable) {
        if (this.async) {
            this.server.processQueue.add(waitable);
        } else {
            waitable.run();
        }
        try {
            waitable.get();
        }
        catch (InterruptedException e2) {
            Thread.currentThread().interrupt();
        }
        catch (ExecutionException e3) {
            throw new RuntimeException("Exception processing chat", e3.getCause());
        }
    }

    private static void post(Event event) {
        Bukkit.getPluginManager().callEvent(event);
    }

    private static boolean anyListeners(HandlerList handlers) {
        return handlers.getRegisteredListeners().length > 0;
    }
}

