/*
 * Decompiled with CFR 0.152.
 */
package com.destroystokyo.paper.util.pooled;

import java.util.ArrayDeque;
import java.util.function.Consumer;
import java.util.function.Supplier;
import net.minecraft.server.MCUtil;
import org.apache.commons.lang3.mutable.MutableInt;

public final class PooledObjects<E> {
    public static final PooledObjects<MutableInt> POOLED_MUTABLE_INTEGERS = new PooledObjects<MutableInt>(MutableInt::new, 1024);
    private final Supplier<E> creator;
    private final Consumer<E> releaser;
    private final int maxPoolSize;
    private final ArrayDeque<E> queue;

    public PooledObjects(Supplier<E> creator, int maxPoolSize) {
        this(creator, maxPoolSize, null);
    }

    public PooledObjects(Supplier<E> creator, int maxPoolSize, Consumer<E> releaser) {
        if (creator == null) {
            throw new NullPointerException("Creator must not be null");
        }
        if (maxPoolSize <= 0) {
            throw new IllegalArgumentException("Max pool size must be greater-than 0");
        }
        this.queue = new ArrayDeque(maxPoolSize);
        this.maxPoolSize = maxPoolSize;
        this.creator = creator;
        this.releaser = releaser;
    }

    public AutoReleased acquireCleaner(Object holder) {
        return this.acquireCleaner(holder, this::release);
    }

    public AutoReleased acquireCleaner(Object holder, Consumer<E> releaser) {
        E resource = this.acquire();
        Runnable cleaner = MCUtil.registerCleaner(holder, resource, releaser);
        return new AutoReleased(resource, cleaner);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final E acquire() {
        E value;
        ArrayDeque<E> arrayDeque = this.queue;
        synchronized (arrayDeque) {
            value = this.queue.pollLast();
        }
        return value != null ? value : this.creator.get();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void release(E value) {
        if (this.releaser != null) {
            this.releaser.accept(value);
        }
        ArrayDeque<E> arrayDeque = this.queue;
        synchronized (arrayDeque) {
            if (this.queue.size() < this.maxPoolSize) {
                this.queue.addLast(value);
            }
        }
    }

    public class AutoReleased {
        private final E object;
        private final Runnable cleaner;

        public AutoReleased(E object, Runnable cleaner) {
            this.object = object;
            this.cleaner = cleaner;
        }

        public final E getObject() {
            return this.object;
        }

        public final Runnable getCleaner() {
            return this.cleaner;
        }
    }
}

