/*
 * Decompiled with CFR 0.152.
 */
package com.destroystokyo.paper.util;

import it.unimi.dsi.fastutil.objects.Object2ObjectOpenHashMap;
import it.unimi.dsi.fastutil.objects.ObjectLinkedOpenHashSet;
import java.lang.ref.WeakReference;
import java.util.Iterator;

public class PooledHashSets<E> {
    protected final Object2ObjectOpenHashMap<PooledObjectLinkedOpenHashSet<E>, PooledObjectLinkedOpenHashSet<E>> mapPool = new Object2ObjectOpenHashMap(64, 0.25f);

    protected void decrementReferenceCount(PooledObjectLinkedOpenHashSet<E> current) {
        if (current.referenceCount == 0) {
            throw new IllegalStateException("Cannot decrement reference count for " + current);
        }
        if (current.referenceCount == -1 || --current.referenceCount > 0) {
            return;
        }
        this.mapPool.remove(current);
    }

    public PooledObjectLinkedOpenHashSet<E> findMapWith(PooledObjectLinkedOpenHashSet<E> current, E object) {
        PooledObjectLinkedOpenHashSet<E> cached = current.getAddCache(object);
        if (cached != null) {
            if (cached.referenceCount != -1) {
                ++cached.referenceCount;
            }
            this.decrementReferenceCount(current);
            return cached;
        }
        if (!current.add(object)) {
            return current;
        }
        PooledObjectLinkedOpenHashSet<E> ret = (PooledObjectLinkedOpenHashSet<E>)this.mapPool.get(current);
        if (ret == null) {
            ret = new PooledObjectLinkedOpenHashSet<E>(current);
            current.remove(object);
            this.mapPool.put(ret, ret);
            ret.referenceCount = 1;
        } else {
            if (ret.referenceCount != -1) {
                ++ret.referenceCount;
            }
            current.remove(object);
        }
        current.updateAddCache(object, ret);
        this.decrementReferenceCount(current);
        return ret;
    }

    public PooledObjectLinkedOpenHashSet<E> findMapWithout(PooledObjectLinkedOpenHashSet<E> current, E object) {
        if (current.set.size() == 1) {
            this.decrementReferenceCount(current);
            return null;
        }
        PooledObjectLinkedOpenHashSet<E> cached = current.getRemoveCache(object);
        if (cached != null) {
            if (cached.referenceCount != -1) {
                ++cached.referenceCount;
            }
            this.decrementReferenceCount(current);
            return cached;
        }
        if (!current.remove(object)) {
            return current;
        }
        PooledObjectLinkedOpenHashSet<E> ret = (PooledObjectLinkedOpenHashSet<E>)this.mapPool.get(current);
        if (ret == null) {
            ret = new PooledObjectLinkedOpenHashSet<E>(current);
            current.add(object);
            this.mapPool.put(ret, ret);
            ret.referenceCount = 1;
        } else {
            if (ret.referenceCount != -1) {
                ++ret.referenceCount;
            }
            current.add(object);
        }
        current.updateRemoveCache(object, ret);
        this.decrementReferenceCount(current);
        return ret;
    }

    public static final class PooledObjectLinkedOpenHashSet<E>
    implements Iterable<E> {
        private static final WeakReference NULL_REFERENCE = new WeakReference<Object>(null);
        final ObjectLinkedOpenHashSet<E> set;
        int referenceCount;
        int hash;
        WeakReference<E> lastAddObject = NULL_REFERENCE;
        WeakReference<PooledObjectLinkedOpenHashSet<E>> lastAddMap = NULL_REFERENCE;
        WeakReference<E> lastRemoveObject = NULL_REFERENCE;
        WeakReference<PooledObjectLinkedOpenHashSet<E>> lastRemoveMap = NULL_REFERENCE;

        public PooledObjectLinkedOpenHashSet() {
            this.set = new ObjectLinkedOpenHashSet(2, 0.6f);
        }

        public PooledObjectLinkedOpenHashSet(E single) {
            this();
            this.referenceCount = -1;
            this.add(single);
        }

        public PooledObjectLinkedOpenHashSet(PooledObjectLinkedOpenHashSet<E> other) {
            this.set = other.set.clone();
            this.hash = other.hash;
        }

        static int hash0(int x2) {
            x2 *= 915625301;
            x2 ^= x2 >>> 16;
            return x2;
        }

        public PooledObjectLinkedOpenHashSet<E> getAddCache(E element) {
            Object currentAdd = this.lastAddObject.get();
            if (currentAdd == null || currentAdd != element && !currentAdd.equals(element)) {
                return null;
            }
            PooledObjectLinkedOpenHashSet map = (PooledObjectLinkedOpenHashSet)this.lastAddMap.get();
            if (map == null || map.referenceCount == 0) {
                return null;
            }
            return map;
        }

        public PooledObjectLinkedOpenHashSet<E> getRemoveCache(E element) {
            Object currentRemove = this.lastRemoveObject.get();
            if (currentRemove == null || currentRemove != element && !currentRemove.equals(element)) {
                return null;
            }
            PooledObjectLinkedOpenHashSet map = (PooledObjectLinkedOpenHashSet)this.lastRemoveMap.get();
            if (map == null || map.referenceCount == 0) {
                return null;
            }
            return map;
        }

        public void updateAddCache(E element, PooledObjectLinkedOpenHashSet<E> map) {
            this.lastAddObject = new WeakReference<E>(element);
            this.lastAddMap = new WeakReference<PooledObjectLinkedOpenHashSet<E>>(map);
        }

        public void updateRemoveCache(E element, PooledObjectLinkedOpenHashSet<E> map) {
            this.lastRemoveObject = new WeakReference<E>(element);
            this.lastRemoveMap = new WeakReference<PooledObjectLinkedOpenHashSet<E>>(map);
        }

        boolean add(E element) {
            boolean added = this.set.add(element);
            if (added) {
                this.hash += PooledObjectLinkedOpenHashSet.hash0(element.hashCode());
            }
            return added;
        }

        boolean remove(Object element) {
            boolean removed = this.set.remove(element);
            if (removed) {
                this.hash -= PooledObjectLinkedOpenHashSet.hash0(element.hashCode());
            }
            return removed;
        }

        @Override
        public Iterator<E> iterator() {
            return this.set.iterator();
        }

        public int hashCode() {
            return this.hash;
        }

        public boolean equals(Object other) {
            if (!(other instanceof PooledObjectLinkedOpenHashSet)) {
                return false;
            }
            if (this.referenceCount == 0) {
                return other == this;
            }
            if (other == this) {
                return false;
            }
            return this.hash == ((PooledObjectLinkedOpenHashSet)other).hash && this.set.equals(((PooledObjectLinkedOpenHashSet)other).set);
        }

        public String toString() {
            return "PooledHashSet: size: " + this.set.size() + ", reference count: " + this.referenceCount + ", hash: " + this.hashCode() + ", identity: " + System.identityHashCode(this) + " map: " + this.set.toString();
        }
    }
}

