/*
 * Decompiled with CFR 0.152.
 */
package com.destroystokyo.paper.util;

import com.destroystokyo.paper.util.PooledHashSets;
import it.unimi.dsi.fastutil.longs.Long2ObjectMap;
import it.unimi.dsi.fastutil.longs.Long2ObjectOpenHashMap;
import it.unimi.dsi.fastutil.objects.ObjectLinkedOpenHashSet;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.core.SectionPosition;
import net.minecraft.server.level.EntityPlayer;
import net.minecraft.world.level.ChunkCoordIntPair;
import org.spigotmc.AsyncCatcher;

public final class PlayerMobDistanceMap {
    private static final PooledHashSets.PooledObjectLinkedOpenHashSet<EntityPlayer> EMPTY_SET = new PooledHashSets.PooledObjectLinkedOpenHashSet();
    private final Map<EntityPlayer, SectionPosition> players = new HashMap<EntityPlayer, SectionPosition>();
    private final Long2ObjectOpenHashMap<PooledHashSets.PooledObjectLinkedOpenHashSet<EntityPlayer>> playerMap = new Long2ObjectOpenHashMap(32, 0.5f);
    private int viewDistance;
    private final PooledHashSets<EntityPlayer> pooledHashSets = new PooledHashSets();

    public PooledHashSets.PooledObjectLinkedOpenHashSet<EntityPlayer> getPlayersInRange(ChunkCoordIntPair chunkPos) {
        return this.getPlayersInRange(chunkPos.c, chunkPos.d);
    }

    public PooledHashSets.PooledObjectLinkedOpenHashSet<EntityPlayer> getPlayersInRange(int chunkX, int chunkZ) {
        return (PooledHashSets.PooledObjectLinkedOpenHashSet)this.playerMap.getOrDefault(ChunkCoordIntPair.a(chunkX, chunkZ), EMPTY_SET);
    }

    public void update(List<EntityPlayer> currentPlayers, int newViewDistance) {
        AsyncCatcher.catchOp("Distance map update");
        ObjectLinkedOpenHashSet gone = new ObjectLinkedOpenHashSet(this.players.keySet());
        int oldViewDistance = this.viewDistance;
        this.viewDistance = newViewDistance;
        for (EntityPlayer player : currentPlayers) {
            if (player.B_() || !player.affectsSpawning) continue;
            gone.remove((Object)player);
            SectionPosition newPosition = player.R();
            SectionPosition oldPosition = this.players.put(player, newPosition);
            if (oldPosition == null) {
                this.addNewPlayer(player, newPosition, newViewDistance);
                continue;
            }
            this.updatePlayer(player, oldPosition, newPosition, oldViewDistance, newViewDistance);
        }
        for (EntityPlayer player : gone) {
            SectionPosition oldPosition = this.players.remove(player);
            if (oldPosition == null) continue;
            this.removePlayer(player, oldPosition, oldViewDistance);
        }
    }

    private void validatePlayer(EntityPlayer player, int viewDistance) {
        int entiesGot = 0;
        int expectedEntries = 2 * viewDistance + 1;
        expectedEntries *= expectedEntries;
        SectionPosition currPosition = player.R();
        int centerX = currPosition.u();
        int centerZ = currPosition.w();
        for (Long2ObjectMap.Entry entry : this.playerMap.long2ObjectEntrySet()) {
            long key = entry.getLongKey();
            PooledHashSets.PooledObjectLinkedOpenHashSet map = (PooledHashSets.PooledObjectLinkedOpenHashSet)entry.getValue();
            if (map.referenceCount == 0) {
                throw new IllegalStateException("Invalid map");
            }
            if (!map.set.contains((Object)player)) continue;
            ++entiesGot;
            int chunkX = ChunkCoordIntPair.a(key);
            int chunkZ = ChunkCoordIntPair.b(key);
            int dist = Math.max(Math.abs(chunkX - centerX), Math.abs(chunkZ - centerZ));
            if (dist <= viewDistance) continue;
            throw new IllegalStateException("Expected view distance " + viewDistance + ", got " + dist);
        }
        if (entiesGot != expectedEntries) {
            throw new IllegalStateException("Expected " + expectedEntries + ", got " + entiesGot);
        }
    }

    private void addPlayerTo(EntityPlayer player, int chunkX, int chunkZ) {
        this.playerMap.compute(ChunkCoordIntPair.a(chunkX, chunkZ), (key, players) -> {
            if (players == null) {
                return player.cachedSingleMobDistanceMap;
            }
            return this.pooledHashSets.findMapWith((PooledHashSets.PooledObjectLinkedOpenHashSet<EntityPlayer>)players, player);
        });
    }

    private void removePlayerFrom(EntityPlayer player, int chunkX, int chunkZ) {
        this.playerMap.compute(ChunkCoordIntPair.a(chunkX, chunkZ), (keyInMap, players) -> this.pooledHashSets.findMapWithout((PooledHashSets.PooledObjectLinkedOpenHashSet<EntityPlayer>)players, player));
    }

    private void updatePlayer(EntityPlayer player, SectionPosition oldPosition, SectionPosition newPosition, int oldViewDistance, int newViewDistance) {
        int totalZ;
        int toX = newPosition.u();
        int toZ = newPosition.w();
        int fromX = oldPosition.u();
        int fromZ = oldPosition.w();
        int dx = toX - fromX;
        int dz = toZ - fromZ;
        int totalX = Math.abs(fromX - toX);
        if (Math.max(totalX, totalZ = Math.abs(fromZ - toZ)) > 2 * oldViewDistance) {
            this.removePlayer(player, oldPosition, oldViewDistance);
            this.addNewPlayer(player, newPosition, newViewDistance);
            return;
        }
        if (oldViewDistance == newViewDistance) {
            int currZ;
            int currX;
            int minZ;
            int maxZ;
            int minX;
            int maxX;
            int up = 1 | dz >> 31;
            int right = 1 | dx >> 31;
            if (dx != 0) {
                maxX = toX + oldViewDistance * right + right;
                minX = fromX + oldViewDistance * right + right;
                maxZ = fromZ + oldViewDistance * up + up;
                minZ = toZ - oldViewDistance * up;
                for (currX = minX; currX != maxX; currX += right) {
                    for (currZ = minZ; currZ != maxZ; currZ += up) {
                        this.addPlayerTo(player, currX, currZ);
                    }
                }
            }
            if (dz != 0) {
                maxX = toX + oldViewDistance * right + right;
                minX = toX - oldViewDistance * right;
                maxZ = toZ + oldViewDistance * up + up;
                minZ = fromZ + oldViewDistance * up + up;
                for (currX = minX; currX != maxX; currX += right) {
                    for (currZ = minZ; currZ != maxZ; currZ += up) {
                        this.addPlayerTo(player, currX, currZ);
                    }
                }
            }
            if (dx != 0) {
                maxX = toX - oldViewDistance * right;
                minX = fromX - oldViewDistance * right;
                maxZ = fromZ + oldViewDistance * up + up;
                minZ = toZ - oldViewDistance * up;
                for (currX = minX; currX != maxX; currX += right) {
                    for (currZ = minZ; currZ != maxZ; currZ += up) {
                        this.removePlayerFrom(player, currX, currZ);
                    }
                }
            }
            if (dz != 0) {
                maxX = fromX + oldViewDistance * right + right;
                minX = fromX - oldViewDistance * right;
                maxZ = toZ - oldViewDistance * up;
                minZ = fromZ - oldViewDistance * up;
                for (currX = minX; currX != maxX; currX += right) {
                    for (currZ = minZ; currZ != maxZ; currZ += up) {
                        this.removePlayerFrom(player, currX, currZ);
                    }
                }
            }
        } else {
            this.removePlayer(player, oldPosition, oldViewDistance);
            this.addNewPlayer(player, newPosition, newViewDistance);
        }
    }

    private void removePlayer(EntityPlayer player, SectionPosition position, int viewDistance) {
        int x2 = position.u();
        int z2 = position.w();
        for (int xoff = -viewDistance; xoff <= viewDistance; ++xoff) {
            for (int zoff = -viewDistance; zoff <= viewDistance; ++zoff) {
                this.removePlayerFrom(player, x2 + xoff, z2 + zoff);
            }
        }
    }

    private void addNewPlayer(EntityPlayer player, SectionPosition position, int viewDistance) {
        int x2 = position.u();
        int z2 = position.w();
        for (int xoff = -viewDistance; xoff <= viewDistance; ++xoff) {
            for (int zoff = -viewDistance; zoff <= viewDistance; ++zoff) {
                this.addPlayerTo(player, x2 + xoff, z2 + zoff);
            }
        }
    }
}

