/*
 * Decompiled with CFR 0.152.
 */
package com.destroystokyo.paper.profile;

import com.destroystokyo.paper.PaperConfig;
import com.destroystokyo.paper.profile.PlayerProfile;
import com.destroystokyo.paper.profile.ProfileProperty;
import com.google.common.base.Charsets;
import com.mojang.authlib.GameProfile;
import com.mojang.authlib.properties.Property;
import com.mojang.authlib.properties.PropertyMap;
import java.util.AbstractSet;
import java.util.Collection;
import java.util.Iterator;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.UUID;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.players.UserCache;
import org.apache.commons.lang3.Validate;
import org.bukkit.craftbukkit.v1_18_R1.entity.CraftPlayer;

public class CraftPlayerProfile
implements PlayerProfile {
    private GameProfile profile;
    private final PropertySet properties = new PropertySet();

    public CraftPlayerProfile(CraftPlayer player) {
        this.profile = player.getHandle().fp();
    }

    public CraftPlayerProfile(UUID id, String name) {
        this.profile = new GameProfile(id, name);
    }

    public CraftPlayerProfile(GameProfile profile) {
        Validate.notNull((Object)profile, (String)"GameProfile cannot be null!", (Object[])new Object[0]);
        this.profile = profile;
    }

    public boolean hasProperty(String property) {
        return this.profile.getProperties().containsKey((Object)property);
    }

    public void setProperty(ProfileProperty property) {
        String name = property.getName();
        PropertyMap properties = this.profile.getProperties();
        properties.removeAll((Object)name);
        properties.put((Object)name, (Object)new Property(name, property.getValue(), property.getSignature()));
    }

    public GameProfile getGameProfile() {
        return this.profile;
    }

    @Nullable
    public UUID getId() {
        return this.profile.getId();
    }

    public UUID setId(@Nullable UUID uuid) {
        GameProfile prev = this.profile;
        this.profile = new GameProfile(uuid, prev.getName());
        CraftPlayerProfile.copyProfileProperties(prev, this.profile);
        return prev.getId();
    }

    @Nullable
    public String getName() {
        return this.profile.getName();
    }

    public String setName(@Nullable String name) {
        GameProfile prev = this.profile;
        this.profile = new GameProfile(prev.getId(), name);
        CraftPlayerProfile.copyProfileProperties(prev, this.profile);
        return prev.getName();
    }

    @Nonnull
    public Set<ProfileProperty> getProperties() {
        return this.properties;
    }

    public void setProperties(Collection<ProfileProperty> properties) {
        properties.forEach(this::setProperty);
    }

    public void clearProperties() {
        this.profile.getProperties().clear();
    }

    public boolean removeProperty(String property) {
        return !this.profile.getProperties().removeAll((Object)property).isEmpty();
    }

    public boolean equals(Object o2) {
        if (this == o2) {
            return true;
        }
        if (o2 == null || this.getClass() != o2.getClass()) {
            return false;
        }
        CraftPlayerProfile that = (CraftPlayerProfile)o2;
        return Objects.equals(this.profile, that.profile);
    }

    public int hashCode() {
        return this.profile.hashCode();
    }

    public String toString() {
        return this.profile.toString();
    }

    public CraftPlayerProfile clone() {
        CraftPlayerProfile clone = new CraftPlayerProfile(this.getId(), this.getName());
        clone.setProperties(this.getProperties());
        return clone;
    }

    public boolean isComplete() {
        return this.profile.isComplete();
    }

    public boolean completeFromCache() {
        MinecraftServer server = MinecraftServer.getServer();
        return this.completeFromCache(false, PaperConfig.isProxyOnlineMode());
    }

    public boolean completeFromCache(boolean onlineMode) {
        return this.completeFromCache(false, onlineMode);
    }

    public boolean completeFromCache(boolean lookupUUID, boolean onlineMode) {
        Optional<GameProfile> optProfile;
        GameProfile profile;
        MinecraftServer server = MinecraftServer.getServer();
        String name = this.profile.getName();
        UserCache userCache = server.ao();
        if (this.profile.getId() == null && (profile = onlineMode ? (lookupUUID ? (GameProfile)userCache.a(name).orElse(null) : userCache.getProfileIfCached(name)) : new GameProfile(UUID.nameUUIDFromBytes(("OfflinePlayer:" + name).getBytes(Charsets.UTF_8)), name)) != null) {
            CraftPlayerProfile.copyProfileProperties(this.profile, profile);
            this.profile = profile;
        }
        if ((this.profile.getName() == null || !this.hasTextures()) && this.profile.getId() != null && (optProfile = userCache.a(this.profile.getId())).isPresent()) {
            GameProfile profile2 = optProfile.get();
            if (this.profile.getName() == null) {
                CraftPlayerProfile.copyProfileProperties(this.profile, profile2);
                this.profile = profile2;
            } else {
                CraftPlayerProfile.copyProfileProperties(profile2, this.profile);
            }
        }
        return this.profile.isComplete();
    }

    public boolean complete(boolean textures) {
        MinecraftServer server = MinecraftServer.getServer();
        return this.complete(textures, PaperConfig.isProxyOnlineMode());
    }

    public boolean complete(boolean textures, boolean onlineMode) {
        MinecraftServer server = MinecraftServer.getServer();
        boolean isCompleteFromCache = this.completeFromCache(true, onlineMode);
        if (onlineMode && (!isCompleteFromCache || textures && !this.hasTextures())) {
            GameProfile result = server.am().fillProfileProperties(this.profile, true);
            if (result != null) {
                CraftPlayerProfile.copyProfileProperties(result, this.profile, true);
            }
            if (this.profile.isComplete()) {
                server.ao().a(this.profile);
            }
        }
        return this.profile.isComplete() && (!onlineMode || !textures || this.hasTextures());
    }

    private static void copyProfileProperties(GameProfile source, GameProfile target) {
        CraftPlayerProfile.copyProfileProperties(source, target, false);
    }

    private static void copyProfileProperties(GameProfile source, GameProfile target, boolean clearTarget) {
        PropertyMap sourceProperties = source.getProperties();
        PropertyMap targetProperties = target.getProperties();
        if (clearTarget) {
            targetProperties.clear();
        }
        if (sourceProperties.isEmpty()) {
            return;
        }
        for (Property property : sourceProperties.values()) {
            targetProperties.removeAll((Object)property.getName());
            targetProperties.put((Object)property.getName(), (Object)property);
        }
    }

    private static ProfileProperty toBukkit(Property property) {
        return new ProfileProperty(property.getName(), property.getValue(), property.getSignature());
    }

    public static PlayerProfile asBukkitCopy(GameProfile gameProfile) {
        CraftPlayerProfile profile = new CraftPlayerProfile(gameProfile.getId(), gameProfile.getName());
        CraftPlayerProfile.copyProfileProperties(gameProfile, profile.profile);
        return profile;
    }

    public static PlayerProfile asBukkitMirror(GameProfile profile) {
        return new CraftPlayerProfile(profile);
    }

    public static Property asAuthlib(ProfileProperty property) {
        return new Property(property.getName(), property.getValue(), property.getSignature());
    }

    public static GameProfile asAuthlibCopy(PlayerProfile profile) {
        CraftPlayerProfile craft = (CraftPlayerProfile)profile;
        return CraftPlayerProfile.asAuthlib(craft.clone());
    }

    public static GameProfile asAuthlib(PlayerProfile profile) {
        CraftPlayerProfile craft = (CraftPlayerProfile)profile;
        return craft.getGameProfile();
    }

    private class PropertySet
    extends AbstractSet<ProfileProperty> {
        private PropertySet() {
        }

        @Override
        @Nonnull
        public Iterator<ProfileProperty> iterator() {
            return new ProfilePropertyIterator(CraftPlayerProfile.this.profile.getProperties().values().iterator());
        }

        @Override
        public int size() {
            return CraftPlayerProfile.this.profile.getProperties().size();
        }

        @Override
        public boolean add(ProfileProperty property) {
            CraftPlayerProfile.this.setProperty(property);
            return true;
        }

        @Override
        public boolean addAll(Collection<? extends ProfileProperty> c2) {
            CraftPlayerProfile.this.setProperties(c2);
            return true;
        }

        @Override
        public boolean contains(Object o2) {
            return o2 instanceof ProfileProperty && CraftPlayerProfile.this.profile.getProperties().containsKey((Object)((ProfileProperty)o2).getName());
        }

        private class ProfilePropertyIterator
        implements Iterator<ProfileProperty> {
            private final Iterator<Property> iterator;

            ProfilePropertyIterator(Iterator<Property> iterator) {
                this.iterator = iterator;
            }

            @Override
            public boolean hasNext() {
                return this.iterator.hasNext();
            }

            @Override
            public ProfileProperty next() {
                return CraftPlayerProfile.toBukkit(this.iterator.next());
            }

            @Override
            public void remove() {
                this.iterator.remove();
            }
        }
    }
}

