/*
 * Decompiled with CFR 0.152.
 */
package com.destroystokyo.paper.io.chunk;

import co.aikar.timings.Timing;
import com.destroystokyo.paper.io.IOUtil;
import com.destroystokyo.paper.io.PaperFileIOThread;
import com.destroystokyo.paper.io.chunk.ChunkTask;
import com.destroystokyo.paper.io.chunk.ChunkTaskManager;
import java.util.ArrayDeque;
import java.util.function.Consumer;
import net.minecraft.server.level.PlayerChunkMap;
import net.minecraft.server.level.WorldServer;
import net.minecraft.world.level.ChunkCoordIntPair;
import net.minecraft.world.level.chunk.storage.ChunkRegionLoader;

public final class ChunkLoadTask
extends ChunkTask {
    public boolean cancelled;
    Consumer<ChunkRegionLoader.InProgressChunkHolder> onComplete;
    public PaperFileIOThread.ChunkData chunkData;
    private boolean hasCompleted;
    private static final ArrayDeque<Runnable> EMPTY_QUEUE = new ArrayDeque();

    public ChunkLoadTask(WorldServer world, int chunkX, int chunkZ, int priority, ChunkTaskManager taskManager, Consumer<ChunkRegionLoader.InProgressChunkHolder> onComplete) {
        super(world, chunkX, chunkZ, priority, taskManager);
        this.onComplete = onComplete;
    }

    private static ChunkRegionLoader.InProgressChunkHolder createEmptyHolder() {
        return new ChunkRegionLoader.InProgressChunkHolder(null, EMPTY_QUEUE);
    }

    @Override
    public void run() {
        block2: {
            try {
                this.executeTask();
            }
            catch (Throwable ex) {
                PaperFileIOThread.LOGGER.error("Failed to execute chunk load task: " + this.toString(), ex);
                if (this.hasCompleted) break block2;
                this.complete(ChunkLoadTask.createEmptyHolder());
            }
        }
    }

    private boolean checkCancelled() {
        if (this.cancelled) {
            return this.taskManager.chunkLoadTasks.compute(IOUtil.getCoordinateKey(this.chunkX, this.chunkZ), (keyInMap, valueInMap) -> {
                if (valueInMap != this) {
                    throw new IllegalStateException("Expected this task to be scheduled, but another was! Other: " + valueInMap + ", current: " + this);
                }
                if (valueInMap.cancelled) {
                    return null;
                }
                return valueInMap;
            }) == null;
        }
        return false;
    }

    public void executeTask() {
        if (this.checkCancelled()) {
            return;
        }
        PaperFileIOThread.ChunkData chunkData = this.chunkData;
        if (chunkData.poiData == PaperFileIOThread.FAILURE_VALUE || chunkData.chunkData == PaperFileIOThread.FAILURE_VALUE) {
            PaperFileIOThread.LOGGER.error("Could not load chunk for task: " + this.toString() + ", file IO thread has dumped the relevant exception above");
            this.complete(ChunkLoadTask.createEmptyHolder());
            return;
        }
        if (chunkData.chunkData == null) {
            this.complete(ChunkLoadTask.createEmptyHolder());
            return;
        }
        ChunkCoordIntPair chunkPos = new ChunkCoordIntPair(this.chunkX, this.chunkZ);
        PlayerChunkMap chunkManager = this.world.k().a;
        Timing ignored = this.world.timings.chunkLoadLevelTimer.startTimingIfSync();
        try {
            ChunkRegionLoader.InProgressChunkHolder chunkHolder;
            try {
                chunkData.chunkData = chunkManager.upgradeChunkTag(this.world.getTypeKey(), chunkManager.u, chunkData.chunkData, chunkManager.t.b(), chunkPos, this.world);
            }
            catch (Throwable ex) {
                PaperFileIOThread.LOGGER.error("Could not apply datafixers for chunk task: " + this.toString(), ex);
                this.complete(ChunkLoadTask.createEmptyHolder());
                if (ignored != null) {
                    ignored.close();
                }
                return;
            }
            if (this.checkCancelled()) {
                return;
            }
            try {
                chunkHolder = ChunkRegionLoader.loadChunk(this.world, chunkManager.j(), chunkPos, chunkData.chunkData, true);
            }
            catch (Throwable ex) {
                PaperFileIOThread.LOGGER.error("Could not de-serialize chunk data for task: " + this.toString(), ex);
                this.complete(ChunkLoadTask.createEmptyHolder());
                if (ignored != null) {
                    ignored.close();
                }
                return;
            }
            this.complete(chunkHolder);
        }
        finally {
            if (ignored != null) {
                try {
                    ignored.close();
                }
                catch (Throwable throwable) {
                    Throwable throwable2;
                    throwable2.addSuppressed(throwable);
                }
            }
        }
    }

    private void complete(ChunkRegionLoader.InProgressChunkHolder holder) {
        this.hasCompleted = true;
        holder.poiData = this.chunkData == null ? null : this.chunkData.poiData;
        this.taskManager.chunkLoadTasks.compute(IOUtil.getCoordinateKey(this.chunkX, this.chunkZ), (keyInMap, valueInMap) -> {
            if (valueInMap != this) {
                throw new IllegalStateException("Expected this task to be scheduled, but another was! Other: " + valueInMap + ", current: " + this);
            }
            if (valueInMap.cancelled) {
                return null;
            }
            try {
                this.onComplete.accept(holder);
            }
            catch (Throwable thr) {
                PaperFileIOThread.LOGGER.error("Failed to complete chunk data for task: " + this.toString(), thr);
            }
            return null;
        });
    }
}

