/*
 * Decompiled with CFR 0.152.
 */
package com.destroystokyo.paper.io;

import com.destroystokyo.paper.io.IOUtil;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.mojang.datafixers.util.Pair;
import io.papermc.paper.util.StacktraceDeobfuscator;
import it.unimi.dsi.fastutil.longs.Long2IntMap;
import it.unimi.dsi.fastutil.longs.Long2IntOpenHashMap;
import it.unimi.dsi.fastutil.objects.Object2ObjectOpenHashMap;
import java.util.ArrayList;
import java.util.Map;
import java.util.WeakHashMap;
import net.minecraft.world.level.World;

public class SyncLoadFinder {
    public static final boolean ENABLED = Boolean.getBoolean("paper.debug-sync-loads");
    private static final WeakHashMap<World, Object2ObjectOpenHashMap<ThrowableWithEquals, SyncLoadInformation>> SYNC_LOADS = new WeakHashMap();

    public static void clear() {
        SYNC_LOADS.clear();
    }

    public static void logSyncLoad(World world, int chunkX, int chunkZ) {
        if (!ENABLED) {
            return;
        }
        ThrowableWithEquals stacktrace = new ThrowableWithEquals(Thread.currentThread().getStackTrace());
        SYNC_LOADS.compute(world, (keyInMap, map) -> {
            if (map == null) {
                map = new Object2ObjectOpenHashMap();
            }
            map.compute((Object)stacktrace, (keyInMap0, valueInMap) -> {
                if (valueInMap == null) {
                    valueInMap = new SyncLoadInformation();
                }
                ++valueInMap.times;
                valueInMap.coordinateTimes.compute(IOUtil.getCoordinateKey(chunkX, chunkZ), (keyInMap1, valueInMap1) -> valueInMap1 == null ? Integer.valueOf(1) : Integer.valueOf(valueInMap1 + 1));
                return valueInMap;
            });
            return map;
        });
    }

    public static JsonObject serialize() {
        JsonObject ret = new JsonObject();
        JsonArray worldsData = new JsonArray();
        for (Map.Entry<World, Object2ObjectOpenHashMap<ThrowableWithEquals, SyncLoadInformation>> entry : SYNC_LOADS.entrySet()) {
            World world = entry.getKey();
            JsonObject worldData = new JsonObject();
            worldData.addProperty("name", world.getWorld().getName());
            ArrayList data = new ArrayList();
            entry.getValue().forEach((stacktrace, times) -> data.add(new Pair(stacktrace, times)));
            data.sort((pair1, pair2) -> Integer.compare(((SyncLoadInformation)pair2.getSecond()).times, ((SyncLoadInformation)pair1.getSecond()).times));
            JsonArray stacktraces = new JsonArray();
            for (Pair pair : data) {
                JsonObject stacktrace2 = new JsonObject();
                stacktrace2.addProperty("times", (Number)((SyncLoadInformation)pair.getSecond()).times);
                JsonArray traces = new JsonArray();
                for (StackTraceElement element : StacktraceDeobfuscator.INSTANCE.deobfuscateStacktrace(((ThrowableWithEquals)pair.getFirst()).stacktrace)) {
                    traces.add(String.valueOf(element));
                }
                stacktrace2.add("stacktrace", (JsonElement)traces);
                JsonArray coordinates = new JsonArray();
                for (Long2IntMap.Entry coordinate : ((SyncLoadInformation)pair.getSecond()).coordinateTimes.long2IntEntrySet()) {
                    long key = coordinate.getLongKey();
                    int times2 = coordinate.getIntValue();
                    coordinates.add("(" + IOUtil.getCoordinateX(key) + "," + IOUtil.getCoordinateZ(key) + "): " + times2);
                }
                stacktrace2.add("coordinates", (JsonElement)coordinates);
                stacktraces.add((JsonElement)stacktrace2);
            }
            worldData.add("stacktraces", (JsonElement)stacktraces);
            worldsData.add((JsonElement)worldData);
        }
        ret.add("worlds", (JsonElement)worldsData);
        return ret;
    }

    static final class ThrowableWithEquals {
        private final StackTraceElement[] stacktrace;
        private final int hash;

        public ThrowableWithEquals(StackTraceElement[] stacktrace) {
            this.stacktrace = stacktrace;
            this.hash = ThrowableWithEquals.hash(stacktrace);
        }

        public static int hash(StackTraceElement[] stacktrace) {
            int hash = 0;
            for (int i2 = 0; i2 < stacktrace.length; ++i2) {
                hash *= 31;
                hash += stacktrace[i2].hashCode();
            }
            return hash;
        }

        public int hashCode() {
            return this.hash;
        }

        public boolean equals(Object obj) {
            if (obj == null || obj.getClass() != this.getClass()) {
                return false;
            }
            ThrowableWithEquals other = (ThrowableWithEquals)obj;
            StackTraceElement[] otherStackTrace = other.stacktrace;
            if (this.stacktrace.length != otherStackTrace.length || this.hash != other.hash) {
                return false;
            }
            if (this == obj) {
                return true;
            }
            for (int i2 = 0; i2 < this.stacktrace.length; ++i2) {
                if (this.stacktrace[i2].equals(otherStackTrace[i2])) continue;
                return false;
            }
            return true;
        }
    }

    private static final class SyncLoadInformation {
        public int times;
        public final Long2IntOpenHashMap coordinateTimes = new Long2IntOpenHashMap();

        private SyncLoadInformation() {
        }
    }
}

