/*
 * Decompiled with CFR 0.152.
 */
package com.destroystokyo.paper;

import co.aikar.timings.Timings;
import co.aikar.timings.TimingsManager;
import com.destroystokyo.paper.MSPTCommand;
import com.destroystokyo.paper.Metrics;
import com.destroystokyo.paper.PaperCommand;
import com.destroystokyo.paper.io.chunk.ChunkTaskManager;
import com.google.common.base.Strings;
import com.google.common.base.Throwables;
import com.google.common.collect.Lists;
import io.papermc.paper.util.ObfHelper;
import java.io.File;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.nio.charset.StandardCharsets;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import java.util.logging.Level;
import java.util.regex.Pattern;
import net.minecraft.network.protocol.Packet;
import net.minecraft.server.MinecraftServer;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.command.Command;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.configuration.InvalidConfigurationException;
import org.bukkit.configuration.file.YamlConfiguration;
import org.spigotmc.SpigotConfig;
import org.spigotmc.WatchdogThread;

public class PaperConfig {
    private static File CONFIG_FILE;
    private static final String HEADER = "This is the main configuration file for Paper.\nAs you can see, there's tons to configure. Some options may impact gameplay, so use\nwith caution, and make sure you know what each option does before configuring.\n\nIf you need help with the configuration or have any questions related to Paper,\njoin us in our Discord or IRC channel.\n\nDiscord: https://discord.gg/papermc\nIRC: #paper @ irc.esper.net ( https://webchat.esper.net/?channels=paper ) \nWebsite: https://papermc.io/ \nDocs: https://paper.readthedocs.org/ \n";
    public static YamlConfiguration config;
    static int version;
    static Map<String, Command> commands;
    private static boolean verbose;
    private static boolean fatalError;
    private static boolean metricsStarted;
    public static boolean logPlayerIpAddresses;
    public static int maxJoinsPerTick;
    public static boolean trackPluginScoreboards;
    public static boolean fixEntityPositionDesync;
    public static boolean enableBrigadierConsoleHighlighting;
    public static boolean enableBrigadierConsoleCompletions;
    private static final Pattern SPACE;
    private static final Pattern NOT_NUMERIC;
    public static String timingsServerName;
    public static boolean useDisplayNameInQuit;
    public static boolean loadPermsBeforePlugins;
    public static int regionFileCacheSize;
    public static boolean enablePlayerCollisions;
    public static boolean saveEmptyScoreboardTeams;
    public static boolean bungeeOnlineMode;
    public static int packetInSpamThreshold;
    public static String flyingKickPlayerMessage;
    public static String flyingKickVehicleMessage;
    public static boolean suggestPlayersWhenNullTabCompletions;
    public static String authenticationServersDownKickMessage;
    public static String connectionThrottleKickMessage;
    public static String noPermissionMessage;
    public static boolean useAlternativeLuckFormula;
    public static int watchdogPrintEarlyWarningEvery;
    public static int watchdogPrintEarlyWarningDelay;
    public static int tabSpamIncrement;
    public static int tabSpamLimit;
    public static int autoRecipeIncrement;
    public static int autoRecipeLimit;
    public static boolean velocitySupport;
    public static boolean velocityOnlineMode;
    public static byte[] velocitySecretKey;
    public static int maxBookPageSize;
    public static double maxBookTotalSizeMultiplier;
    public static boolean asyncChunks;
    public static boolean deobfuscateStacktraces;
    public static boolean allowBlockPermanentBreakingExploits;
    public static boolean consoleHasAllPermissions;
    public static boolean allowPistonDuplication;
    public static int playerAutoSaveRate;
    public static int maxPlayerAutoSavePerTick;
    public static boolean allowHeadlessPistons;
    public static int itemValidationDisplayNameLength;
    public static int itemValidationLocNameLength;
    public static int itemValidationLoreLineLength;
    public static int itemValidationBookTitleLength;
    public static int itemValidationBookAuthorLength;
    public static int itemValidationBookPageLength;
    public static boolean fixTargetSelectorTagCompletion;
    public static String kickMessage;
    public static PacketLimit allPacketsLimit;
    public static Map<Class<? extends Packet<?>>, PacketLimit> packetSpecificLimits;
    public static boolean lagCompensateBlockBreaking;
    public static boolean sendFullPosForHardCollidingEntities;

    public static void init(File configFile) {
        CONFIG_FILE = configFile;
        config = new YamlConfiguration();
        try {
            config.load(CONFIG_FILE);
        }
        catch (IOException iOException) {
        }
        catch (InvalidConfigurationException ex) {
            Bukkit.getLogger().log(Level.SEVERE, "Could not load paper.yml, please correct your syntax errors", ex);
            throw Throwables.propagate((Throwable)ex);
        }
        config.options().header(HEADER);
        config.options().copyDefaults(true);
        verbose = PaperConfig.getBoolean("verbose", false);
        commands = new HashMap<String, Command>();
        commands.put("paper", new PaperCommand("paper"));
        commands.put("mspt", new MSPTCommand("mspt"));
        version = PaperConfig.getInt("config-version", 24);
        PaperConfig.set("config-version", 24);
        PaperConfig.readConfig(PaperConfig.class, null);
    }

    protected static void logError(String s2) {
        Bukkit.getLogger().severe(s2);
    }

    protected static void fatal(String s2) {
        fatalError = true;
        throw new RuntimeException("Fatal paper.yml config error: " + s2);
    }

    protected static void log(String s2) {
        if (verbose) {
            Bukkit.getLogger().info(s2);
        }
    }

    private static void playerIpAddresses() {
        logPlayerIpAddresses = PaperConfig.getBoolean("settings.log-player-ip-addresses", logPlayerIpAddresses);
    }

    private static void maxJoinsPerTick() {
        maxJoinsPerTick = PaperConfig.getInt("settings.max-joins-per-tick", 3);
    }

    private static void trackPluginScoreboards() {
        trackPluginScoreboards = PaperConfig.getBoolean("settings.track-plugin-scoreboards", false);
    }

    private static void fixEntityPositionDesync() {
        fixEntityPositionDesync = PaperConfig.getBoolean("settings.fix-entity-position-desync", fixEntityPositionDesync);
    }

    private static void consoleSettings() {
        enableBrigadierConsoleHighlighting = PaperConfig.getBoolean("settings.console.enable-brigadier-highlighting", enableBrigadierConsoleHighlighting);
        enableBrigadierConsoleCompletions = PaperConfig.getBoolean("settings.console.enable-brigadier-completions", enableBrigadierConsoleCompletions);
    }

    public static void registerCommands() {
        for (Map.Entry<String, Command> entry : commands.entrySet()) {
            MinecraftServer.getServer().server.getCommandMap().register(entry.getKey(), "Paper", entry.getValue());
        }
        if (!metricsStarted) {
            Metrics.PaperMetrics.startMetrics();
            metricsStarted = true;
        }
    }

    static void readConfig(Class<?> clazz, Object instance) {
        for (Method method : clazz.getDeclaredMethods()) {
            if (!Modifier.isPrivate(method.getModifiers()) || method.getParameterTypes().length != 0 || method.getReturnType() != Void.TYPE) continue;
            try {
                method.setAccessible(true);
                method.invoke(instance, new Object[0]);
            }
            catch (InvocationTargetException ex) {
                throw Throwables.propagate((Throwable)ex.getCause());
            }
            catch (Exception ex) {
                Bukkit.getLogger().log(Level.SEVERE, "Error invoking " + method, ex);
            }
        }
        PaperConfig.saveConfig();
    }

    static void saveConfig() {
        try {
            config.save(CONFIG_FILE);
        }
        catch (IOException ex) {
            Bukkit.getLogger().log(Level.SEVERE, "Could not save " + CONFIG_FILE, ex);
        }
    }

    public static int getSeconds(String str) {
        double num;
        str = SPACE.matcher(str).replaceAll("");
        char unit = str.charAt(str.length() - 1);
        str = NOT_NUMERIC.matcher(str).replaceAll("");
        try {
            num = Double.parseDouble(str);
        }
        catch (Exception e2) {
            num = 0.0;
        }
        switch (unit) {
            case 'd': {
                num *= 86400.0;
                break;
            }
            case 'h': {
                num *= 3600.0;
                break;
            }
            case 'm': {
                num *= 60.0;
                break;
            }
        }
        return (int)num;
    }

    protected static String timeSummary(int seconds) {
        Object time = "";
        if (seconds > 86400) {
            time = (String)time + TimeUnit.SECONDS.toDays(seconds) + "d";
            seconds %= 86400;
        }
        if (seconds > 3600) {
            time = (String)time + TimeUnit.SECONDS.toHours(seconds) + "h";
            seconds %= 3600;
        }
        if (seconds > 0) {
            time = (String)time + TimeUnit.SECONDS.toMinutes(seconds) + "m";
        }
        return time;
    }

    private static void set(String path, Object val) {
        config.set(path, val);
    }

    private static boolean getBoolean(String path, boolean def) {
        config.addDefault(path, (Object)def);
        return config.getBoolean(path, config.getBoolean(path));
    }

    private static double getDouble(String path, double def) {
        config.addDefault(path, (Object)def);
        return config.getDouble(path, config.getDouble(path));
    }

    private static float getFloat(String path, float def) {
        return (float)PaperConfig.getDouble(path, def);
    }

    private static int getInt(String path, int def) {
        config.addDefault(path, (Object)def);
        return config.getInt(path, config.getInt(path));
    }

    private static <T> List getList(String path, T def) {
        config.addDefault(path, def);
        return config.getList(path, config.getList(path));
    }

    private static String getString(String path, String def) {
        config.addDefault(path, (Object)def);
        return config.getString(path, config.getString(path));
    }

    private static void timings() {
        boolean timings = PaperConfig.getBoolean("timings.enabled", true);
        boolean verboseTimings = PaperConfig.getBoolean("timings.verbose", true);
        TimingsManager.url = PaperConfig.getString("timings.url", "https://timings.aikar.co/");
        if (!TimingsManager.url.endsWith("/")) {
            TimingsManager.url = TimingsManager.url + "/";
        }
        TimingsManager.privacy = PaperConfig.getBoolean("timings.server-name-privacy", false);
        TimingsManager.hiddenConfigs = PaperConfig.getList("timings.hidden-config-entries", Lists.newArrayList((Object[])new String[]{"database", "settings.bungeecord-addresses", "settings.velocity-support.secret"}));
        if (!TimingsManager.hiddenConfigs.contains("settings.velocity-support.secret")) {
            TimingsManager.hiddenConfigs.add("settings.velocity-support.secret");
        }
        int timingHistoryInterval = PaperConfig.getInt("timings.history-interval", 300);
        int timingHistoryLength = PaperConfig.getInt("timings.history-length", 3600);
        timingsServerName = PaperConfig.getString("timings.server-name", "Unknown Server");
        Timings.setVerboseTimingsEnabled((boolean)verboseTimings);
        Timings.setTimingsEnabled((boolean)timings);
        Timings.setHistoryInterval((int)(timingHistoryInterval * 20));
        Timings.setHistoryLength((int)(timingHistoryLength * 20));
        PaperConfig.log("Timings: " + timings + " - Url: " + TimingsManager.url + " - Verbose: " + verboseTimings + " - Interval: " + PaperConfig.timeSummary(Timings.getHistoryInterval() / 20) + " - Length: " + PaperConfig.timeSummary(Timings.getHistoryLength() / 20) + " - Server Name: " + timingsServerName);
    }

    private static void useDisplayNameInQuit() {
        if (version < 21) {
            boolean oldValue = PaperConfig.getBoolean("use-display-name-in-quit-message", useDisplayNameInQuit);
            PaperConfig.set("settings.use-display-name-in-quit-message", oldValue);
        }
        useDisplayNameInQuit = PaperConfig.getBoolean("settings.use-display-name-in-quit-message", useDisplayNameInQuit);
    }

    private static void loadPermsBeforePlugins() {
        loadPermsBeforePlugins = PaperConfig.getBoolean("settings.load-permissions-yml-before-plugins", true);
    }

    private static void regionFileCacheSize() {
        regionFileCacheSize = Math.max(PaperConfig.getInt("settings.region-file-cache-size", 256), 4);
    }

    private static void enablePlayerCollisions() {
        enablePlayerCollisions = PaperConfig.getBoolean("settings.enable-player-collisions", true);
    }

    private static void saveEmptyScoreboardTeams() {
        saveEmptyScoreboardTeams = PaperConfig.getBoolean("settings.save-empty-scoreboard-teams", false);
    }

    private static void bungeeOnlineMode() {
        bungeeOnlineMode = PaperConfig.getBoolean("settings.bungee-online-mode", true);
    }

    public static boolean isProxyOnlineMode() {
        return Bukkit.getOnlineMode() || SpigotConfig.bungee && bungeeOnlineMode || velocitySupport && velocityOnlineMode;
    }

    private static void packetInSpamThreshold() {
        if (version < 11) {
            int oldValue = PaperConfig.getInt("settings.play-in-use-item-spam-threshold", 300);
            PaperConfig.set("settings.incoming-packet-spam-threshold", oldValue);
        }
        packetInSpamThreshold = PaperConfig.getInt("settings.incoming-packet-spam-threshold", 300);
    }

    private static void flyingKickMessages() {
        flyingKickPlayerMessage = PaperConfig.getString("messages.kick.flying-player", flyingKickPlayerMessage);
        flyingKickVehicleMessage = PaperConfig.getString("messages.kick.flying-vehicle", flyingKickVehicleMessage);
    }

    private static void suggestPlayersWhenNull() {
        suggestPlayersWhenNullTabCompletions = PaperConfig.getBoolean("settings.suggest-player-names-when-null-tab-completions", suggestPlayersWhenNullTabCompletions);
    }

    private static void authenticationServersDownKickMessage() {
        authenticationServersDownKickMessage = Strings.emptyToNull((String)PaperConfig.getString("messages.kick.authentication-servers-down", authenticationServersDownKickMessage));
    }

    private static void connectionThrottleKickMessage() {
        connectionThrottleKickMessage = PaperConfig.getString("messages.kick.connection-throttle", connectionThrottleKickMessage);
    }

    private static void noPermissionMessage() {
        noPermissionMessage = ChatColor.translateAlternateColorCodes((char)'&', (String)PaperConfig.getString("messages.no-permission", noPermissionMessage));
    }

    private static void savePlayerData() {
        Object val = config.get("settings.save-player-data");
        if (val instanceof Boolean) {
            SpigotConfig.disablePlayerDataSaving = (Boolean)val == false;
            SpigotConfig.config.set("players.disable-saving", (Object)SpigotConfig.disablePlayerDataSaving);
            SpigotConfig.save();
            config.set("settings.save-player-data", null);
        }
    }

    private static void namedEntityDeaths() {
        Boolean bool;
        Object val = config.get("settings.log-named-entity-deaths");
        if (val instanceof Boolean && !(bool = (Boolean)val).booleanValue()) {
            SpigotConfig.logNamedDeaths = false;
            SpigotConfig.config.set("settings.log-named-deaths", (Object)false);
            SpigotConfig.save();
        }
    }

    private static void useAlternativeLuckFormula() {
        useAlternativeLuckFormula = PaperConfig.getBoolean("settings.use-alternative-luck-formula", false);
        if (useAlternativeLuckFormula) {
            Bukkit.getLogger().log(Level.INFO, "Using Aikar's Alternative Luck Formula to apply Luck attribute to all loot pool calculations. See https://luckformula.emc.gs");
        }
    }

    private static void watchdogEarlyWarning() {
        watchdogPrintEarlyWarningEvery = PaperConfig.getInt("settings.watchdog.early-warning-every", 5000);
        watchdogPrintEarlyWarningDelay = PaperConfig.getInt("settings.watchdog.early-warning-delay", 10000);
        WatchdogThread.doStart(SpigotConfig.timeoutTime, SpigotConfig.restartOnCrash);
    }

    private static void tabSpamLimiters() {
        tabSpamIncrement = PaperConfig.getInt("settings.spam-limiter.tab-spam-increment", tabSpamIncrement);
        if (version < 14 && tabSpamIncrement == 10) {
            PaperConfig.set("settings.spam-limiter.tab-spam-increment", 2);
            tabSpamIncrement = 2;
        }
        tabSpamLimit = PaperConfig.getInt("settings.spam-limiter.tab-spam-limit", tabSpamLimit);
    }

    private static void autoRecipieLimiters() {
        autoRecipeIncrement = PaperConfig.getInt("settings.spam-limiter.recipe-spam-increment", autoRecipeIncrement);
        autoRecipeLimit = PaperConfig.getInt("settings.spam-limiter.recipe-spam-limit", autoRecipeLimit);
    }

    private static void velocitySupport() {
        velocitySupport = PaperConfig.getBoolean("settings.velocity-support.enabled", false);
        velocityOnlineMode = PaperConfig.getBoolean("settings.velocity-support.online-mode", false);
        String secret = PaperConfig.getString("settings.velocity-support.secret", "");
        if (velocitySupport && secret.isEmpty()) {
            PaperConfig.fatal("Velocity support is enabled, but no secret key was specified. A secret key is required!");
        } else {
            velocitySecretKey = secret.getBytes(StandardCharsets.UTF_8);
        }
    }

    private static void maxBookSize() {
        maxBookPageSize = Math.min(8192, PaperConfig.getInt("settings.book-size.page-max", maxBookPageSize));
        maxBookTotalSizeMultiplier = PaperConfig.getDouble("settings.book-size.total-multiplier", maxBookTotalSizeMultiplier);
    }

    private static void asyncChunks() {
        ConfigurationSection section;
        if (version < 15) {
            section = config.createSection("settings.async-chunks");
            section.set("threads", (Object)-1);
        } else {
            section = config.getConfigurationSection("settings.async-chunks");
            if (section == null) {
                section = config.createSection("settings.async-chunks");
            }
        }
        if (section.contains("load-threads")) {
            if (!section.contains("threads")) {
                section.set("threads", section.get("load-threads"));
            }
            section.set("load-threads", null);
        }
        section.set("generation", null);
        section.set("enabled", null);
        section.set("thread-per-world-generation", null);
        int threads = PaperConfig.getInt("settings.async-chunks.threads", -1);
        int cpus = Runtime.getRuntime().availableProcessors() / 2;
        if (threads <= 0) {
            threads = cpus <= 4 ? (cpus <= 2 ? 1 : 2) : Math.min(Integer.getInteger("paper.maxChunkThreads", 4), cpus / 2);
        }
        asyncChunks = cpus != 1 || Boolean.getBoolean("Paper.allowAsyncChunksSingleCore");
        String sharedHostThreads = System.getenv("PAPER_ASYNC_CHUNKS_SHARED_HOST_THREADS");
        if (sharedHostThreads != null) {
            try {
                threads = Math.max(1, Math.min(threads, Integer.parseInt(sharedHostThreads)));
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        if (!asyncChunks) {
            PaperConfig.log("Async Chunks: Disabled - Chunks will be managed synchronously, and will cause tremendous lag.");
        } else {
            ChunkTaskManager.initGlobalLoadThreads(threads);
            PaperConfig.log("Async Chunks: Enabled - Chunks will be loaded much faster, without lag.");
        }
    }

    private static void loggerSettings() {
        deobfuscateStacktraces = PaperConfig.getBoolean("settings.loggers.deobfuscate-stacktraces", deobfuscateStacktraces);
    }

    private static void allowBlockPermanentBreakingExploits() {
        if (config.contains("allow-perm-block-break-exploits")) {
            allowBlockPermanentBreakingExploits = config.getBoolean("allow-perm-block-break-exploits", false);
            config.set("allow-perm-block-break-exploits", null);
        }
        config.set("settings.unsupported-settings.allow-permanent-block-break-exploits-readme", (Object)"This setting controls if players should be able to break bedrock, end portals and other intended to be permanent blocks.");
        allowBlockPermanentBreakingExploits = PaperConfig.getBoolean("settings.unsupported-settings.allow-permanent-block-break-exploits", allowBlockPermanentBreakingExploits);
    }

    private static void consoleHasAllPermissions() {
        consoleHasAllPermissions = PaperConfig.getBoolean("settings.console-has-all-permissions", consoleHasAllPermissions);
    }

    private static void allowPistonDuplication() {
        config.set("settings.unsupported-settings.allow-piston-duplication-readme", (Object)"This setting controls if player should be able to use TNT duplication, but this also allows duplicating carpet, rails and potentially other items");
        allowPistonDuplication = PaperConfig.getBoolean("settings.unsupported-settings.allow-piston-duplication", config.getBoolean("settings.unsupported-settings.allow-tnt-duplication", false));
        PaperConfig.set("settings.unsupported-settings.allow-tnt-duplication", null);
    }

    private static void playerAutoSaveRate() {
        playerAutoSaveRate = PaperConfig.getInt("settings.player-auto-save-rate", -1);
        maxPlayerAutoSavePerTick = PaperConfig.getInt("settings.max-player-auto-save-per-tick", -1);
        if (maxPlayerAutoSavePerTick == -1) {
            maxPlayerAutoSavePerTick = playerAutoSaveRate == -1 || playerAutoSaveRate > 100 ? 10 : 20;
        }
    }

    private static void allowHeadlessPistons() {
        config.set("settings.unsupported-settings.allow-headless-pistons-readme", (Object)"This setting controls if players should be able to create headless pistons.");
        allowHeadlessPistons = PaperConfig.getBoolean("settings.unsupported-settings.allow-headless-pistons", false);
    }

    private static void itemValidationSettings() {
        itemValidationDisplayNameLength = PaperConfig.getInt("settings.item-validation.display-name", itemValidationDisplayNameLength);
        itemValidationLocNameLength = PaperConfig.getInt("settings.item-validation.loc-name", itemValidationLocNameLength);
        itemValidationLoreLineLength = PaperConfig.getInt("settings.item-validation.lore-line", itemValidationLoreLineLength);
        itemValidationBookTitleLength = PaperConfig.getInt("settings.item-validation.book.title", itemValidationBookTitleLength);
        itemValidationBookAuthorLength = PaperConfig.getInt("settings.item-validation.book.author", itemValidationBookAuthorLength);
        itemValidationBookPageLength = PaperConfig.getInt("settings.item-validation.book.page", itemValidationBookPageLength);
    }

    private static void fixTargetSelectorTagCompletion() {
        fixTargetSelectorTagCompletion = PaperConfig.getBoolean("settings.fix-target-selector-tag-completion", fixTargetSelectorTagCompletion);
    }

    private static void packetLimiter() {
        packetSpecificLimits.clear();
        kickMessage = ChatColor.translateAlternateColorCodes((char)'&', (String)PaperConfig.getString("settings.packet-limiter.kick-message", "&cSent too many packets"));
        allPacketsLimit = new PacketLimit(PaperConfig.getDouble("settings.packet-limiter.limits.all.interval", 7.0), PaperConfig.getDouble("settings.packet-limiter.limits.all.max-packet-rate", 500.0), PacketLimit.ViolateAction.KICK);
        if (PaperConfig.allPacketsLimit.maxPacketRate <= 0.0 || PaperConfig.allPacketsLimit.packetLimitInterval <= 0.0) {
            allPacketsLimit = null;
        }
        ConfigurationSection section = config.getConfigurationSection("settings.packet-limiter.limits");
        PaperConfig.getDouble("settings.packet-limiter.limits.PacketPlayInAutoRecipe.interval", 4.0);
        PaperConfig.getDouble("settings.packet-limiter.limits.PacketPlayInAutoRecipe.max-packet-rate", 5.0);
        PaperConfig.getString("settings.packet-limiter.limits.PacketPlayInAutoRecipe.action", PacketLimit.ViolateAction.DROP.name());
        HashMap mojangToSpigot = new HashMap();
        Map<String, ObfHelper.ClassMapping> maps = ObfHelper.INSTANCE.mappingsByObfName();
        if (maps != null) {
            maps.forEach((spigotName, classMapping) -> mojangToSpigot.put(classMapping.mojangName(), classMapping.obfName()));
        }
        for (String packetClassName : section.getKeys(false)) {
            if (packetClassName.equals("all")) continue;
            Class<?> packetClazz = null;
            for (String subpackage : List.of("game", "handshake", "login", "status")) {
                String fullName = "net.minecraft.network.protocol." + subpackage + "." + packetClassName;
                try {
                    packetClazz = Class.forName(fullName);
                    break;
                }
                catch (ClassNotFoundException ex) {
                    try {
                        String spigot = (String)mojangToSpigot.get(fullName);
                        if (spigot == null) continue;
                        packetClazz = Class.forName(spigot);
                    }
                    catch (ClassNotFoundException spigot) {}
                }
            }
            if (packetClazz == null || !Packet.class.isAssignableFrom(packetClazz)) {
                MinecraftServer.r.warn("Packet '" + packetClassName + "' does not exist, cannot limit it! Please update paper.yml");
                continue;
            }
            if (!(section.get(packetClassName.concat(".interval")) instanceof Number) || !(section.get(packetClassName.concat(".max-packet-rate")) instanceof Number)) {
                throw new RuntimeException("Packet limit setting " + packetClassName + " is missing interval or max-packet-rate!");
            }
            String actionString = section.getString(packetClassName.concat(".action"), "KICK");
            PacketLimit.ViolateAction action = PacketLimit.ViolateAction.KICK;
            for (PacketLimit.ViolateAction test : PacketLimit.ViolateAction.values()) {
                if (!actionString.equalsIgnoreCase(test.name())) continue;
                action = test;
                break;
            }
            double interval = section.getDouble(packetClassName.concat(".interval"));
            double rate = section.getDouble(packetClassName.concat(".max-packet-rate"));
            if (!(interval > 0.0) || !(rate > 0.0)) continue;
            packetSpecificLimits.put(packetClazz, new PacketLimit(interval, rate, action));
        }
    }

    private static void lagCompensateBlockBreaking() {
        lagCompensateBlockBreaking = PaperConfig.getBoolean("settings.lag-compensate-block-breaking", true);
    }

    private static void sendFullPosForHardCollidingEntities() {
        sendFullPosForHardCollidingEntities = PaperConfig.getBoolean("settings.send-full-pos-for-hard-colliding-entities", true);
    }

    static {
        logPlayerIpAddresses = true;
        fixEntityPositionDesync = true;
        enableBrigadierConsoleHighlighting = true;
        enableBrigadierConsoleCompletions = true;
        SPACE = Pattern.compile(" ");
        NOT_NUMERIC = Pattern.compile("[^-\\d.]");
        useDisplayNameInQuit = false;
        loadPermsBeforePlugins = true;
        regionFileCacheSize = 256;
        enablePlayerCollisions = true;
        saveEmptyScoreboardTeams = false;
        bungeeOnlineMode = true;
        packetInSpamThreshold = 300;
        flyingKickPlayerMessage = "Flying is not enabled on this server";
        flyingKickVehicleMessage = "Flying is not enabled on this server";
        suggestPlayersWhenNullTabCompletions = true;
        authenticationServersDownKickMessage = "";
        connectionThrottleKickMessage = "Connection throttled! Please wait before reconnecting.";
        noPermissionMessage = "&cI'm sorry, but you do not have permission to perform this command. Please contact the server administrators if you believe that this is in error.";
        useAlternativeLuckFormula = false;
        watchdogPrintEarlyWarningEvery = 5000;
        watchdogPrintEarlyWarningDelay = 10000;
        tabSpamIncrement = 1;
        tabSpamLimit = 500;
        autoRecipeIncrement = 1;
        autoRecipeLimit = 20;
        maxBookPageSize = 2560;
        maxBookTotalSizeMultiplier = 0.98;
        asyncChunks = false;
        deobfuscateStacktraces = true;
        allowBlockPermanentBreakingExploits = false;
        consoleHasAllPermissions = false;
        playerAutoSaveRate = -1;
        maxPlayerAutoSavePerTick = 10;
        itemValidationDisplayNameLength = 8192;
        itemValidationLocNameLength = 8192;
        itemValidationLoreLineLength = 8192;
        itemValidationBookTitleLength = 8192;
        itemValidationBookAuthorLength = 8192;
        itemValidationBookPageLength = 16384;
        fixTargetSelectorTagCompletion = true;
        packetSpecificLimits = new HashMap();
    }

    public static final class PacketLimit {
        public final double packetLimitInterval;
        public final double maxPacketRate;
        public final ViolateAction violateAction;

        public PacketLimit(double packetLimitInterval, double maxPacketRate, ViolateAction violateAction) {
            this.packetLimitInterval = packetLimitInterval;
            this.maxPacketRate = maxPacketRate;
            this.violateAction = violateAction;
        }

        public static enum ViolateAction {
            KICK,
            DROP;

        }
    }
}

