/*
 * Decompiled with CFR 0.152.
 */
package ca.spottedleaf.dataconverter.types.json;

import ca.spottedleaf.dataconverter.types.ListType;
import ca.spottedleaf.dataconverter.types.MapType;
import ca.spottedleaf.dataconverter.types.ObjectType;
import ca.spottedleaf.dataconverter.types.json.JsonMapType;
import ca.spottedleaf.dataconverter.types.json.JsonTypeUtil;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonPrimitive;

public final class JsonListType
implements ListType {
    protected final JsonArray array;
    protected final boolean compressed;

    public JsonListType(boolean compressed) {
        this.array = new JsonArray();
        this.compressed = compressed;
    }

    public JsonListType(JsonArray array, boolean compressed) {
        this.array = array;
        this.compressed = compressed;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || obj.getClass() != JsonListType.class) {
            return false;
        }
        return this.array.equals((Object)((JsonListType)obj).array);
    }

    @Override
    public int hashCode() {
        return this.array.hashCode();
    }

    public String toString() {
        return "JsonListType{array=" + this.array + ", compressed=" + this.compressed + "}";
    }

    public JsonArray getJson() {
        return this.array;
    }

    @Override
    public ListType copy() {
        return new JsonListType(JsonTypeUtil.copyJson(this.array), this.compressed);
    }

    @Override
    public ObjectType getType() {
        return ObjectType.UNDEFINED;
    }

    @Override
    public int size() {
        return this.array.size();
    }

    @Override
    public void remove(int index) {
        this.array.remove(index);
    }

    @Override
    public Number getNumber(int index) {
        JsonElement element = this.array.get(index);
        if (element instanceof JsonPrimitive) {
            JsonPrimitive primitive = (JsonPrimitive)element;
            if (primitive.isNumber()) {
                return primitive.getAsNumber();
            }
            if (primitive.isBoolean()) {
                return primitive.getAsBoolean() ? Byte.valueOf((byte)1) : Byte.valueOf((byte)0);
            }
            if (this.compressed && primitive.isString()) {
                try {
                    return Integer.parseInt(primitive.getAsString());
                }
                catch (NumberFormatException ex) {
                    return null;
                }
            }
        }
        return null;
    }

    @Override
    public byte getByte(int index) {
        Number number = this.getNumber(index);
        return number == null ? (byte)0 : number.byteValue();
    }

    @Override
    public void setByte(int index, byte to) {
        this.array.set(index, (JsonElement)new JsonPrimitive((Number)to));
    }

    @Override
    public short getShort(int index) {
        Number number = this.getNumber(index);
        return number == null ? (short)0 : number.shortValue();
    }

    @Override
    public void setShort(int index, short to) {
        this.array.set(index, (JsonElement)new JsonPrimitive((Number)to));
    }

    @Override
    public int getInt(int index) {
        Number number = this.getNumber(index);
        return number == null ? 0 : number.intValue();
    }

    @Override
    public void setInt(int index, int to) {
        this.array.set(index, (JsonElement)new JsonPrimitive((Number)to));
    }

    @Override
    public long getLong(int index) {
        Number number = this.getNumber(index);
        return number == null ? 0L : number.longValue();
    }

    @Override
    public void setLong(int index, long to) {
        this.array.set(index, (JsonElement)new JsonPrimitive((Number)to));
    }

    @Override
    public float getFloat(int index) {
        Number number = this.getNumber(index);
        return number == null ? 0.0f : number.floatValue();
    }

    @Override
    public void setFloat(int index, float to) {
        this.array.set(index, (JsonElement)new JsonPrimitive((Number)Float.valueOf(to)));
    }

    @Override
    public double getDouble(int index) {
        Number number = this.getNumber(index);
        return number == null ? 0.0 : number.doubleValue();
    }

    @Override
    public void setDouble(int index, double to) {
        this.array.set(index, (JsonElement)new JsonPrimitive((Number)to));
    }

    @Override
    public byte[] getBytes(int index) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void setBytes(int index, byte[] to) {
        throw new UnsupportedOperationException();
    }

    @Override
    public short[] getShorts(int index) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void setShorts(int index, short[] to) {
        throw new UnsupportedOperationException();
    }

    @Override
    public int[] getInts(int index) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void setInts(int index, int[] to) {
        throw new UnsupportedOperationException();
    }

    @Override
    public long[] getLongs(int index) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void setLongs(int index, long[] to) {
        throw new UnsupportedOperationException();
    }

    @Override
    public ListType getList(int index) {
        JsonElement element = this.array.get(index);
        if (element instanceof JsonArray) {
            return new JsonListType((JsonArray)element, this.compressed);
        }
        return null;
    }

    @Override
    public void setList(int index, ListType list) {
        this.array.set(index, (JsonElement)((JsonListType)list).array);
    }

    public MapType<String> getMap(int index) {
        JsonElement element = this.array.get(index);
        if (element instanceof JsonObject) {
            return new JsonMapType((JsonObject)element, this.compressed);
        }
        return null;
    }

    @Override
    public void setMap(int index, MapType<?> to) {
        this.array.set(index, (JsonElement)((JsonMapType)to).map);
    }

    @Override
    public String getString(int index) {
        JsonPrimitive primitive;
        JsonElement element = this.array.get(index);
        if (element instanceof JsonPrimitive && ((primitive = (JsonPrimitive)element).isString() || this.compressed && primitive.isNumber())) {
            return primitive.getAsString();
        }
        return null;
    }

    @Override
    public void setString(int index, String to) {
        this.array.set(index, (JsonElement)new JsonPrimitive(to));
    }

    @Override
    public void addByte(byte b2) {
        this.array.add((Number)b2);
    }

    @Override
    public void addByte(int index, byte b2) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void addShort(short s2) {
        this.array.add((Number)s2);
    }

    @Override
    public void addShort(int index, short s2) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void addInt(int i2) {
        this.array.add((Number)i2);
    }

    @Override
    public void addInt(int index, int i2) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void addLong(long l2) {
        this.array.add((Number)l2);
    }

    @Override
    public void addLong(int index, long l2) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void addFloat(float f2) {
        this.array.add((Number)Float.valueOf(f2));
    }

    @Override
    public void addFloat(int index, float f2) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void addDouble(double d2) {
        this.array.add((Number)d2);
    }

    @Override
    public void addDouble(int index, double d2) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void addByteArray(byte[] arr) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void addByteArray(int index, byte[] arr) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void addShortArray(short[] arr) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void addShortArray(int index, short[] arr) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void addIntArray(int[] arr) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void addIntArray(int index, int[] arr) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void addLongArray(long[] arr) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void addLongArray(int index, long[] arr) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void addList(ListType list) {
        this.array.add((JsonElement)((JsonListType)list).array);
    }

    @Override
    public void addList(int index, ListType list) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void addMap(MapType<?> map) {
        this.array.add((JsonElement)((JsonMapType)map).map);
    }

    @Override
    public void addMap(int index, MapType<?> map) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void addString(String string) {
        this.array.add(string);
    }

    @Override
    public void addString(int index, String string) {
        throw new UnsupportedOperationException();
    }
}

