/*
 * Decompiled with CFR 0.152.
 */
package ca.spottedleaf.dataconverter.minecraft.versions;

import ca.spottedleaf.dataconverter.minecraft.converters.entity.ConverterAbstractEntityRename;
import ca.spottedleaf.dataconverter.minecraft.datatypes.MCTypeRegistry;
import ca.spottedleaf.dataconverter.minecraft.hooks.DataHookEnforceNamespacedID;
import ca.spottedleaf.dataconverter.minecraft.hooks.DataHookValueTypeEnforceNamespaced;
import ca.spottedleaf.dataconverter.minecraft.walkers.block_name.DataWalkerBlockNames;
import ca.spottedleaf.dataconverter.minecraft.walkers.generic.WalkerUtils;
import ca.spottedleaf.dataconverter.minecraft.walkers.itemstack.DataWalkerItemLists;
import ca.spottedleaf.dataconverter.minecraft.walkers.itemstack.DataWalkerItems;
import ca.spottedleaf.dataconverter.minecraft.walkers.tile_entity.DataWalkerTileEntities;
import ca.spottedleaf.dataconverter.types.ListType;
import ca.spottedleaf.dataconverter.types.MapType;
import ca.spottedleaf.dataconverter.types.ObjectType;
import java.util.HashMap;
import java.util.Map;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public final class V705 {
    private static final Logger LOGGER = LogManager.getLogger();
    protected static final int VERSION = 705;
    protected static final Map<String, String> ENTITY_ID_UPDATE = new HashMap<String, String>();

    private static void registerMob(String id) {
        MCTypeRegistry.ENTITY.addWalker(705, id, new DataWalkerItemLists("ArmorItems", "HandItems"));
    }

    private static void registerThrowableProjectile(String id) {
        MCTypeRegistry.ENTITY.addWalker(705, id, new DataWalkerBlockNames("inTile"));
    }

    public static void register() {
        ConverterAbstractEntityRename.register(705, ENTITY_ID_UPDATE::get);
        V705.registerMob("minecraft:armor_stand");
        MCTypeRegistry.ENTITY.addWalker(705, "minecraft:arrow", new DataWalkerBlockNames("inTile"));
        V705.registerMob("minecraft:bat");
        V705.registerMob("minecraft:blaze");
        V705.registerMob("minecraft:cave_spider");
        MCTypeRegistry.ENTITY.addWalker(705, "minecraft:chest_minecart", new DataWalkerBlockNames("DisplayTile"));
        MCTypeRegistry.ENTITY.addWalker(705, "minecraft:chest_minecart", new DataWalkerItemLists("Items"));
        V705.registerMob("minecraft:chicken");
        MCTypeRegistry.ENTITY.addWalker(705, "minecraft:commandblock_minecart", new DataWalkerBlockNames("DisplayTile"));
        V705.registerMob("minecraft:cow");
        V705.registerMob("minecraft:creeper");
        MCTypeRegistry.ENTITY.addWalker(705, "minecraft:donkey", new DataWalkerItemLists("Items", "ArmorItems", "HandItems"));
        MCTypeRegistry.ENTITY.addWalker(705, "minecraft:donkey", new DataWalkerItems("SaddleItem"));
        V705.registerThrowableProjectile("minecraft:egg");
        V705.registerMob("minecraft:elder_guardian");
        V705.registerMob("minecraft:ender_dragon");
        MCTypeRegistry.ENTITY.addWalker(705, "minecraft:enderman", new DataWalkerItemLists("ArmorItems", "HandItems"));
        MCTypeRegistry.ENTITY.addWalker(705, "minecraft:enderman", new DataWalkerBlockNames("carried"));
        V705.registerMob("minecraft:endermite");
        V705.registerThrowableProjectile("minecraft:ender_pearl");
        MCTypeRegistry.ENTITY.addWalker(705, "minecraft:falling_block", new DataWalkerBlockNames("Block"));
        MCTypeRegistry.ENTITY.addWalker(705, "minecraft:falling_block", new DataWalkerTileEntities("TileEntityData"));
        V705.registerThrowableProjectile("minecraft:fireball");
        MCTypeRegistry.ENTITY.addWalker(705, "minecraft:fireworks_rocket", new DataWalkerItems("FireworksItem"));
        MCTypeRegistry.ENTITY.addWalker(705, "minecraft:furnace_minecart", new DataWalkerBlockNames("DisplayTile"));
        V705.registerMob("minecraft:ghast");
        V705.registerMob("minecraft:giant");
        V705.registerMob("minecraft:guardian");
        MCTypeRegistry.ENTITY.addWalker(705, "minecraft:hopper_minecart", new DataWalkerBlockNames("DisplayTile"));
        MCTypeRegistry.ENTITY.addWalker(705, "minecraft:hopper_minecart", new DataWalkerItemLists("Items"));
        MCTypeRegistry.ENTITY.addWalker(705, "minecraft:horse", new DataWalkerItems("ArmorItem", "SaddleItem"));
        MCTypeRegistry.ENTITY.addWalker(705, "minecraft:horse", new DataWalkerItemLists("ArmorItems", "HandItems"));
        V705.registerMob("minecraft:husk");
        MCTypeRegistry.ENTITY.addWalker(705, "minecraft:item", new DataWalkerItems("Item"));
        MCTypeRegistry.ENTITY.addWalker(705, "minecraft:item_frame", new DataWalkerItems("Item"));
        V705.registerMob("minecraft:magma_cube");
        MCTypeRegistry.ENTITY.addWalker(705, "minecraft:minecart", new DataWalkerBlockNames("DisplayTile"));
        V705.registerMob("minecraft:mooshroom");
        MCTypeRegistry.ENTITY.addWalker(705, "minecraft:mule", new DataWalkerItemLists("Items", "ArmorItems", "HandItems"));
        MCTypeRegistry.ENTITY.addWalker(705, "minecraft:mule", new DataWalkerItems("SaddleItem"));
        V705.registerMob("minecraft:ocelot");
        V705.registerMob("minecraft:pig");
        V705.registerMob("minecraft:polar_bear");
        MCTypeRegistry.ENTITY.addWalker(705, "minecraft:potion", new DataWalkerItems("Potion"));
        MCTypeRegistry.ENTITY.addWalker(705, "minecraft:potion", new DataWalkerBlockNames("inTile"));
        V705.registerMob("minecraft:rabbit");
        V705.registerMob("minecraft:sheep");
        V705.registerMob("minecraft:shulker");
        V705.registerMob("minecraft:silverfish");
        V705.registerMob("minecraft:skeleton");
        MCTypeRegistry.ENTITY.addWalker(705, "minecraft:skeleton_horse", new DataWalkerItemLists("ArmorItems", "HandItems"));
        MCTypeRegistry.ENTITY.addWalker(705, "minecraft:skeleton_horse", new DataWalkerItems("SaddleItem"));
        V705.registerMob("minecraft:slime");
        V705.registerThrowableProjectile("minecraft:small_fireball");
        V705.registerThrowableProjectile("minecraft:snowball");
        V705.registerMob("minecraft:snowman");
        MCTypeRegistry.ENTITY.addWalker(705, "minecraft:spawner_minecart", new DataWalkerBlockNames("DisplayTile"));
        MCTypeRegistry.ENTITY.addWalker(705, "minecraft:spawner_minecart", (data, fromVersion, toVersion) -> {
            MCTypeRegistry.UNTAGGED_SPAWNER.convert(data, fromVersion, toVersion);
            return null;
        });
        MCTypeRegistry.ENTITY.addWalker(705, "minecraft:spectral_arrow", new DataWalkerBlockNames("inTile"));
        V705.registerMob("minecraft:spider");
        V705.registerMob("minecraft:squid");
        V705.registerMob("minecraft:stray");
        MCTypeRegistry.ENTITY.addWalker(705, "minecraft:tnt_minecart", new DataWalkerBlockNames("DisplayTile"));
        MCTypeRegistry.ENTITY.addWalker(705, "minecraft:villager", (data, fromVersion, toVersion) -> {
            ListType recipes;
            WalkerUtils.convertList(MCTypeRegistry.ITEM_STACK, (MapType<String>)data, "Inventory", fromVersion, toVersion);
            MapType offers = data.getMap("Offers");
            if (offers != null && (recipes = offers.getList("Recipes", ObjectType.MAP)) != null) {
                int len = recipes.size();
                for (int i2 = 0; i2 < len; ++i2) {
                    MapType<String> recipe = recipes.getMap(i2);
                    WalkerUtils.convert(MCTypeRegistry.ITEM_STACK, recipe, "buy", fromVersion, toVersion);
                    WalkerUtils.convert(MCTypeRegistry.ITEM_STACK, recipe, "buyB", fromVersion, toVersion);
                    WalkerUtils.convert(MCTypeRegistry.ITEM_STACK, recipe, "sell", fromVersion, toVersion);
                }
            }
            WalkerUtils.convertList(MCTypeRegistry.ITEM_STACK, (MapType<String>)data, "ArmorItems", fromVersion, toVersion);
            WalkerUtils.convertList(MCTypeRegistry.ITEM_STACK, (MapType<String>)data, "HandItems", fromVersion, toVersion);
            return null;
        });
        V705.registerMob("minecraft:villager_golem");
        V705.registerMob("minecraft:witch");
        V705.registerMob("minecraft:wither");
        V705.registerMob("minecraft:wither_skeleton");
        V705.registerThrowableProjectile("minecraft:wither_skull");
        V705.registerMob("minecraft:wolf");
        V705.registerThrowableProjectile("minecraft:xp_bottle");
        V705.registerMob("minecraft:zombie");
        MCTypeRegistry.ENTITY.addWalker(705, "minecraft:zombie_horse", new DataWalkerItems("SaddleItem"));
        MCTypeRegistry.ENTITY.addWalker(705, "minecraft:zombie_horse", new DataWalkerItemLists("ArmorItems", "HandItems"));
        V705.registerMob("minecraft:zombie_pigman");
        V705.registerMob("minecraft:zombie_villager");
        V705.registerMob("minecraft:evocation_illager");
        MCTypeRegistry.ENTITY.addWalker(705, "minecraft:llama", new DataWalkerItemLists("Items", "ArmorItems", "HandItems"));
        MCTypeRegistry.ENTITY.addWalker(705, "minecraft:llama", new DataWalkerItems("SaddleItem", "DecorItem"));
        V705.registerMob("minecraft:vex");
        V705.registerMob("minecraft:vindication_illager");
        MCTypeRegistry.ENTITY.addStructureHook(705, new DataHookEnforceNamespacedID());
        MCTypeRegistry.ENTITY_NAME.addStructureHook(705, new DataHookValueTypeEnforceNamespaced());
    }

    private V705() {
    }

    static {
        ENTITY_ID_UPDATE.put("AreaEffectCloud", "minecraft:area_effect_cloud");
        ENTITY_ID_UPDATE.put("ArmorStand", "minecraft:armor_stand");
        ENTITY_ID_UPDATE.put("Arrow", "minecraft:arrow");
        ENTITY_ID_UPDATE.put("Bat", "minecraft:bat");
        ENTITY_ID_UPDATE.put("Blaze", "minecraft:blaze");
        ENTITY_ID_UPDATE.put("Boat", "minecraft:boat");
        ENTITY_ID_UPDATE.put("CaveSpider", "minecraft:cave_spider");
        ENTITY_ID_UPDATE.put("Chicken", "minecraft:chicken");
        ENTITY_ID_UPDATE.put("Cow", "minecraft:cow");
        ENTITY_ID_UPDATE.put("Creeper", "minecraft:creeper");
        ENTITY_ID_UPDATE.put("Donkey", "minecraft:donkey");
        ENTITY_ID_UPDATE.put("DragonFireball", "minecraft:dragon_fireball");
        ENTITY_ID_UPDATE.put("ElderGuardian", "minecraft:elder_guardian");
        ENTITY_ID_UPDATE.put("EnderCrystal", "minecraft:ender_crystal");
        ENTITY_ID_UPDATE.put("EnderDragon", "minecraft:ender_dragon");
        ENTITY_ID_UPDATE.put("Enderman", "minecraft:enderman");
        ENTITY_ID_UPDATE.put("Endermite", "minecraft:endermite");
        ENTITY_ID_UPDATE.put("EyeOfEnderSignal", "minecraft:eye_of_ender_signal");
        ENTITY_ID_UPDATE.put("FallingSand", "minecraft:falling_block");
        ENTITY_ID_UPDATE.put("Fireball", "minecraft:fireball");
        ENTITY_ID_UPDATE.put("FireworksRocketEntity", "minecraft:fireworks_rocket");
        ENTITY_ID_UPDATE.put("Ghast", "minecraft:ghast");
        ENTITY_ID_UPDATE.put("Giant", "minecraft:giant");
        ENTITY_ID_UPDATE.put("Guardian", "minecraft:guardian");
        ENTITY_ID_UPDATE.put("Horse", "minecraft:horse");
        ENTITY_ID_UPDATE.put("Husk", "minecraft:husk");
        ENTITY_ID_UPDATE.put("Item", "minecraft:item");
        ENTITY_ID_UPDATE.put("ItemFrame", "minecraft:item_frame");
        ENTITY_ID_UPDATE.put("LavaSlime", "minecraft:magma_cube");
        ENTITY_ID_UPDATE.put("LeashKnot", "minecraft:leash_knot");
        ENTITY_ID_UPDATE.put("MinecartChest", "minecraft:chest_minecart");
        ENTITY_ID_UPDATE.put("MinecartCommandBlock", "minecraft:commandblock_minecart");
        ENTITY_ID_UPDATE.put("MinecartFurnace", "minecraft:furnace_minecart");
        ENTITY_ID_UPDATE.put("MinecartHopper", "minecraft:hopper_minecart");
        ENTITY_ID_UPDATE.put("MinecartRideable", "minecraft:minecart");
        ENTITY_ID_UPDATE.put("MinecartSpawner", "minecraft:spawner_minecart");
        ENTITY_ID_UPDATE.put("MinecartTNT", "minecraft:tnt_minecart");
        ENTITY_ID_UPDATE.put("Mule", "minecraft:mule");
        ENTITY_ID_UPDATE.put("MushroomCow", "minecraft:mooshroom");
        ENTITY_ID_UPDATE.put("Ozelot", "minecraft:ocelot");
        ENTITY_ID_UPDATE.put("Painting", "minecraft:painting");
        ENTITY_ID_UPDATE.put("Pig", "minecraft:pig");
        ENTITY_ID_UPDATE.put("PigZombie", "minecraft:zombie_pigman");
        ENTITY_ID_UPDATE.put("PolarBear", "minecraft:polar_bear");
        ENTITY_ID_UPDATE.put("PrimedTnt", "minecraft:tnt");
        ENTITY_ID_UPDATE.put("Rabbit", "minecraft:rabbit");
        ENTITY_ID_UPDATE.put("Sheep", "minecraft:sheep");
        ENTITY_ID_UPDATE.put("Shulker", "minecraft:shulker");
        ENTITY_ID_UPDATE.put("ShulkerBullet", "minecraft:shulker_bullet");
        ENTITY_ID_UPDATE.put("Silverfish", "minecraft:silverfish");
        ENTITY_ID_UPDATE.put("Skeleton", "minecraft:skeleton");
        ENTITY_ID_UPDATE.put("SkeletonHorse", "minecraft:skeleton_horse");
        ENTITY_ID_UPDATE.put("Slime", "minecraft:slime");
        ENTITY_ID_UPDATE.put("SmallFireball", "minecraft:small_fireball");
        ENTITY_ID_UPDATE.put("SnowMan", "minecraft:snowman");
        ENTITY_ID_UPDATE.put("Snowball", "minecraft:snowball");
        ENTITY_ID_UPDATE.put("SpectralArrow", "minecraft:spectral_arrow");
        ENTITY_ID_UPDATE.put("Spider", "minecraft:spider");
        ENTITY_ID_UPDATE.put("Squid", "minecraft:squid");
        ENTITY_ID_UPDATE.put("Stray", "minecraft:stray");
        ENTITY_ID_UPDATE.put("ThrownEgg", "minecraft:egg");
        ENTITY_ID_UPDATE.put("ThrownEnderpearl", "minecraft:ender_pearl");
        ENTITY_ID_UPDATE.put("ThrownExpBottle", "minecraft:xp_bottle");
        ENTITY_ID_UPDATE.put("ThrownPotion", "minecraft:potion");
        ENTITY_ID_UPDATE.put("Villager", "minecraft:villager");
        ENTITY_ID_UPDATE.put("VillagerGolem", "minecraft:villager_golem");
        ENTITY_ID_UPDATE.put("Witch", "minecraft:witch");
        ENTITY_ID_UPDATE.put("WitherBoss", "minecraft:wither");
        ENTITY_ID_UPDATE.put("WitherSkeleton", "minecraft:wither_skeleton");
        ENTITY_ID_UPDATE.put("WitherSkull", "minecraft:wither_skull");
        ENTITY_ID_UPDATE.put("Wolf", "minecraft:wolf");
        ENTITY_ID_UPDATE.put("XPOrb", "minecraft:xp_orb");
        ENTITY_ID_UPDATE.put("Zombie", "minecraft:zombie");
        ENTITY_ID_UPDATE.put("ZombieHorse", "minecraft:zombie_horse");
        ENTITY_ID_UPDATE.put("ZombieVillager", "minecraft:zombie_villager");
    }
}

