/*
 * Decompiled with CFR 0.152.
 */
package ca.spottedleaf.dataconverter.minecraft.versions;

import ca.spottedleaf.dataconverter.converters.DataConverter;
import ca.spottedleaf.dataconverter.minecraft.converters.helpers.RenameHelper;
import ca.spottedleaf.dataconverter.minecraft.datatypes.MCTypeRegistry;
import ca.spottedleaf.dataconverter.minecraft.versions.V2841;
import ca.spottedleaf.dataconverter.minecraft.walkers.generic.WalkerUtils;
import ca.spottedleaf.dataconverter.types.ListType;
import ca.spottedleaf.dataconverter.types.MapType;
import ca.spottedleaf.dataconverter.types.ObjectType;
import ca.spottedleaf.dataconverter.types.Types;
import it.unimi.dsi.fastutil.ints.Int2IntLinkedOpenHashMap;
import it.unimi.dsi.fastutil.ints.IntBidirectionalIterator;
import it.unimi.dsi.fastutil.ints.IntOpenHashSet;
import java.util.Arrays;
import java.util.BitSet;
import java.util.HashSet;
import java.util.Set;
import org.apache.commons.lang3.mutable.MutableBoolean;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public final class V2832 {
    protected static final Logger LOGGER = LogManager.getLogger();
    protected static final int VERSION = 2832;
    private static final String[] BIOMES_BY_ID = new String[256];
    private static final String[] HEIGHTMAP_TYPES;
    private static final Set<String> STATUS_IS_OR_AFTER_SURFACE;
    private static final Set<String> STATUS_IS_OR_AFTER_NOISE;
    private static final Set<String> BLOCKS_BEFORE_FEATURE_STATUS;

    private static int getObjectsPerValue(long[] val) {
        return (4096 + val.length - 1) / val.length;
    }

    private static long[] resize(long[] val, int oldBitsPerObject, int newBitsPerObject) {
        long oldMask = (1L << oldBitsPerObject) - 1L;
        long newMask = (1L << newBitsPerObject) - 1L;
        int oldObjectsPerValue = 64 / oldBitsPerObject;
        int newObjectsPerValue = 64 / newBitsPerObject;
        if (newBitsPerObject == oldBitsPerObject) {
            return val;
        }
        int items = 4096;
        long[] ret = new long[(4096 + newObjectsPerValue - 1) / newObjectsPerValue];
        int expectedSize = (4096 + oldObjectsPerValue - 1) / oldObjectsPerValue;
        if (val.length != expectedSize) {
            throw new IllegalStateException("Expected size: " + expectedSize + ", got: " + val.length);
        }
        int shift = 0;
        int idx = 0;
        long newCurr = 0L;
        int currItem = 0;
        for (int i2 = 0; i2 < val.length; ++i2) {
            long oldCurr = val[i2];
            int objIdx = 0;
            while (currItem < 4096 && objIdx + oldBitsPerObject <= 64) {
                long value = oldCurr >> objIdx & oldMask;
                if ((value & newMask) != value) {
                    throw new IllegalStateException("Old data storage has values that cannot be moved into new palette (would erase data)!");
                }
                newCurr |= value << shift;
                if ((shift += newBitsPerObject) + newBitsPerObject > 64) {
                    ret[idx++] = newCurr;
                    shift = 0;
                    newCurr = 0L;
                }
                objIdx += oldBitsPerObject;
                ++currItem;
            }
        }
        if (shift != 0) {
            ret[idx] = newCurr;
        }
        return ret;
    }

    private static void fixLithiumChunks(MapType<String> data) {
        MapType level = data.getMap("Level");
        if (level == null) {
            return;
        }
        int chunkX = level.getInt("xPos");
        int chunkZ = level.getInt("zPos");
        ListType sections = level.getList("Sections", ObjectType.MAP);
        if (sections == null) {
            return;
        }
        int len = sections.size();
        for (int i2 = 0; i2 < len; ++i2) {
            int gotObjectsPerValue;
            int gotBits;
            int expectedBits;
            MapType section = sections.getMap(i2);
            int sectionY = section.getInt("Y");
            ListType palette = section.getList("Palette", ObjectType.MAP);
            long[] blockStates = section.getLongs("BlockStates");
            if (palette == null || blockStates == null || (expectedBits = Math.max(4, V2832.ceilLog2(palette.size()))) == (gotBits = 64 / (gotObjectsPerValue = V2832.getObjectsPerValue(blockStates)))) continue;
            try {
                section.setLongs("BlockStates", V2832.resize(blockStates, gotBits, expectedBits));
                continue;
            }
            catch (Exception ex) {
                LOGGER.fatal("Failed to rewrite mismatched palette and data storage for section y: " + sectionY + " for chunk [" + chunkX + "," + chunkZ + "], palette entries: " + palette.size() + ", data storage size: " + blockStates.length, (Throwable)ex);
            }
        }
    }

    public static void register() {
        MCTypeRegistry.WORLD_GEN_SETTINGS.addStructureConverter(new DataConverter<MapType<String>, MapType<String>>(2832){

            @Override
            public MapType<String> convert(MapType<String> data, long sourceVersion, long toVersion) {
                String type;
                boolean noHeightFlag = !data.hasKey("has_increased_height_already");
                boolean hasIncreasedHeight = data.getBoolean("has_increased_height_already", true);
                data.remove("has_increased_height_already");
                MapType dimensions = data.getMap("dimensions");
                if (dimensions == null) {
                    return null;
                }
                MapType overworld = dimensions.getMap("minecraft:overworld");
                if (overworld == null) {
                    return null;
                }
                MapType generator = overworld.getMap("generator");
                if (generator == null) {
                    return null;
                }
                switch (type = generator.getString("type", "")) {
                    case "minecraft:noise": {
                        MapType biomeSource = generator.getMap("biome_source");
                        String sourceType = biomeSource.getString("type");
                        boolean largeBiomes = false;
                        if ("minecraft:vanilla_layered".equals(sourceType) || noHeightFlag && "minecraft:multi_noise".equals(sourceType)) {
                            largeBiomes = biomeSource.getBoolean("large_biomes");
                            MapType<String> newBiomeSource = Types.NBT.createEmptyMap();
                            generator.setMap("biome_source", newBiomeSource);
                            newBiomeSource.setString("preset", "minecraft:overworld");
                            newBiomeSource.setString("type", "minecraft:multi_noise");
                        }
                        if (!largeBiomes || !"minecraft:overworld".equals(generator.getString("settings"))) break;
                        generator.setString("settings", "minecraft:large_biomes");
                        break;
                    }
                    case "minecraft:flat": {
                        MapType settings;
                        if (hasIncreasedHeight || (settings = generator.getMap("settings")) == null) break;
                        V2832.updateLayers(settings.getList("layers", ObjectType.MAP));
                        break;
                    }
                }
                return null;
            }
        });
        MCTypeRegistry.CHUNK.addStructureConverter(new DataConverter<MapType<String>, MapType<String>>(2832){

            @Override
            public MapType<String> convert(MapType<String> data, long sourceVersion, long toVersion) {
                V2832.fixLithiumChunks(data);
                MapType<String> level = data.getMap("Level");
                if (level == null) {
                    return null;
                }
                MapType context = data.getMap("__context");
                String dimension = context == null ? "" : context.getString("dimension", "");
                String generator = context == null ? "" : context.getString("generator", "");
                boolean isOverworld = "minecraft:overworld".equals(dimension);
                int minSection = isOverworld ? -4 : 0;
                MutableBoolean isAlreadyExtended = new MutableBoolean();
                MapType<String>[] newBiomes = V2832.createBiomeSections(level, isOverworld, minSection, isAlreadyExtended);
                MapType<String> wrappedEmptyBlockPalette = V2832.getEmptyBlockPalette();
                ListType sections = level.getList("Sections", ObjectType.MAP);
                if (sections == null) {
                    sections = Types.NBT.createEmptyList();
                    level.setList("Sections", sections);
                }
                V2841.SimplePaletteReader bottomSection = null;
                HashSet<String> allBlocks = new HashSet<String>();
                IntOpenHashSet existingSections = new IntOpenHashSet();
                int len = sections.size();
                for (int i2 = 0; i2 < len; ++i2) {
                    MapType<String> palettedContainer;
                    MapType section = sections.getMap(i2);
                    int y2 = section.getInt("Y");
                    int sectionIndex = y2 - minSection;
                    existingSections.add(y2);
                    if (sectionIndex >= 0 && sectionIndex < newBiomes.length) {
                        section.setMap("biomes", newBiomes[sectionIndex]);
                    }
                    ListType palette = section.getList("Palette", ObjectType.MAP);
                    long[] blockStates = section.getLongs("BlockStates");
                    section.remove("Palette");
                    section.remove("BlockStates");
                    if (palette != null) {
                        int len2 = palette.size();
                        for (int j2 = 0; j2 < len2; ++j2) {
                            allBlocks.add(V2841.getBlockId(palette.getMap(j2)));
                        }
                    }
                    if (palette != null && blockStates != null) {
                        palettedContainer = V2832.wrapPaletteOptimised(palette, blockStates);
                        section.setMap("block_states", palettedContainer);
                    } else {
                        palettedContainer = wrappedEmptyBlockPalette.copy();
                        section.setMap("block_states", palettedContainer);
                    }
                    if (section.getInt("Y", Integer.MAX_VALUE) != 0) continue;
                    bottomSection = new V2841.SimplePaletteReader(palettedContainer.getList("palette", ObjectType.MAP), palettedContainer.getLongs("data"));
                }
                for (int sectionIndex = 0; sectionIndex < newBiomes.length; ++sectionIndex) {
                    int sectionY = sectionIndex + minSection;
                    if (!existingSections.add(sectionY)) continue;
                    MapType<String> newSection = Types.NBT.createEmptyMap();
                    sections.addMap(newSection);
                    newSection.setByte("Y", (byte)sectionY);
                    newSection.setMap("block_states", wrappedEmptyBlockPalette.copy());
                    newSection.setGeneric("biomes", newBiomes[sectionIndex]);
                }
                V2832.predictChunkStatusBeforeSurface(level, allBlocks);
                V2832.updateChunkData(level, isOverworld, isAlreadyExtended.getValue(), "minecraft:noise".equals(generator), bottomSection);
                return null;
            }
        });
        MCTypeRegistry.WORLD_GEN_SETTINGS.addStructureWalker(2832, (data, fromVersion, toVersion) -> {
            MapType dimensions = data.getMap("dimensions");
            if (dimensions == null) {
                return null;
            }
            for (String dimension : dimensions.keys()) {
                block24: {
                    String type;
                    MapType generator;
                    MapType dimensionData = dimensions.getMap(dimension);
                    if (dimensionData == null || (generator = dimensionData.getMap("generator")) == null || (type = generator.getString("type")) == null) continue;
                    block4 : switch (type) {
                        case "minecraft:flat": {
                            MapType<String> settings = generator.getMap("settings");
                            if (settings == null) break;
                            WalkerUtils.convert(MCTypeRegistry.BIOME, settings, "biome", fromVersion, toVersion);
                            ListType layers = settings.getList("layers", ObjectType.MAP);
                            if (layers == null) break;
                            int len = layers.size();
                            for (int i2 = 0; i2 < len; ++i2) {
                                WalkerUtils.convert(MCTypeRegistry.BLOCK_NAME, layers.getMap(i2), "block", fromVersion, toVersion);
                            }
                            break;
                        }
                        case "minecraft:noise": {
                            String biomeSourceType;
                            MapType<String> biomeSource;
                            MapType<String> settings = generator.getMap("settings");
                            if (settings != null) {
                                WalkerUtils.convert(MCTypeRegistry.BLOCK_NAME, settings, "default_block", fromVersion, toVersion);
                                WalkerUtils.convert(MCTypeRegistry.BLOCK_NAME, settings, "default_fluid", fromVersion, toVersion);
                            }
                            if ((biomeSource = generator.getMap("biome_source")) == null) break;
                            switch (biomeSourceType = biomeSource.getString("type", "")) {
                                case "minecraft:fixed": {
                                    WalkerUtils.convert(MCTypeRegistry.BIOME, biomeSource, "biome", fromVersion, toVersion);
                                    break;
                                }
                                case "minecraft:multi_noise": {
                                    ListType biomes = biomeSource.getList("biomes", ObjectType.MAP);
                                    if (biomes != null) {
                                        int len = biomes.size();
                                        for (int i3 = 0; i3 < len; ++i3) {
                                            WalkerUtils.convert(MCTypeRegistry.BIOME, biomes.getMap(i3), "biome", fromVersion, toVersion);
                                        }
                                        break block4;
                                    }
                                    break block24;
                                }
                                case "minecraft:checkerboard": {
                                    WalkerUtils.convertList(MCTypeRegistry.BIOME, biomeSource, "biomes", fromVersion, toVersion);
                                }
                            }
                            break;
                        }
                    }
                }
            }
            return null;
        });
        MCTypeRegistry.CHUNK.addStructureWalker(2832, (data, fromVersion, toVersion) -> {
            ListType sections;
            MapType<String> level = data.getMap("Level");
            if (level == null) {
                return null;
            }
            WalkerUtils.convertList(MCTypeRegistry.ENTITY, level, "Entities", fromVersion, toVersion);
            WalkerUtils.convertList(MCTypeRegistry.TILE_ENTITY, level, "TileEntities", fromVersion, toVersion);
            ListType tileTicks = level.getList("TileTicks", ObjectType.MAP);
            if (tileTicks != null) {
                int len = tileTicks.size();
                for (int i2 = 0; i2 < len; ++i2) {
                    MapType<String> tileTick = tileTicks.getMap(i2);
                    WalkerUtils.convert(MCTypeRegistry.BLOCK_NAME, tileTick, "i", fromVersion, toVersion);
                }
            }
            if ((sections = level.getList("Sections", ObjectType.MAP)) != null) {
                int len = sections.size();
                for (int i3 = 0; i3 < len; ++i3) {
                    MapType section = sections.getMap(i3);
                    WalkerUtils.convertList(MCTypeRegistry.BIOME, section.getMap("biomes"), "palette", fromVersion, toVersion);
                    WalkerUtils.convertList(MCTypeRegistry.BLOCK_STATE, section.getMap("block_states"), "palette", fromVersion, toVersion);
                }
            }
            WalkerUtils.convertValues(MCTypeRegistry.STRUCTURE_FEATURE, level.getMap("Structures"), "Starts", fromVersion, toVersion);
            return null;
        });
    }

    private static void predictChunkStatusBeforeSurface(MapType<String> level, Set<String> chunkBlocks) {
        boolean chunkFeatureStatus;
        String status = level.getString("Status", "empty");
        if (STATUS_IS_OR_AFTER_SURFACE.contains(status)) {
            return;
        }
        chunkBlocks.remove("minecraft:air");
        boolean chunkNotEmpty = !chunkBlocks.isEmpty();
        chunkBlocks.removeAll(BLOCKS_BEFORE_FEATURE_STATUS);
        boolean bl = chunkFeatureStatus = !chunkBlocks.isEmpty();
        String update = chunkFeatureStatus ? "liquid_carvers" : (!"noise".equals(status) && !chunkNotEmpty ? ("biomes".equals(status) ? "structure_references" : status) : "noise");
        level.setString("Status", update);
    }

    private static MapType<String> getEmptyBlockPalette() {
        MapType<String> airBlockState = Types.NBT.createEmptyMap();
        airBlockState.setString("Name", "minecraft:air");
        ListType emptyBlockPalette = Types.NBT.createEmptyList();
        emptyBlockPalette.addMap(airBlockState);
        return V2832.wrapPalette(emptyBlockPalette);
    }

    private static void shiftUpgradeData(MapType<String> upgradeData, int shift) {
        if (upgradeData == null) {
            return;
        }
        MapType<String> indices = upgradeData.getMap("Indices");
        if (indices == null) {
            return;
        }
        RenameHelper.renameKeys(indices, input -> Integer.toString(Integer.parseInt(input) + shift));
    }

    private static void updateChunkData(MapType<String> level, boolean wantExtendedHeight, boolean isAlreadyExtended, boolean onNoiseGenerator, V2841.SimplePaletteReader bottomSection) {
        level.remove("Biomes");
        if (!wantExtendedHeight) {
            V2832.padCarvingMasks(level, 16, 0);
            return;
        }
        if (isAlreadyExtended) {
            V2832.padCarvingMasks(level, 24, 0);
            return;
        }
        V2832.offsetHeightmaps(level);
        V2832.addEmptyListPadding(level, "Lights");
        V2832.addEmptyListPadding(level, "LiquidsToBeTicked");
        V2832.addEmptyListPadding(level, "PostProcessing");
        V2832.addEmptyListPadding(level, "ToBeTicked");
        V2832.shiftUpgradeData(level.getMap("UpgradeData"), 4);
        V2832.padCarvingMasks(level, 24, 4);
        if (!onNoiseGenerator) {
            return;
        }
        String status = level.getString("Status");
        if (status == null || "empty".equals(status)) {
            return;
        }
        MapType<String> blendingData = Types.NBT.createEmptyMap();
        level.setMap("blending_data", blendingData);
        blendingData.setBoolean("old_noise", STATUS_IS_OR_AFTER_NOISE.contains(status));
        if (bottomSection == null) {
            return;
        }
        BitSet missingBedrock = new BitSet(256);
        boolean hasBedrock = status.equals("noise");
        for (int z2 = 0; z2 <= 15; ++z2) {
            for (int x2 = 0; x2 <= 15; ++x2) {
                boolean isAir;
                MapType<String> state = bottomSection.getState(x2, 0, z2);
                String blockId = V2841.getBlockId(state);
                boolean isBedrock = state != null && "minecraft:bedrock".equals(blockId);
                boolean bl = isAir = state != null && "minecraft:air".equals(blockId);
                if (isAir) {
                    missingBedrock.set(z2 << 4 | x2);
                }
                hasBedrock |= isBedrock;
            }
        }
        if (hasBedrock && missingBedrock.cardinality() != missingBedrock.size()) {
            String targetStatus = "full".equals(status) ? "heightmaps" : status;
            MapType<String> belowZeroRetrogen = Types.NBT.createEmptyMap();
            level.setMap("below_zero_retrogen", belowZeroRetrogen);
            belowZeroRetrogen.setString("target_status", targetStatus);
            belowZeroRetrogen.setLongs("missing_bedrock", missingBedrock.toLongArray());
            level.setString("Status", "empty");
        }
        level.setBoolean("isLightOn", false);
    }

    private static void padCarvingMasks(MapType<String> level, int newSize, int offset) {
        MapType carvingMasks = level.getMap("CarvingMasks");
        if (carvingMasks == null) {
            level.setMap("CarvingMasks", Types.NBT.createEmptyMap());
            return;
        }
        for (String key : carvingMasks.keys()) {
            long[] old = BitSet.valueOf(carvingMasks.getBytes(key)).toLongArray();
            long[] newVal = new long[64 * newSize];
            System.arraycopy(old, 0, newVal, 64 * offset, old.length);
            carvingMasks.setLongs(key, newVal);
        }
    }

    private static void addEmptyListPadding(MapType<String> level, String path) {
        ListType list = level.getListUnchecked(path);
        if (list != null && list.size() == 24) {
            return;
        }
        if (list == null) {
            return;
        }
        for (int i2 = 0; i2 < 4; ++i2) {
            list.addList(0, Types.NBT.createEmptyList());
            list.addList(Types.NBT.createEmptyList());
        }
    }

    private static void offsetHeightmaps(MapType<String> level) {
        MapType heightmaps = level.getMap("Heightmaps");
        if (heightmaps == null) {
            return;
        }
        for (String key : HEIGHTMAP_TYPES) {
            V2832.offsetHeightmap(heightmaps.getLongs(key));
        }
    }

    private static void offsetHeightmap(long[] heightmap) {
        if (heightmap == null) {
            return;
        }
        for (long curr : heightmap) {
            long next = 0L;
            int objIdx = 0;
            while (objIdx + 9 <= 64) {
                long value = curr >> objIdx & 0x1FFL;
                if (value != 0L) {
                    long offset = Math.min(511L, value + 64L);
                    next |= offset << objIdx;
                }
                objIdx += 9;
            }
            heightmap[idx] = next;
        }
    }

    private static MapType<String>[] createBiomeSections(MapType<String> level, boolean wantExtendedHeight, int minSection, MutableBoolean isAlreadyExtended) {
        MapType[] ret;
        block6: {
            block7: {
                int sectionIndex;
                int[] biomes;
                block5: {
                    ret = new MapType[wantExtendedHeight ? 24 : 16];
                    biomes = level.getInts("Biomes");
                    if (biomes == null || biomes.length != 1536) break block5;
                    isAlreadyExtended.setValue(true);
                    for (int sectionIndex2 = 0; sectionIndex2 < 24; ++sectionIndex2) {
                        ret[sectionIndex2] = V2832.createBiomeSection(biomes, sectionIndex2 * 64, -1);
                    }
                    break block6;
                }
                if (biomes == null || biomes.length != 1024) break block7;
                for (int sectionY = 0; sectionY < 16; ++sectionY) {
                    ret[sectionY - minSection] = V2832.createBiomeSection(biomes, sectionY * 64, -1);
                }
                if (!wantExtendedHeight) break block6;
                MapType<String> bottomCopy = V2832.createBiomeSection(biomes, 0, 15);
                MapType<String> topCopy = V2832.createBiomeSection(biomes, 1008, 15);
                for (sectionIndex = 0; sectionIndex < 4; ++sectionIndex) {
                    ret[sectionIndex] = bottomCopy.copy();
                }
                for (sectionIndex = 20; sectionIndex < 24; ++sectionIndex) {
                    ret[sectionIndex] = topCopy.copy();
                }
                break block6;
            }
            ListType palette = Types.NBT.createEmptyList();
            palette.addString("minecraft:plains");
            for (int i2 = 0; i2 < ret.length; ++i2) {
                ret[i2] = V2832.wrapPalette(palette.copy());
            }
        }
        return ret;
    }

    private static MapType<String> createBiomeSection(int[] biomes, int offset, int mask) {
        Int2IntLinkedOpenHashMap paletteId = new Int2IntLinkedOpenHashMap();
        for (int idx = 0; idx < 64; ++idx) {
            int biome = biomes[offset + (idx & mask)];
            paletteId.putIfAbsent(biome, paletteId.size());
        }
        ListType paletteString = Types.NBT.createEmptyList();
        IntBidirectionalIterator iterator = paletteId.keySet().iterator();
        while (iterator.hasNext()) {
            int biomeId = iterator.nextInt();
            String biome = biomeId >= 0 && biomeId < BIOMES_BY_ID.length ? BIOMES_BY_ID[biomeId] : null;
            paletteString.addString(biome == null ? "minecraft:plains" : biome);
        }
        int bitsPerObject = V2832.ceilLog2(paletteString.size());
        if (bitsPerObject == 0) {
            return V2832.wrapPalette(paletteString);
        }
        int objectsPerValue = 64 / bitsPerObject;
        long[] packed = new long[(64 + objectsPerValue - 1) / objectsPerValue];
        int shift = 0;
        int idx = 0;
        long curr = 0L;
        for (int biome_idx = 0; biome_idx < 64; ++biome_idx) {
            int biome = biomes[offset + (biome_idx & mask)];
            curr |= (long)paletteId.get(biome) << shift;
            if ((shift += bitsPerObject) + bitsPerObject <= 64) continue;
            packed[idx++] = curr;
            shift = 0;
            curr = 0L;
        }
        if (shift != 0) {
            packed[idx] = curr;
        }
        return V2832.wrapPalette(paletteString, packed);
    }

    private static MapType<String> wrapPalette(ListType palette) {
        return V2832.wrapPalette(palette, null);
    }

    private static MapType<String> wrapPalette(ListType palette, long[] blockStates) {
        MapType<String> ret = Types.NBT.createEmptyMap();
        ret.setList("palette", palette);
        if (blockStates != null) {
            ret.setLongs("data", blockStates);
        }
        return ret;
    }

    private static MapType<String> wrapPaletteOptimised(ListType palette, long[] blockStates) {
        if (palette.size() == 1) {
            return V2832.wrapPalette(palette);
        }
        return V2832.wrapPalette(palette, blockStates);
    }

    public static int ceilLog2(int value) {
        return value == 0 ? 0 : 32 - Integer.numberOfLeadingZeros(value - 1);
    }

    private static void updateLayers(ListType layers) {
        if (layers == null) {
            return;
        }
        layers.addMap(0, V2832.createEmptyLayer());
    }

    private static MapType<String> createEmptyLayer() {
        MapType<String> ret = Types.NBT.createEmptyMap();
        ret.setInt("height", 64);
        ret.setString("block", "minecraft:air");
        return ret;
    }

    static {
        V2832.BIOMES_BY_ID[0] = "minecraft:ocean";
        V2832.BIOMES_BY_ID[1] = "minecraft:plains";
        V2832.BIOMES_BY_ID[2] = "minecraft:desert";
        V2832.BIOMES_BY_ID[3] = "minecraft:mountains";
        V2832.BIOMES_BY_ID[4] = "minecraft:forest";
        V2832.BIOMES_BY_ID[5] = "minecraft:taiga";
        V2832.BIOMES_BY_ID[6] = "minecraft:swamp";
        V2832.BIOMES_BY_ID[7] = "minecraft:river";
        V2832.BIOMES_BY_ID[8] = "minecraft:nether_wastes";
        V2832.BIOMES_BY_ID[9] = "minecraft:the_end";
        V2832.BIOMES_BY_ID[10] = "minecraft:frozen_ocean";
        V2832.BIOMES_BY_ID[11] = "minecraft:frozen_river";
        V2832.BIOMES_BY_ID[12] = "minecraft:snowy_tundra";
        V2832.BIOMES_BY_ID[13] = "minecraft:snowy_mountains";
        V2832.BIOMES_BY_ID[14] = "minecraft:mushroom_fields";
        V2832.BIOMES_BY_ID[15] = "minecraft:mushroom_field_shore";
        V2832.BIOMES_BY_ID[16] = "minecraft:beach";
        V2832.BIOMES_BY_ID[17] = "minecraft:desert_hills";
        V2832.BIOMES_BY_ID[18] = "minecraft:wooded_hills";
        V2832.BIOMES_BY_ID[19] = "minecraft:taiga_hills";
        V2832.BIOMES_BY_ID[20] = "minecraft:mountain_edge";
        V2832.BIOMES_BY_ID[21] = "minecraft:jungle";
        V2832.BIOMES_BY_ID[22] = "minecraft:jungle_hills";
        V2832.BIOMES_BY_ID[23] = "minecraft:jungle_edge";
        V2832.BIOMES_BY_ID[24] = "minecraft:deep_ocean";
        V2832.BIOMES_BY_ID[25] = "minecraft:stone_shore";
        V2832.BIOMES_BY_ID[26] = "minecraft:snowy_beach";
        V2832.BIOMES_BY_ID[27] = "minecraft:birch_forest";
        V2832.BIOMES_BY_ID[28] = "minecraft:birch_forest_hills";
        V2832.BIOMES_BY_ID[29] = "minecraft:dark_forest";
        V2832.BIOMES_BY_ID[30] = "minecraft:snowy_taiga";
        V2832.BIOMES_BY_ID[31] = "minecraft:snowy_taiga_hills";
        V2832.BIOMES_BY_ID[32] = "minecraft:giant_tree_taiga";
        V2832.BIOMES_BY_ID[33] = "minecraft:giant_tree_taiga_hills";
        V2832.BIOMES_BY_ID[34] = "minecraft:wooded_mountains";
        V2832.BIOMES_BY_ID[35] = "minecraft:savanna";
        V2832.BIOMES_BY_ID[36] = "minecraft:savanna_plateau";
        V2832.BIOMES_BY_ID[37] = "minecraft:badlands";
        V2832.BIOMES_BY_ID[38] = "minecraft:wooded_badlands_plateau";
        V2832.BIOMES_BY_ID[39] = "minecraft:badlands_plateau";
        V2832.BIOMES_BY_ID[40] = "minecraft:small_end_islands";
        V2832.BIOMES_BY_ID[41] = "minecraft:end_midlands";
        V2832.BIOMES_BY_ID[42] = "minecraft:end_highlands";
        V2832.BIOMES_BY_ID[43] = "minecraft:end_barrens";
        V2832.BIOMES_BY_ID[44] = "minecraft:warm_ocean";
        V2832.BIOMES_BY_ID[45] = "minecraft:lukewarm_ocean";
        V2832.BIOMES_BY_ID[46] = "minecraft:cold_ocean";
        V2832.BIOMES_BY_ID[47] = "minecraft:deep_warm_ocean";
        V2832.BIOMES_BY_ID[48] = "minecraft:deep_lukewarm_ocean";
        V2832.BIOMES_BY_ID[49] = "minecraft:deep_cold_ocean";
        V2832.BIOMES_BY_ID[50] = "minecraft:deep_frozen_ocean";
        V2832.BIOMES_BY_ID[127] = "minecraft:the_void";
        V2832.BIOMES_BY_ID[129] = "minecraft:sunflower_plains";
        V2832.BIOMES_BY_ID[130] = "minecraft:desert_lakes";
        V2832.BIOMES_BY_ID[131] = "minecraft:gravelly_mountains";
        V2832.BIOMES_BY_ID[132] = "minecraft:flower_forest";
        V2832.BIOMES_BY_ID[133] = "minecraft:taiga_mountains";
        V2832.BIOMES_BY_ID[134] = "minecraft:swamp_hills";
        V2832.BIOMES_BY_ID[140] = "minecraft:ice_spikes";
        V2832.BIOMES_BY_ID[149] = "minecraft:modified_jungle";
        V2832.BIOMES_BY_ID[151] = "minecraft:modified_jungle_edge";
        V2832.BIOMES_BY_ID[155] = "minecraft:tall_birch_forest";
        V2832.BIOMES_BY_ID[156] = "minecraft:tall_birch_hills";
        V2832.BIOMES_BY_ID[157] = "minecraft:dark_forest_hills";
        V2832.BIOMES_BY_ID[158] = "minecraft:snowy_taiga_mountains";
        V2832.BIOMES_BY_ID[160] = "minecraft:giant_spruce_taiga";
        V2832.BIOMES_BY_ID[161] = "minecraft:giant_spruce_taiga_hills";
        V2832.BIOMES_BY_ID[162] = "minecraft:modified_gravelly_mountains";
        V2832.BIOMES_BY_ID[163] = "minecraft:shattered_savanna";
        V2832.BIOMES_BY_ID[164] = "minecraft:shattered_savanna_plateau";
        V2832.BIOMES_BY_ID[165] = "minecraft:eroded_badlands";
        V2832.BIOMES_BY_ID[166] = "minecraft:modified_wooded_badlands_plateau";
        V2832.BIOMES_BY_ID[167] = "minecraft:modified_badlands_plateau";
        V2832.BIOMES_BY_ID[168] = "minecraft:bamboo_jungle";
        V2832.BIOMES_BY_ID[169] = "minecraft:bamboo_jungle_hills";
        V2832.BIOMES_BY_ID[170] = "minecraft:soul_sand_valley";
        V2832.BIOMES_BY_ID[171] = "minecraft:crimson_forest";
        V2832.BIOMES_BY_ID[172] = "minecraft:warped_forest";
        V2832.BIOMES_BY_ID[173] = "minecraft:basalt_deltas";
        V2832.BIOMES_BY_ID[174] = "minecraft:dripstone_caves";
        V2832.BIOMES_BY_ID[175] = "minecraft:lush_caves";
        V2832.BIOMES_BY_ID[177] = "minecraft:meadow";
        V2832.BIOMES_BY_ID[178] = "minecraft:grove";
        V2832.BIOMES_BY_ID[179] = "minecraft:snowy_slopes";
        V2832.BIOMES_BY_ID[180] = "minecraft:snowcapped_peaks";
        V2832.BIOMES_BY_ID[181] = "minecraft:lofty_peaks";
        V2832.BIOMES_BY_ID[182] = "minecraft:stony_peaks";
        HEIGHTMAP_TYPES = new String[]{"WORLD_SURFACE_WG", "WORLD_SURFACE", "WORLD_SURFACE_IGNORE_SNOW", "OCEAN_FLOOR_WG", "OCEAN_FLOOR", "MOTION_BLOCKING", "MOTION_BLOCKING_NO_LEAVES"};
        STATUS_IS_OR_AFTER_SURFACE = new HashSet<String>(Arrays.asList("surface", "carvers", "liquid_carvers", "features", "light", "spawn", "heightmaps", "full"));
        STATUS_IS_OR_AFTER_NOISE = new HashSet<String>(Arrays.asList("noise", "surface", "carvers", "liquid_carvers", "features", "light", "spawn", "heightmaps", "full"));
        BLOCKS_BEFORE_FEATURE_STATUS = new HashSet<String>(Arrays.asList("minecraft:air", "minecraft:basalt", "minecraft:bedrock", "minecraft:blackstone", "minecraft:calcite", "minecraft:cave_air", "minecraft:coarse_dirt", "minecraft:crimson_nylium", "minecraft:dirt", "minecraft:end_stone", "minecraft:grass_block", "minecraft:gravel", "minecraft:ice", "minecraft:lava", "minecraft:mycelium", "minecraft:nether_wart_block", "minecraft:netherrack", "minecraft:orange_terracotta", "minecraft:packed_ice", "minecraft:podzol", "minecraft:powder_snow", "minecraft:red_sand", "minecraft:red_sandstone", "minecraft:sand", "minecraft:sandstone", "minecraft:snow_block", "minecraft:soul_sand", "minecraft:soul_soil", "minecraft:stone", "minecraft:terracotta", "minecraft:warped_nylium", "minecraft:warped_wart_block", "minecraft:water", "minecraft:white_terracotta"));
    }
}

