/*
 * Decompiled with CFR 0.152.
 */
package ca.spottedleaf.dataconverter.minecraft.versions;

import ca.spottedleaf.dataconverter.converters.DataConverter;
import ca.spottedleaf.dataconverter.minecraft.datatypes.MCTypeRegistry;
import ca.spottedleaf.dataconverter.types.MapType;
import com.google.common.collect.ImmutableMap;
import java.util.Map;

public final class V2518 {
    protected static final int VERSION = 2518;
    private static final Map<String, String> FACING_RENAMES = ImmutableMap.builder().put((Object)"down", (Object)"down_south").put((Object)"up", (Object)"up_north").put((Object)"north", (Object)"north_up").put((Object)"south", (Object)"south_up").put((Object)"west", (Object)"west_up").put((Object)"east", (Object)"east_up").build();

    private V2518() {
    }

    public static void register() {
        MCTypeRegistry.TILE_ENTITY.addConverterForId("minecraft:jigsaw", new DataConverter<MapType<String>, MapType<String>>(2518){

            @Override
            public MapType<String> convert(MapType<String> data, long sourceVersion, long toVersion) {
                String type = data.getString("attachement_type", "minecraft:empty");
                String pool = data.getString("target_pool", "minecraft:empty");
                data.remove("attachement_type");
                data.remove("target_pool");
                data.setString("name", type);
                data.setString("target", type);
                data.setString("pool", pool);
                return null;
            }
        });
        MCTypeRegistry.BLOCK_STATE.addStructureConverter(new DataConverter<MapType<String>, MapType<String>>(2518){

            @Override
            public MapType<String> convert(MapType<String> data, long sourceVersion, long toVersion) {
                if (!"minecraft:jigsaw".equals(data.getString("Name"))) {
                    return null;
                }
                MapType properties = data.getMap("Properties");
                if (properties == null) {
                    return null;
                }
                String facing = properties.getString("facing", "north");
                properties.remove("facing");
                properties.setString("orientation", FACING_RENAMES.getOrDefault(facing, facing));
                return null;
            }
        });
    }
}

