/*
 * Decompiled with CFR 0.152.
 */
package ca.spottedleaf.dataconverter.minecraft;

import ca.spottedleaf.dataconverter.converters.DataConverter;
import ca.spottedleaf.dataconverter.converters.datatypes.DataType;
import ca.spottedleaf.dataconverter.minecraft.MCVersionRegistry;
import ca.spottedleaf.dataconverter.minecraft.datatypes.MCDataType;
import ca.spottedleaf.dataconverter.types.json.JsonMapType;
import ca.spottedleaf.dataconverter.types.nbt.NBTMapType;
import com.google.gson.JsonObject;
import it.unimi.dsi.fastutil.longs.LongArrayList;
import net.minecraft.nbt.NBTTagCompound;

public final class MCDataConverter {
    private static final LongArrayList BREAKPOINTS = MCVersionRegistry.getBreakpoints();

    public static <T> T copy(T type) {
        if (type instanceof NBTTagCompound) {
            return (T)((NBTTagCompound)type).g();
        }
        if (type instanceof JsonObject) {
            return (T)((JsonObject)type).deepCopy();
        }
        return type;
    }

    public static <T, R> R convertUnwrapped(DataType<T, R> type, T data, boolean compressedJson, int fromVersion, int toVersion) {
        if (data instanceof NBTTagCompound) {
            return (R)MCDataConverter.convertTag((MCDataType)type, (NBTTagCompound)data, fromVersion, toVersion);
        }
        if (data instanceof JsonObject) {
            return (R)MCDataConverter.convertJson((MCDataType)type, (JsonObject)data, compressedJson, fromVersion, toVersion);
        }
        return MCDataConverter.convert(type, data, fromVersion, toVersion);
    }

    public static NBTTagCompound convertTag(MCDataType type, NBTTagCompound data, int fromVersion, int toVersion) {
        NBTMapType wrapped = new NBTMapType(data);
        NBTMapType replaced = (NBTMapType)MCDataConverter.convert(type, wrapped, fromVersion, toVersion);
        return replaced == null ? wrapped.getTag() : replaced.getTag();
    }

    public static JsonObject convertJson(MCDataType type, JsonObject data, boolean compressed, int fromVersion, int toVersion) {
        JsonMapType wrapped = new JsonMapType(data, compressed);
        JsonMapType replaced = (JsonMapType)MCDataConverter.convert(type, wrapped, fromVersion, toVersion);
        return replaced == null ? wrapped.getJson() : replaced.getJson();
    }

    public static <T, R> R convert(DataType<T, R> type, T data, int fromVersion, int toVersion) {
        R converted;
        Object ret = data;
        long currentVersion = DataConverter.encodeVersions(fromVersion < 99 ? 99 : fromVersion, Integer.MAX_VALUE);
        long nextVersion = DataConverter.encodeVersions(toVersion, Integer.MAX_VALUE);
        int len = BREAKPOINTS.size();
        for (int i2 = 0; i2 < len; ++i2) {
            long breakpoint = BREAKPOINTS.getLong(i2);
            if (currentVersion >= breakpoint) continue;
            R converted2 = type.convert(ret, currentVersion, Math.min(nextVersion, breakpoint - 1L));
            if (converted2 != null) {
                ret = converted2;
            }
            if ((currentVersion = Math.min(nextVersion, breakpoint - 1L)) == nextVersion) break;
        }
        if (currentVersion != nextVersion && (converted = type.convert(ret, currentVersion, nextVersion)) != null) {
            ret = converted;
        }
        return (R)ret;
    }

    private MCDataConverter() {
    }
}

