/*
 * Decompiled with CFR 0.152.
 */
package de.maxhenkel.voicechat.voice.server;

import de.maxhenkel.voicechat.Voicechat;
import de.maxhenkel.voicechat.command.VoiceChatCommands;
import de.maxhenkel.voicechat.net.NetManager;
import de.maxhenkel.voicechat.net.RequestSecretPacket;
import de.maxhenkel.voicechat.net.SecretPacket;
import de.maxhenkel.voicechat.net.kyori.adventure.text.Component;
import de.maxhenkel.voicechat.net.kyori.adventure.text.ComponentLike;
import de.maxhenkel.voicechat.net.kyori.adventure.text.TextComponent;
import de.maxhenkel.voicechat.net.kyori.adventure.text.format.TextDecoration;
import de.maxhenkel.voicechat.plugins.PluginManager;
import de.maxhenkel.voicechat.voice.server.Server;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.player.PlayerQuitEvent;

public class ServerVoiceEvents
implements Listener {
    private final Map<UUID, Integer> clientCompatibilities = new ConcurrentHashMap<UUID, Integer>();
    private Server server;

    public ServerVoiceEvents(org.bukkit.Server mcServer) {
        this.server = new Server(Voicechat.SERVER_CONFIG.voiceChatPort.get(), mcServer);
        this.server.start();
        PluginManager.instance().onServerStarted(mcServer);
    }

    public void onRequestSecretPacket(Player player, RequestSecretPacket packet) {
        UUID playerUUID;
        Voicechat.LOGGER.info("Received secret request of {} ({})", (Object)player.getName(), (Object)packet.getCompatibilityVersion());
        try {
            playerUUID = player.getUniqueId();
        }
        catch (UnsupportedOperationException e) {
            player.kickPlayer("Tried to authenticate voice chat while still connecting");
            Voicechat.LOGGER.warn("{} tried to authenticate voice chat while still connecting", (Object)player.getName());
            return;
        }
        this.clientCompatibilities.put(playerUUID, packet.getCompatibilityVersion());
        if (packet.getCompatibilityVersion() != Voicechat.COMPATIBILITY_VERSION) {
            Voicechat.LOGGER.warn("Connected client {} has incompatible voice chat version (server={}, client={})", (Object)player.getName(), (Object)Voicechat.COMPATIBILITY_VERSION, (Object)packet.getCompatibilityVersion());
            NetManager.sendMessage(player, ServerVoiceEvents.getIncompatibleMessage(packet.getCompatibilityVersion()));
        } else {
            this.initializePlayerConnection(player);
        }
    }

    public boolean isCompatible(Player player) {
        return this.clientCompatibilities.getOrDefault(player.getUniqueId(), -1) == Voicechat.COMPATIBILITY_VERSION;
    }

    public static Component getIncompatibleMessage(int clientCompatibilityVersion) {
        if (clientCompatibilityVersion <= 6) {
            return Component.text(String.format(Voicechat.translate("not_compatible"), Voicechat.INSTANCE.getDescription().getVersion(), "Simple Voice Chat"));
        }
        return Component.translatable("message.voicechat.incompatible_version", new ComponentLike[]{((TextComponent.Builder)((TextComponent.Builder)Component.text(Voicechat.INSTANCE.getDescription().getVersion()).toBuilder()).decorate(TextDecoration.BOLD)).build(), ((TextComponent.Builder)((TextComponent.Builder)Component.text("Simple Voice Chat").toBuilder()).decorate(TextDecoration.BOLD)).build()});
    }

    public void initializePlayerConnection(Player player) {
        if (this.server == null) {
            return;
        }
        this.server.getPlayerStateManager().onPlayerCompatibilityCheckSucceded(player);
        if (!player.hasPermission(VoiceChatCommands.CONNECT_PERMISSION)) {
            Voicechat.LOGGER.info("Player {} has no permission to connect to the voice chat", (Object)player.getName());
            return;
        }
        UUID secret = this.server.getSecret(player.getUniqueId());
        boolean hasGroupPermission = player.hasPermission(VoiceChatCommands.GROUPS_PERMISSION);
        NetManager.sendToClient(player, new SecretPacket(player, secret, hasGroupPermission, Voicechat.SERVER_CONFIG));
        Voicechat.LOGGER.info("Sent secret to {}", (Object)player.getName());
    }

    @EventHandler
    public void onPlayerQuit(PlayerQuitEvent event) {
        this.clientCompatibilities.remove(event.getPlayer().getUniqueId());
        if (this.server == null) {
            return;
        }
        this.server.disconnectClient(event.getPlayer().getUniqueId());
        Voicechat.LOGGER.info("Disconnecting client " + event.getPlayer().getName());
    }

    public Server getServer() {
        return this.server;
    }
}

