/*
 * Decompiled with CFR 0.152.
 */
package de.maxhenkel.voicechat.voice.server;

import de.maxhenkel.voicechat.Voicechat;
import de.maxhenkel.voicechat.api.RawUdpPacket;
import de.maxhenkel.voicechat.api.VoicechatSocket;
import de.maxhenkel.voicechat.command.VoiceChatCommands;
import de.maxhenkel.voicechat.debug.CooldownTimer;
import de.maxhenkel.voicechat.plugins.PluginManager;
import de.maxhenkel.voicechat.voice.common.AuthenticateAckPacket;
import de.maxhenkel.voicechat.voice.common.AuthenticatePacket;
import de.maxhenkel.voicechat.voice.common.ClientGroup;
import de.maxhenkel.voicechat.voice.common.GroupSoundPacket;
import de.maxhenkel.voicechat.voice.common.KeepAlivePacket;
import de.maxhenkel.voicechat.voice.common.LocationSoundPacket;
import de.maxhenkel.voicechat.voice.common.MicPacket;
import de.maxhenkel.voicechat.voice.common.NetworkMessage;
import de.maxhenkel.voicechat.voice.common.Packet;
import de.maxhenkel.voicechat.voice.common.PingPacket;
import de.maxhenkel.voicechat.voice.common.PlayerSoundPacket;
import de.maxhenkel.voicechat.voice.common.PlayerState;
import de.maxhenkel.voicechat.voice.common.SoundPacket;
import de.maxhenkel.voicechat.voice.server.ClientConnection;
import de.maxhenkel.voicechat.voice.server.GroupManager;
import de.maxhenkel.voicechat.voice.server.PingManager;
import de.maxhenkel.voicechat.voice.server.PlayerStateManager;
import de.maxhenkel.voicechat.voice.server.ServerWorldUtils;
import java.security.InvalidKeyException;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.TimeUnit;
import javax.annotation.Nullable;
import javax.crypto.BadPaddingException;
import javax.crypto.IllegalBlockSizeException;
import javax.crypto.NoSuchPaddingException;
import org.bukkit.GameMode;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Player;

public class Server
extends Thread {
    private final Map<UUID, ClientConnection> connections;
    private final Map<UUID, UUID> secrets;
    private final int port;
    private final org.bukkit.Server server;
    private final VoicechatSocket socket;
    private final ProcessThread processThread;
    private final BlockingQueue<RawUdpPacket> packetQueue;
    private final PingManager pingManager;
    private final PlayerStateManager playerStateManager;
    private final GroupManager groupManager;

    public Server(int port, org.bukkit.Server server) {
        this.port = port;
        this.server = server;
        this.socket = PluginManager.instance().getSocketImplementation(server);
        this.connections = new HashMap<UUID, ClientConnection>();
        this.secrets = new HashMap<UUID, UUID>();
        this.packetQueue = new LinkedBlockingQueue<RawUdpPacket>();
        this.pingManager = new PingManager(this);
        this.playerStateManager = new PlayerStateManager();
        this.groupManager = new GroupManager();
        this.setDaemon(true);
        this.setName("VoiceChatServerThread");
        this.processThread = new ProcessThread();
        this.processThread.start();
    }

    @Override
    public void run() {
        try {
            this.socket.open(this.port, Voicechat.SERVER_CONFIG.voiceChatBindAddress.get());
            Voicechat.LOGGER.info("Server started at port {}", (Object)this.socket.getLocalPort());
            while (!this.socket.isClosed()) {
                try {
                    this.packetQueue.add(this.socket.read());
                }
                catch (Exception exception) {}
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public UUID getSecret(UUID playerUUID) {
        if (this.secrets.containsKey(playerUUID)) {
            return this.secrets.get(playerUUID);
        }
        UUID secret = UUID.randomUUID();
        this.secrets.put(playerUUID, secret);
        return secret;
    }

    public void disconnectClient(UUID playerUUID) {
        this.connections.remove(playerUUID);
        this.secrets.remove(playerUUID);
        PluginManager.instance().onPlayerDisconnected(this.server, playerUUID);
    }

    public void close() {
        this.socket.close();
        this.processThread.close();
        PluginManager.instance().onServerStopped(this.server);
    }

    public boolean isClosed() {
        return !this.processThread.running;
    }

    private void processMicPacket(Player player, PlayerState state, MicPacket packet) throws Exception {
        if (state.hasGroup()) {
            this.processGroupPacket(state, player, packet);
            if (Voicechat.SERVER_CONFIG.openGroups.get().booleanValue()) {
                this.processProximityPacket(state, player, packet);
            }
            return;
        }
        this.processProximityPacket(state, player, packet);
    }

    private void processGroupPacket(PlayerState senderState, Player sender, MicPacket packet) throws Exception {
        ClientGroup group = senderState.getGroup();
        if (group == null) {
            return;
        }
        NetworkMessage soundMessage = new NetworkMessage(new GroupSoundPacket(senderState.getGameProfile().getId(), packet.getData(), packet.getSequenceNumber()));
        for (PlayerState state : this.playerStateManager.getStates()) {
            Player p;
            ClientConnection connection;
            if (!group.equals(state.getGroup())) continue;
            GroupSoundPacket groupSoundPacket = new GroupSoundPacket(senderState.getGameProfile().getId(), packet.getData(), packet.getSequenceNumber());
            if (senderState.getGameProfile().getId().equals(state.getGameProfile().getId()) || (connection = this.connections.get(state.getGameProfile().getId())) == null || (p = this.server.getPlayer(senderState.getGameProfile().getId())) == null || PluginManager.instance().onSoundPacket(sender, senderState, p, state, groupSoundPacket, "group")) continue;
            connection.send(this, soundMessage);
        }
    }

    /*
     * WARNING - void declaration
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void processProximityPacket(PlayerState senderState, Player sender, MicPacket packet) throws Exception {
        void var7_13;
        String source;
        double distance = Voicechat.SERVER_CONFIG.voiceChatDistance.get();
        ClientGroup group = senderState.getGroup();
        if (sender.getGameMode().equals((Object)GameMode.SPECTATOR)) {
            Player spectatingPlayer;
            Entity camera;
            if (Voicechat.SERVER_CONFIG.spectatorPlayerPossession.get().booleanValue() && (camera = sender.getSpectatorTarget()) instanceof Player && (spectatingPlayer = (Player)camera) != sender) {
                PlayerState receiverState = this.playerStateManager.getState(spectatingPlayer.getUniqueId());
                ClientConnection connection = this.connections.get(receiverState.getGameProfile().getId());
                if (connection == null) {
                    return;
                }
                GroupSoundPacket groupSoundPacket = new GroupSoundPacket(senderState.getGameProfile().getId(), packet.getData(), packet.getSequenceNumber());
                if (PluginManager.instance().onSoundPacket(sender, senderState, spectatingPlayer, receiverState, groupSoundPacket, "spectator")) return;
                connection.send(this, new NetworkMessage(groupSoundPacket));
                return;
            }
            if (!Voicechat.SERVER_CONFIG.spectatorInteraction.get().booleanValue()) return;
            LocationSoundPacket locationSoundPacket = new LocationSoundPacket(sender.getUniqueId(), sender.getLocation(), packet.getData(), packet.getSequenceNumber());
            source = "spectator";
        } else {
            PlayerSoundPacket playerSoundPacket = new PlayerSoundPacket(sender.getUniqueId(), packet.getData(), packet.getSequenceNumber(), packet.isWhispering());
            source = "proximity";
        }
        this.broadcast(ServerWorldUtils.getPlayersInRange(sender.getWorld(), sender.getLocation(), distance, p -> !p.getUniqueId().equals(sender.getUniqueId())), (SoundPacket<?>)var7_13, sender, senderState, group, source);
    }

    public void broadcast(Collection<Player> players, SoundPacket<?> packet, @Nullable Player sender, @Nullable PlayerState senderState, @Nullable ClientGroup group, String source) {
        for (Player player : players) {
            ClientConnection connection;
            PlayerState state = this.playerStateManager.getState(player.getUniqueId());
            if (state == null || state.isDisabled() || state.isDisconnected() || state.hasGroup() && state.getGroup().equals(group) || (connection = this.connections.get(state.getGameProfile().getId())) == null) continue;
            try {
                if (PluginManager.instance().onSoundPacket(sender, senderState, player, state, packet, source)) continue;
                connection.send(this, new NetworkMessage(packet));
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    private void sendKeepAlives() throws Exception {
        long timestamp = System.currentTimeMillis();
        this.connections.values().removeIf(connection -> {
            if (timestamp - connection.getLastKeepAliveResponse() >= (long)Voicechat.SERVER_CONFIG.keepAlive.get().intValue() * 10L) {
                this.secrets.remove(connection.getPlayerUUID());
                Voicechat.LOGGER.info("Player {} timed out", (Object)connection.getPlayerUUID());
                Player player = this.server.getPlayer(connection.getPlayerUUID());
                if (player != null) {
                    Voicechat.LOGGER.info("Reconnecting player {}", (Object)player.getName());
                    Voicechat.SERVER.initializePlayerConnection(player);
                } else {
                    Voicechat.LOGGER.error("Reconnecting player {} failed (Could not find player)", (Object)connection.getPlayerUUID());
                }
                PluginManager.instance().onPlayerDisconnected(this.server, connection.getPlayerUUID());
                return true;
            }
            return false;
        });
        for (ClientConnection connection2 : this.connections.values()) {
            this.sendPacket(new KeepAlivePacket(), connection2);
        }
    }

    public Map<UUID, ClientConnection> getConnections() {
        return this.connections;
    }

    public VoicechatSocket getSocket() {
        return this.socket;
    }

    public void sendPacket(Packet<?> packet, ClientConnection connection) throws Exception {
        connection.send(this, new NetworkMessage(packet));
    }

    public PingManager getPingManager() {
        return this.pingManager;
    }

    public PlayerStateManager getPlayerStateManager() {
        return this.playerStateManager;
    }

    public GroupManager getGroupManager() {
        return this.groupManager;
    }

    private class ProcessThread
    extends Thread {
        private boolean running = true;
        private long lastKeepAlive = 0L;

        public ProcessThread() {
            this.setDaemon(true);
            this.setName("VoiceChatPacketProcessingThread");
        }

        @Override
        public void run() {
            while (this.running) {
                try {
                    UUID playerUUID;
                    AuthenticatePacket packet;
                    UUID secret;
                    NetworkMessage message;
                    RawUdpPacket rawPacket;
                    Server.this.pingManager.checkTimeouts();
                    long keepAliveTime = System.currentTimeMillis();
                    if (keepAliveTime - this.lastKeepAlive > (long)Voicechat.SERVER_CONFIG.keepAlive.get().intValue()) {
                        Server.this.sendKeepAlives();
                        this.lastKeepAlive = keepAliveTime;
                    }
                    if ((rawPacket = Server.this.packetQueue.poll(10L, TimeUnit.MILLISECONDS)) == null) continue;
                    try {
                        message = NetworkMessage.readPacketServer(rawPacket, Server.this);
                    }
                    catch (IndexOutOfBoundsException | InvalidKeyException | BadPaddingException | IllegalBlockSizeException | NoSuchPaddingException e) {
                        CooldownTimer.run("failed_reading_packet", () -> Voicechat.LOGGER.warn("Failed to read packet from {}", (Object)rawPacket.getSocketAddress()));
                        continue;
                    }
                    if (System.currentTimeMillis() - message.getTimestamp() > message.getTTL()) {
                        CooldownTimer.run("ttl", () -> {
                            Voicechat.LOGGER.error("Dropping voice chat packets! Your Server might be overloaded!");
                            Voicechat.LOGGER.error("Packet queue has {} packets", (Object)Server.this.packetQueue.size());
                        });
                        continue;
                    }
                    Packet<? extends Packet> packet2 = message.getPacket();
                    if (packet2 instanceof AuthenticatePacket && (secret = Server.this.secrets.get((packet = (AuthenticatePacket)packet2).getPlayerUUID())) != null && secret.equals(packet.getSecret())) {
                        ClientConnection connection;
                        if (!Server.this.connections.containsKey(packet.getPlayerUUID())) {
                            connection = new ClientConnection(packet.getPlayerUUID(), message.getAddress());
                            Server.this.connections.put(packet.getPlayerUUID(), connection);
                            Voicechat.LOGGER.info("Successfully authenticated player {}", (Object)packet.getPlayerUUID());
                            PluginManager.instance().onPlayerConnected(Server.this.server.getPlayer(packet.getPlayerUUID()));
                        } else {
                            connection = Server.this.connections.get(packet.getPlayerUUID());
                        }
                        Server.this.sendPacket(new AuthenticateAckPacket(), connection);
                    }
                    if ((playerUUID = message.getSender(Server.this)) == null) continue;
                    ClientConnection conn = Server.this.connections.get(playerUUID);
                    Packet<? extends Packet> packet3 = message.getPacket();
                    if (packet3 instanceof MicPacket) {
                        MicPacket packet4 = (MicPacket)packet3;
                        Player player = Server.this.server.getPlayer(playerUUID);
                        if (player == null) continue;
                        if (!player.hasPermission(VoiceChatCommands.SPEAK_PERMISSION)) {
                            CooldownTimer.run("muted-" + playerUUID, () -> player.sendMessage(Voicechat.translate("no_speak_permission")));
                            continue;
                        }
                        PlayerState state = Server.this.playerStateManager.getState(player.getUniqueId());
                        if (state == null || PluginManager.instance().onMicPacket(player, state, packet4)) continue;
                        Server.this.processMicPacket(player, state, packet4);
                        continue;
                    }
                    packet3 = message.getPacket();
                    if (packet3 instanceof PingPacket) {
                        PingPacket packet5 = (PingPacket)packet3;
                        Server.this.pingManager.onPongPacket(packet5);
                        continue;
                    }
                    if (!(message.getPacket() instanceof KeepAlivePacket)) continue;
                    conn.setLastKeepAliveResponse(System.currentTimeMillis());
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        }

        public void close() {
            this.running = false;
        }
    }
}

