/*
 * Decompiled with CFR 0.152.
 */
package de.maxhenkel.voicechat.voice.server;

import de.maxhenkel.voicechat.Voicechat;
import de.maxhenkel.voicechat.net.NetManager;
import de.maxhenkel.voicechat.net.PlayerStatePacket;
import de.maxhenkel.voicechat.net.PlayerStatesPacket;
import de.maxhenkel.voicechat.voice.common.ClientGroup;
import de.maxhenkel.voicechat.voice.common.PlayerState;
import java.util.Collection;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import javax.annotation.Nullable;
import org.bukkit.craftbukkit.v1_18_R1.entity.CraftPlayer;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.player.PlayerQuitEvent;

public class PlayerStateManager
implements Listener {
    private final ConcurrentHashMap<UUID, PlayerState> states = new ConcurrentHashMap();

    public void onPlayerStatePacket(Player player, PlayerStatePacket packet) {
        PlayerState oldState = this.states.get(player.getUniqueId());
        PlayerState state = packet.getPlayerState();
        state.setGameProfile(((CraftPlayer)player).getProfile());
        if (oldState != null) {
            state.setGroup(oldState.getGroup());
        } else {
            state.setGroup(null);
        }
        this.states.put(player.getUniqueId(), state);
        this.broadcastState(state);
    }

    @EventHandler
    public void onPlayerQuit(PlayerQuitEvent event) {
        this.removePlayer(event.getPlayer());
    }

    private void broadcastState(PlayerState state) {
        PlayerStatePacket packet = new PlayerStatePacket(state);
        Voicechat.INSTANCE.getServer().getOnlinePlayers().forEach(p -> NetManager.sendToClient(p, packet));
    }

    public void onPlayerCompatibilityCheckSucceded(Player player) {
        PlayerState state = this.states.getOrDefault(player.getUniqueId(), PlayerStateManager.defaultDisconnectedState(player));
        this.states.put(player.getUniqueId(), state);
        PlayerStatesPacket packet = new PlayerStatesPacket(this.states);
        NetManager.sendToClient(player, packet);
    }

    private void removePlayer(Player player) {
        this.states.remove(player.getUniqueId());
        this.broadcastState(new PlayerState(true, true, ((CraftPlayer)player).getProfile()));
    }

    @Nullable
    public PlayerState getState(UUID playerUUID) {
        return this.states.get(playerUUID);
    }

    public static PlayerState defaultDisconnectedState(Player player) {
        return new PlayerState(false, true, ((CraftPlayer)player).getProfile());
    }

    public void setGroup(Player player, @Nullable ClientGroup group) {
        PlayerState state = this.states.get(player.getUniqueId());
        if (state == null) {
            state = PlayerStateManager.defaultDisconnectedState(player);
        }
        state.setGroup(group);
        this.states.put(player.getUniqueId(), state);
        this.broadcastState(state);
    }

    public Collection<PlayerState> getStates() {
        return this.states.values();
    }
}

