/*
 * Decompiled with CFR 0.152.
 */
package de.maxhenkel.voicechat.voice.server;

import de.maxhenkel.voicechat.Voicechat;
import de.maxhenkel.voicechat.net.CreateGroupPacket;
import de.maxhenkel.voicechat.net.JoinGroupPacket;
import de.maxhenkel.voicechat.net.JoinedGroupPacket;
import de.maxhenkel.voicechat.net.LeaveGroupPacket;
import de.maxhenkel.voicechat.net.NetManager;
import de.maxhenkel.voicechat.plugins.PluginManager;
import de.maxhenkel.voicechat.voice.common.PlayerState;
import de.maxhenkel.voicechat.voice.server.Group;
import de.maxhenkel.voicechat.voice.server.PlayerStateManager;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import org.bukkit.entity.Player;

public class GroupManager {
    private final Map<UUID, Group> groups = new ConcurrentHashMap<UUID, Group>();

    public void onJoinGroupPacket(Player player, JoinGroupPacket packet) {
        if (!Voicechat.SERVER_CONFIG.groupsEnabled.get().booleanValue()) {
            return;
        }
        this.joinGroup(this.groups.get(packet.getGroup()), player, packet.getPassword());
    }

    public void onCreateGroupPacket(Player player, CreateGroupPacket packet) {
        if (!Voicechat.SERVER_CONFIG.groupsEnabled.get().booleanValue()) {
            return;
        }
        Group group = new Group(UUID.randomUUID(), packet.getName(), packet.getPassword());
        this.addGroup(group, player);
    }

    public void onLeaveGroupPacket(Player player, LeaveGroupPacket packet) {
        this.leaveGroup(player);
    }

    private PlayerStateManager getStates() {
        return Voicechat.SERVER.getServer().getPlayerStateManager();
    }

    public void addGroup(Group group, Player player) {
        if (PluginManager.instance().onCreateGroup(player, group)) {
            return;
        }
        this.groups.put(group.getId(), group);
        PlayerStateManager manager = this.getStates();
        manager.setGroup(player, group.toClientGroup());
        NetManager.sendToClient(player, new JoinedGroupPacket(group.toClientGroup()));
    }

    public void joinGroup(@Nullable Group group, Player player, String password) {
        if (PluginManager.instance().onJoinGroup(player, group)) {
            return;
        }
        if (group == null) {
            NetManager.sendToClient(player, new JoinedGroupPacket(null));
            return;
        }
        if (group.getPassword() != null && !group.getPassword().equals(password)) {
            NetManager.sendToClient(player, new JoinedGroupPacket(null));
            return;
        }
        PlayerStateManager manager = this.getStates();
        manager.setGroup(player, group.toClientGroup());
        NetManager.sendToClient(player, new JoinedGroupPacket(group.toClientGroup()));
    }

    public void leaveGroup(Player player) {
        if (PluginManager.instance().onLeaveGroup(player)) {
            return;
        }
        PlayerStateManager manager = this.getStates();
        manager.setGroup(player, null);
        this.cleanEmptyGroups();
    }

    public void cleanEmptyGroups() {
        PlayerStateManager manager = this.getStates();
        List usedGroups = manager.getStates().stream().filter(PlayerState::hasGroup).map(state -> state.getGroup().getId()).distinct().collect(Collectors.toList());
        List groupsToRemove = this.groups.keySet().stream().filter(uuid -> !usedGroups.contains(uuid)).collect(Collectors.toList());
        for (UUID uuid2 : groupsToRemove) {
            this.groups.remove(uuid2);
        }
    }

    @Nullable
    public Group getGroup(UUID groupID) {
        return this.groups.get(groupID);
    }
}

