/*
 * Decompiled with CFR 0.152.
 */
package de.maxhenkel.voicechat.voice.common;

import com.mojang.authlib.GameProfile;
import de.maxhenkel.voicechat.util.FriendlyByteBuf;
import de.maxhenkel.voicechat.voice.common.ClientGroup;
import javax.annotation.Nullable;

public class PlayerState {
    private boolean disabled;
    private boolean disconnected;
    private GameProfile gameProfile;
    @Nullable
    private ClientGroup group;

    public PlayerState(boolean disabled, boolean disconnected, GameProfile gameProfile) {
        this.disabled = disabled;
        this.disconnected = disconnected;
        this.gameProfile = gameProfile;
    }

    public boolean isDisabled() {
        return this.disabled;
    }

    public void setDisabled(boolean disabled) {
        this.disabled = disabled;
    }

    public boolean isDisconnected() {
        return this.disconnected;
    }

    public void setDisconnected(boolean disconnected) {
        this.disconnected = disconnected;
    }

    public GameProfile getGameProfile() {
        return this.gameProfile;
    }

    public void setGameProfile(GameProfile gameProfile) {
        this.gameProfile = gameProfile;
    }

    @Nullable
    public ClientGroup getGroup() {
        return this.group;
    }

    public void setGroup(@Nullable ClientGroup group) {
        this.group = group;
    }

    public boolean hasGroup() {
        return this.group != null;
    }

    public String toString() {
        return "{disabled=" + this.disabled + ", disconnected=" + this.disconnected + ", uuid=" + this.gameProfile.getId() + ", group=" + this.group + "}";
    }

    public static PlayerState fromBytes(FriendlyByteBuf buf) {
        PlayerState state = new PlayerState(buf.readBoolean(), buf.readBoolean(), new GameProfile(buf.readUUID(), buf.readUtf()));
        if (buf.readBoolean()) {
            state.setGroup(ClientGroup.fromBytes(buf));
        }
        return state;
    }

    public void toBytes(FriendlyByteBuf buf) {
        buf.writeBoolean(this.disabled);
        buf.writeBoolean(this.disconnected);
        buf.writeUUID(this.gameProfile.getId());
        buf.writeUtf(this.gameProfile.getName());
        buf.writeBoolean(this.hasGroup());
        if (this.hasGroup()) {
            this.group.toBytes(buf);
        }
    }
}

