/*
 * Decompiled with CFR 0.152.
 */
package de.maxhenkel.voicechat.voice.common;

import de.maxhenkel.voicechat.util.FriendlyByteBuf;
import java.util.UUID;

public class ClientGroup {
    private final UUID id;
    private final String name;
    private final boolean hasPassword;

    public ClientGroup(UUID id, String name, boolean hasPassword) {
        this.id = id;
        this.name = name;
        this.hasPassword = hasPassword;
    }

    public UUID getId() {
        return this.id;
    }

    public String getName() {
        return this.name;
    }

    public boolean hasPassword() {
        return this.hasPassword;
    }

    public static ClientGroup fromBytes(FriendlyByteBuf buf) {
        return new ClientGroup(buf.readUUID(), buf.readUtf(512), buf.readBoolean());
    }

    public void toBytes(FriendlyByteBuf buf) {
        buf.writeUUID(this.id);
        buf.writeUtf(this.name, 512);
        buf.writeBoolean(this.hasPassword);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ClientGroup group = (ClientGroup)o;
        return this.id != null ? this.id.equals(group.id) : group.id == null;
    }
}

