/*
 * Decompiled with CFR 0.152.
 */
package de.maxhenkel.voicechat.plugins.impl;

import de.maxhenkel.voicechat.Voicechat;
import de.maxhenkel.voicechat.api.Entity;
import de.maxhenkel.voicechat.api.Position;
import de.maxhenkel.voicechat.api.ServerLevel;
import de.maxhenkel.voicechat.api.ServerPlayer;
import de.maxhenkel.voicechat.api.VoicechatConnection;
import de.maxhenkel.voicechat.api.VoicechatServerApi;
import de.maxhenkel.voicechat.api.audiochannel.AudioChannel;
import de.maxhenkel.voicechat.api.audiochannel.AudioPlayer;
import de.maxhenkel.voicechat.api.audiochannel.EntityAudioChannel;
import de.maxhenkel.voicechat.api.audiochannel.LocationalAudioChannel;
import de.maxhenkel.voicechat.api.audiochannel.StaticAudioChannel;
import de.maxhenkel.voicechat.api.opus.OpusEncoder;
import de.maxhenkel.voicechat.api.packets.EntitySoundPacket;
import de.maxhenkel.voicechat.api.packets.LocationalSoundPacket;
import de.maxhenkel.voicechat.api.packets.StaticSoundPacket;
import de.maxhenkel.voicechat.plugins.PluginManager;
import de.maxhenkel.voicechat.plugins.impl.GroupImpl;
import de.maxhenkel.voicechat.plugins.impl.PositionImpl;
import de.maxhenkel.voicechat.plugins.impl.ServerPlayerImpl;
import de.maxhenkel.voicechat.plugins.impl.VoicechatApiImpl;
import de.maxhenkel.voicechat.plugins.impl.VoicechatConnectionImpl;
import de.maxhenkel.voicechat.plugins.impl.audiochannel.AudioPlayerImpl;
import de.maxhenkel.voicechat.plugins.impl.audiochannel.AudioSupplier;
import de.maxhenkel.voicechat.plugins.impl.audiochannel.EntityAudioChannelImpl;
import de.maxhenkel.voicechat.plugins.impl.audiochannel.LocationalAudioChannelImpl;
import de.maxhenkel.voicechat.plugins.impl.audiochannel.StaticAudioChannelImpl;
import de.maxhenkel.voicechat.plugins.impl.packets.EntitySoundPacketImpl;
import de.maxhenkel.voicechat.plugins.impl.packets.LocationalSoundPacketImpl;
import de.maxhenkel.voicechat.plugins.impl.packets.StaticSoundPacketImpl;
import de.maxhenkel.voicechat.voice.common.NetworkMessage;
import de.maxhenkel.voicechat.voice.common.PlayerState;
import de.maxhenkel.voicechat.voice.common.SoundPacket;
import de.maxhenkel.voicechat.voice.server.ClientConnection;
import de.maxhenkel.voicechat.voice.server.Group;
import de.maxhenkel.voicechat.voice.server.Server;
import de.maxhenkel.voicechat.voice.server.ServerWorldUtils;
import java.util.Collection;
import java.util.UUID;
import java.util.function.Predicate;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import org.bukkit.World;
import org.bukkit.entity.Player;

public class VoicechatServerApiImpl
extends VoicechatApiImpl
implements VoicechatServerApi {
    private final org.bukkit.Server server;

    public VoicechatServerApiImpl(org.bukkit.Server server) {
        this.server = server;
    }

    @Override
    public void sendEntitySoundPacketTo(VoicechatConnection connection, EntitySoundPacket p) {
        if (p instanceof EntitySoundPacketImpl) {
            EntitySoundPacketImpl packet = (EntitySoundPacketImpl)p;
            VoicechatServerApiImpl.sendPacket(connection, packet.getPacket());
        }
    }

    @Override
    public void sendLocationalSoundPacketTo(VoicechatConnection connection, LocationalSoundPacket p) {
        if (p instanceof LocationalSoundPacketImpl) {
            LocationalSoundPacketImpl packet = (LocationalSoundPacketImpl)p;
            VoicechatServerApiImpl.sendPacket(connection, packet.getPacket());
        }
    }

    @Override
    public void sendStaticSoundPacketTo(VoicechatConnection connection, StaticSoundPacket p) {
        if (p instanceof StaticSoundPacketImpl) {
            StaticSoundPacketImpl packet = (StaticSoundPacketImpl)p;
            VoicechatServerApiImpl.sendPacket(connection, packet.getPacket());
        }
    }

    @Override
    @Nullable
    public EntityAudioChannel createEntityAudioChannel(UUID channelId, Entity entity) {
        Server server = Voicechat.SERVER.getServer();
        if (server == null) {
            return null;
        }
        return new EntityAudioChannelImpl(channelId, server, entity);
    }

    @Override
    @Nullable
    public LocationalAudioChannel createLocationalAudioChannel(UUID channelId, ServerLevel level, Position initialPosition) {
        Server server = Voicechat.SERVER.getServer();
        if (server == null) {
            return null;
        }
        if (initialPosition instanceof PositionImpl) {
            PositionImpl p = (PositionImpl)initialPosition;
            return new LocationalAudioChannelImpl(channelId, server, level, p);
        }
        throw new IllegalArgumentException("initialPosition is not an instance of PositionImpl");
    }

    @Override
    @Nullable
    public StaticAudioChannel createStaticAudioChannel(UUID channelId, ServerLevel level, VoicechatConnection connection) {
        Server server = Voicechat.SERVER.getServer();
        if (server == null) {
            return null;
        }
        if (connection instanceof VoicechatConnectionImpl) {
            VoicechatConnectionImpl conn = (VoicechatConnectionImpl)connection;
            return new StaticAudioChannelImpl(channelId, server, conn);
        }
        return null;
    }

    @Override
    public AudioPlayer createAudioPlayer(AudioChannel audioChannel, OpusEncoder encoder, Supplier<short[]> audioSupplier) {
        return new AudioPlayerImpl(audioChannel, encoder, audioSupplier);
    }

    @Override
    public AudioPlayer createAudioPlayer(AudioChannel audioChannel, OpusEncoder encoder, short[] audio) {
        return new AudioPlayerImpl(audioChannel, encoder, new AudioSupplier(audio));
    }

    public static void sendPacket(VoicechatConnection receiver, SoundPacket<?> s) {
        Server server = Voicechat.SERVER.getServer();
        if (server == null) {
            return;
        }
        PlayerState state = server.getPlayerStateManager().getState(receiver.getPlayer().getUuid());
        if (state == null) {
            return;
        }
        if (PluginManager.instance().onSoundPacket(null, null, (Player)receiver.getPlayer().getPlayer(), state, s, "plugin")) {
            return;
        }
        ClientConnection c = server.getConnections().get(receiver.getPlayer().getUuid());
        try {
            c.send(server, new NetworkMessage(s));
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    @Override
    @Nullable
    public VoicechatConnection getConnectionOf(UUID playerUuid) {
        Player player = this.server.getPlayer(playerUuid);
        if (player == null) {
            return null;
        }
        return VoicechatConnectionImpl.fromPlayer(player);
    }

    @Override
    public de.maxhenkel.voicechat.api.Group createGroup(String name, @Nullable String password) {
        return new GroupImpl(new Group(UUID.randomUUID(), name, password));
    }

    @Override
    @Nullable
    public UUID getSecret(UUID userId) {
        Server server = Voicechat.SERVER.getServer();
        if (server == null) {
            return null;
        }
        return server.getSecret(userId);
    }

    @Override
    public Collection<ServerPlayer> getPlayersInRange(ServerLevel level, Position pos, double range, Predicate<ServerPlayer> filter) {
        if (pos instanceof PositionImpl) {
            PositionImpl p = (PositionImpl)pos;
            return ServerWorldUtils.getPlayersInRange((World)level.getServerLevel(), p.getPosition(), range, player -> filter.test(new ServerPlayerImpl((Player)player))).stream().map(ServerPlayerImpl::new).collect(Collectors.toList());
        }
        throw new IllegalArgumentException("Position is not an instance of PositionImpl");
    }

    @Override
    public double getBroadcastRange() {
        return Voicechat.SERVER_CONFIG.voiceChatDistance.get();
    }
}

