/*
 * Decompiled with CFR 0.152.
 */
package de.maxhenkel.voicechat.plugins;

import de.maxhenkel.voicechat.Voicechat;
import de.maxhenkel.voicechat.api.VoicechatConnection;
import de.maxhenkel.voicechat.api.VoicechatPlugin;
import de.maxhenkel.voicechat.api.VoicechatServerApi;
import de.maxhenkel.voicechat.api.VoicechatSocket;
import de.maxhenkel.voicechat.api.events.CreateGroupEvent;
import de.maxhenkel.voicechat.api.events.EntitySoundPacketEvent;
import de.maxhenkel.voicechat.api.events.Event;
import de.maxhenkel.voicechat.api.events.EventRegistration;
import de.maxhenkel.voicechat.api.events.JoinGroupEvent;
import de.maxhenkel.voicechat.api.events.LeaveGroupEvent;
import de.maxhenkel.voicechat.api.events.LocationalSoundPacketEvent;
import de.maxhenkel.voicechat.api.events.MicrophonePacketEvent;
import de.maxhenkel.voicechat.api.events.PlayerConnectedEvent;
import de.maxhenkel.voicechat.api.events.PlayerDisconnectedEvent;
import de.maxhenkel.voicechat.api.events.StaticSoundPacketEvent;
import de.maxhenkel.voicechat.api.events.VoiceHostEvent;
import de.maxhenkel.voicechat.api.events.VoicechatServerStartedEvent;
import de.maxhenkel.voicechat.api.events.VoicechatServerStartingEvent;
import de.maxhenkel.voicechat.api.events.VoicechatServerStoppedEvent;
import de.maxhenkel.voicechat.plugins.EventBuilder;
import de.maxhenkel.voicechat.plugins.impl.GroupImpl;
import de.maxhenkel.voicechat.plugins.impl.VoicechatApiImpl;
import de.maxhenkel.voicechat.plugins.impl.VoicechatConnectionImpl;
import de.maxhenkel.voicechat.plugins.impl.VoicechatServerApiImpl;
import de.maxhenkel.voicechat.plugins.impl.VoicechatSocketImpl;
import de.maxhenkel.voicechat.plugins.impl.events.CreateGroupEventImpl;
import de.maxhenkel.voicechat.plugins.impl.events.EntitySoundPacketEventImpl;
import de.maxhenkel.voicechat.plugins.impl.events.JoinGroupEventImpl;
import de.maxhenkel.voicechat.plugins.impl.events.LeaveGroupEventImpl;
import de.maxhenkel.voicechat.plugins.impl.events.LocationalSoundPacketEventImpl;
import de.maxhenkel.voicechat.plugins.impl.events.MicrophonePacketEventImpl;
import de.maxhenkel.voicechat.plugins.impl.events.PlayerConnectedEventImpl;
import de.maxhenkel.voicechat.plugins.impl.events.PlayerDisconnectedEventImpl;
import de.maxhenkel.voicechat.plugins.impl.events.StaticSoundPacketEventImpl;
import de.maxhenkel.voicechat.plugins.impl.events.VoiceHostEventImpl;
import de.maxhenkel.voicechat.plugins.impl.events.VoicechatServerStartedEventImpl;
import de.maxhenkel.voicechat.plugins.impl.events.VoicechatServerStartingEventImpl;
import de.maxhenkel.voicechat.plugins.impl.events.VoicechatServerStoppedEventImpl;
import de.maxhenkel.voicechat.plugins.impl.packets.EntitySoundPacketImpl;
import de.maxhenkel.voicechat.plugins.impl.packets.LocationalSoundPacketImpl;
import de.maxhenkel.voicechat.plugins.impl.packets.MicrophonePacketImpl;
import de.maxhenkel.voicechat.plugins.impl.packets.StaticSoundPacketImpl;
import de.maxhenkel.voicechat.voice.common.GroupSoundPacket;
import de.maxhenkel.voicechat.voice.common.LocationSoundPacket;
import de.maxhenkel.voicechat.voice.common.MicPacket;
import de.maxhenkel.voicechat.voice.common.PlayerSoundPacket;
import de.maxhenkel.voicechat.voice.common.PlayerState;
import de.maxhenkel.voicechat.voice.common.SoundPacket;
import de.maxhenkel.voicechat.voice.server.Group;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.function.Consumer;
import javax.annotation.Nullable;
import org.bukkit.Server;
import org.bukkit.entity.Player;
import org.bukkit.plugin.Plugin;

public class PluginManager {
    private List<VoicechatPlugin> plugins;
    private Map<Class<? extends Event>, List<Consumer<? extends Event>>> events;
    private static PluginManager instance;

    public void init(Plugin p) {
        Voicechat.LOGGER.info("Loading plugins");
        this.plugins = Voicechat.apiService.getPlugins();
        Voicechat.LOGGER.info("Loaded {} plugin(s)", (Object)this.plugins.size());
        Voicechat.LOGGER.info("Initializing plugins");
        for (VoicechatPlugin plugin : this.plugins) {
            try {
                plugin.initialize(new VoicechatApiImpl());
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        Voicechat.LOGGER.info("Initialized {} plugin(s)", (Object)this.plugins.size());
        this.gatherEvents();
    }

    private void gatherEvents() {
        EventBuilder eventBuilder = EventBuilder.create();
        EventRegistration registration = eventBuilder::addEvent;
        for (VoicechatPlugin plugin : this.plugins) {
            Voicechat.LOGGER.info("Registering events for {}", (Object)plugin.getPluginId());
            try {
                plugin.registerEvents(registration);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        this.events = eventBuilder.build();
    }

    public <T extends Event> boolean dispatchEvent(Class<T> eventClass, T event) {
        List<Consumer<? extends Event>> events = this.events.get(eventClass);
        if (events == null) {
            return false;
        }
        for (Consumer<? extends Event> evt : events) {
            try {
                Consumer<? extends Event> e = evt;
                e.accept(event);
                if (!event.isCancelled()) continue;
                break;
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return event.isCancelled();
    }

    public VoicechatSocket getSocketImplementation(Server server) {
        VoicechatServerStartingEventImpl event = new VoicechatServerStartingEventImpl(new VoicechatServerApiImpl(server));
        this.dispatchEvent(VoicechatServerStartingEvent.class, event);
        VoicechatSocket socket = event.getSocketImplementation();
        if (socket == null) {
            socket = new VoicechatSocketImpl();
            Voicechat.LOGGER.info("Using default voicechat socket implementation");
        } else {
            Voicechat.LOGGER.info("Using custom voicechat socket implementation: {}", (Object)socket.getClass().getName());
        }
        return socket;
    }

    public String getVoiceHost(Player player, String voiceHost) {
        VoiceHostEventImpl event = new VoiceHostEventImpl(new VoicechatServerApiImpl(player.getServer()), voiceHost);
        this.dispatchEvent(VoiceHostEvent.class, event);
        return event.getVoiceHost();
    }

    public void onServerStarted(Server server) {
        this.dispatchEvent(VoicechatServerStartedEvent.class, new VoicechatServerStartedEventImpl(new VoicechatServerApiImpl(server)));
    }

    public void onServerStopped(Server server) {
        this.dispatchEvent(VoicechatServerStoppedEvent.class, new VoicechatServerStoppedEventImpl(new VoicechatServerApiImpl(server)));
    }

    public void onPlayerConnected(@Nullable Player player) {
        if (player == null) {
            return;
        }
        this.dispatchEvent(PlayerConnectedEvent.class, new PlayerConnectedEventImpl(new VoicechatServerApiImpl(player.getServer()), VoicechatConnectionImpl.fromPlayer(player)));
    }

    public void onPlayerDisconnected(Server server, UUID player) {
        this.dispatchEvent(PlayerDisconnectedEvent.class, new PlayerDisconnectedEventImpl(new VoicechatServerApiImpl(server), player));
    }

    public boolean onJoinGroup(Player player, @Nullable Group group) {
        if (group == null) {
            return this.onLeaveGroup(player);
        }
        return this.dispatchEvent(JoinGroupEvent.class, new JoinGroupEventImpl(new VoicechatServerApiImpl(player.getServer()), new GroupImpl(group), VoicechatConnectionImpl.fromPlayer(player)));
    }

    public boolean onCreateGroup(Player player, Group group) {
        if (group == null) {
            return this.onLeaveGroup(player);
        }
        return this.dispatchEvent(CreateGroupEvent.class, new CreateGroupEventImpl(new VoicechatServerApiImpl(player.getServer()), new GroupImpl(group), VoicechatConnectionImpl.fromPlayer(player)));
    }

    public boolean onLeaveGroup(Player player) {
        return this.dispatchEvent(LeaveGroupEvent.class, new LeaveGroupEventImpl(new VoicechatServerApiImpl(player.getServer()), null, VoicechatConnectionImpl.fromPlayer(player)));
    }

    public boolean onMicPacket(Player player, PlayerState state, MicPacket packet) {
        return this.dispatchEvent(MicrophonePacketEvent.class, new MicrophonePacketEventImpl(new VoicechatServerApiImpl(player.getServer()), new MicrophonePacketImpl(packet, player.getUniqueId()), new VoicechatConnectionImpl(player, state)));
    }

    public boolean onSoundPacket(@Nullable Player sender, @Nullable PlayerState senderState, Player receiver, PlayerState receiverState, SoundPacket<?> p, String source) {
        VoicechatServerApiImpl api = new VoicechatServerApiImpl(receiver.getServer());
        VoicechatConnectionImpl senderConnection = null;
        if (sender != null && senderState != null) {
            senderConnection = new VoicechatConnectionImpl(sender, senderState);
        }
        VoicechatConnectionImpl receiverConnection = new VoicechatConnectionImpl(receiver, receiverState);
        if (p instanceof LocationSoundPacket) {
            LocationSoundPacket packet = (LocationSoundPacket)p;
            return this.dispatchEvent(LocationalSoundPacketEvent.class, new LocationalSoundPacketEventImpl((VoicechatServerApi)api, new LocationalSoundPacketImpl(packet), (VoicechatConnection)senderConnection, (VoicechatConnection)receiverConnection, source));
        }
        if (p instanceof PlayerSoundPacket) {
            PlayerSoundPacket packet = (PlayerSoundPacket)p;
            return this.dispatchEvent(EntitySoundPacketEvent.class, new EntitySoundPacketEventImpl((VoicechatServerApi)api, new EntitySoundPacketImpl(packet), (VoicechatConnection)senderConnection, (VoicechatConnection)receiverConnection, source));
        }
        if (p instanceof GroupSoundPacket) {
            GroupSoundPacket packet = (GroupSoundPacket)p;
            return this.dispatchEvent(StaticSoundPacketEvent.class, new StaticSoundPacketEventImpl((VoicechatServerApi)api, new StaticSoundPacketImpl(packet), (VoicechatConnection)senderConnection, (VoicechatConnection)receiverConnection, source));
        }
        return false;
    }

    public static PluginManager instance() {
        if (instance == null) {
            instance = new PluginManager();
        }
        return instance;
    }
}

