/*
 * Decompiled with CFR 0.152.
 */
package de.maxhenkel.voicechat.net;

import de.maxhenkel.voicechat.config.ServerConfig;
import de.maxhenkel.voicechat.net.Packet;
import de.maxhenkel.voicechat.plugins.PluginManager;
import de.maxhenkel.voicechat.util.FriendlyByteBuf;
import de.maxhenkel.voicechat.util.ResourceLocation;
import java.util.UUID;
import org.bukkit.entity.Player;

public class SecretPacket
implements Packet<SecretPacket> {
    public static final ResourceLocation SECRET = new ResourceLocation("voicechat", "secret");
    private UUID secret;
    private int serverPort;
    private ServerConfig.Codec codec;
    private int mtuSize;
    private double voiceChatDistance;
    private double voiceChatFadeDistance;
    private double crouchDistanceMultiplier;
    private double whisperDistanceMultiplier;
    private int keepAlive;
    private boolean groupsEnabled;
    private String voiceHost;
    private boolean allowRecording;

    public SecretPacket() {
    }

    public SecretPacket(Player player, UUID secret, boolean hasGroupPermission, ServerConfig serverConfig) {
        this.secret = secret;
        this.serverPort = serverConfig.voiceChatPort.get();
        this.codec = serverConfig.voiceChatCodec.get();
        this.mtuSize = serverConfig.voiceChatMtuSize.get();
        this.voiceChatDistance = serverConfig.voiceChatDistance.get();
        this.voiceChatFadeDistance = serverConfig.voiceChatFadeDistance.get();
        this.crouchDistanceMultiplier = serverConfig.crouchDistanceMultiplier.get();
        this.whisperDistanceMultiplier = serverConfig.whisperDistanceMultiplier.get();
        this.keepAlive = serverConfig.keepAlive.get();
        this.groupsEnabled = hasGroupPermission && serverConfig.groupsEnabled.get() != false;
        this.voiceHost = PluginManager.instance().getVoiceHost(player, serverConfig.voiceHost.get());
        this.allowRecording = serverConfig.allowRecording.get();
    }

    public UUID getSecret() {
        return this.secret;
    }

    public int getServerPort() {
        return this.serverPort;
    }

    public ServerConfig.Codec getCodec() {
        return this.codec;
    }

    public int getMtuSize() {
        return this.mtuSize;
    }

    public double getVoiceChatDistance() {
        return this.voiceChatDistance;
    }

    public double getVoiceChatFadeDistance() {
        return this.voiceChatFadeDistance;
    }

    public double getCrouchDistanceMultiplier() {
        return this.crouchDistanceMultiplier;
    }

    public double getWhisperDistanceMultiplier() {
        return this.whisperDistanceMultiplier;
    }

    public int getKeepAlive() {
        return this.keepAlive;
    }

    public boolean groupsEnabled() {
        return this.groupsEnabled;
    }

    public String getVoiceHost() {
        return this.voiceHost;
    }

    @Override
    public ResourceLocation getID() {
        return SECRET;
    }

    public boolean allowRecording() {
        return this.allowRecording;
    }

    @Override
    public SecretPacket fromBytes(FriendlyByteBuf buf) {
        this.secret = buf.readUUID();
        this.serverPort = buf.readInt();
        this.codec = ServerConfig.Codec.values()[buf.readByte()];
        this.mtuSize = buf.readInt();
        this.voiceChatDistance = buf.readDouble();
        this.voiceChatFadeDistance = buf.readDouble();
        this.crouchDistanceMultiplier = buf.readDouble();
        this.whisperDistanceMultiplier = buf.readDouble();
        this.keepAlive = buf.readInt();
        this.groupsEnabled = buf.readBoolean();
        this.voiceHost = buf.readUtf();
        this.allowRecording = buf.readBoolean();
        return this;
    }

    @Override
    public void toBytes(FriendlyByteBuf buf) {
        buf.writeUUID(this.secret);
        buf.writeInt(this.serverPort);
        buf.writeByte(this.codec.ordinal());
        buf.writeInt(this.mtuSize);
        buf.writeDouble(this.voiceChatDistance);
        buf.writeDouble(this.voiceChatFadeDistance);
        buf.writeDouble(this.crouchDistanceMultiplier);
        buf.writeDouble(this.whisperDistanceMultiplier);
        buf.writeInt(this.keepAlive);
        buf.writeBoolean(this.groupsEnabled);
        buf.writeUtf(this.voiceHost);
        buf.writeBoolean(this.allowRecording);
    }
}

