/*
 * Decompiled with CFR 0.152.
 */
package de.maxhenkel.voicechat.net;

import de.maxhenkel.voicechat.net.Packet;
import de.maxhenkel.voicechat.util.FriendlyByteBuf;
import de.maxhenkel.voicechat.util.ResourceLocation;
import de.maxhenkel.voicechat.voice.common.PlayerState;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;

public class PlayerStatesPacket
implements Packet<PlayerStatesPacket> {
    private Map<UUID, PlayerState> playerStates;
    public static final ResourceLocation PLAYER_STATES = new ResourceLocation("voicechat", "player_states");

    public PlayerStatesPacket() {
    }

    public PlayerStatesPacket(Map<UUID, PlayerState> playerStates) {
        this.playerStates = playerStates;
    }

    public Map<UUID, PlayerState> getPlayerStates() {
        return this.playerStates;
    }

    @Override
    public ResourceLocation getID() {
        return PLAYER_STATES;
    }

    @Override
    public PlayerStatesPacket fromBytes(FriendlyByteBuf buf) {
        this.playerStates = new HashMap<UUID, PlayerState>();
        int count = buf.readInt();
        for (int i = 0; i < count; ++i) {
            PlayerState playerState = PlayerState.fromBytes(buf);
            this.playerStates.put(playerState.getGameProfile().getId(), playerState);
        }
        return this;
    }

    @Override
    public void toBytes(FriendlyByteBuf buf) {
        buf.writeInt(this.playerStates.size());
        for (Map.Entry<UUID, PlayerState> entry : this.playerStates.entrySet()) {
            entry.getValue().toBytes(buf);
        }
    }
}

