/*
 * Decompiled with CFR 0.152.
 */
package de.maxhenkel.voicechat.net;

import de.maxhenkel.voicechat.Voicechat;
import de.maxhenkel.voicechat.net.CreateGroupPacket;
import de.maxhenkel.voicechat.net.JoinGroupPacket;
import de.maxhenkel.voicechat.net.JoinedGroupPacket;
import de.maxhenkel.voicechat.net.LeaveGroupPacket;
import de.maxhenkel.voicechat.net.Packet;
import de.maxhenkel.voicechat.net.PlayerStatePacket;
import de.maxhenkel.voicechat.net.PlayerStatesPacket;
import de.maxhenkel.voicechat.net.RequestSecretPacket;
import de.maxhenkel.voicechat.net.SecretPacket;
import de.maxhenkel.voicechat.net.kyori.adventure.text.Component;
import de.maxhenkel.voicechat.net.kyori.adventure.text.serializer.gson.GsonComponentSerializer;
import de.maxhenkel.voicechat.util.FriendlyByteBuf;
import io.netty.buffer.Unpooled;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.util.Set;
import java.util.UUID;
import net.minecraft.network.chat.ChatMessageType;
import net.minecraft.network.protocol.game.PacketPlayOutChat;
import org.bukkit.Bukkit;
import org.bukkit.craftbukkit.v1_18_R1.entity.CraftPlayer;
import org.bukkit.craftbukkit.v1_18_R1.util.CraftChatMessage;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.player.PlayerJoinEvent;
import org.bukkit.event.player.PlayerQuitEvent;
import org.bukkit.plugin.Plugin;

public class NetManager
implements Listener {
    public static final UUID NUL_UUID = new UUID(0L, 0L);

    public void onEnable() {
        Bukkit.getPluginManager().registerEvents((Listener)this, (Plugin)Voicechat.INSTANCE);
        try {
            NetManager.registerIncomingPacket(RequestSecretPacket.class);
            NetManager.registerIncomingPacket(PlayerStatePacket.class);
            NetManager.registerIncomingPacket(CreateGroupPacket.class);
            NetManager.registerIncomingPacket(JoinGroupPacket.class);
            NetManager.registerIncomingPacket(LeaveGroupPacket.class);
            NetManager.registerOutgoingPacket(SecretPacket.class);
            NetManager.registerOutgoingPacket(PlayerStatesPacket.class);
            NetManager.registerOutgoingPacket(PlayerStatePacket.class);
            NetManager.registerOutgoingPacket(JoinedGroupPacket.class);
        }
        catch (Exception e) {
            throw new IllegalStateException("Failed to register voice chat packets");
        }
    }

    public void onDisable() {
        Set incomingChannels = Bukkit.getMessenger().getIncomingChannels((Plugin)Voicechat.INSTANCE);
        Set outgoingChannels = Bukkit.getMessenger().getOutgoingChannels((Plugin)Voicechat.INSTANCE);
        for (String channel : incomingChannels) {
            Bukkit.getMessenger().unregisterIncomingPluginChannel((Plugin)Voicechat.INSTANCE, channel);
        }
        for (String channel : outgoingChannels) {
            Bukkit.getMessenger().unregisterOutgoingPluginChannel((Plugin)Voicechat.INSTANCE, channel);
        }
    }

    @EventHandler
    public void onPlayerJoin(PlayerJoinEvent event) {
        Player player = event.getPlayer();
        if (player instanceof CraftPlayer) {
            CraftPlayer player2 = (CraftPlayer)player;
            Set outgoingChannels = Bukkit.getMessenger().getOutgoingChannels((Plugin)Voicechat.INSTANCE);
            for (String channel : outgoingChannels) {
                player2.addChannel(channel);
            }
        }
    }

    @EventHandler
    public void onPlayerQuit(PlayerQuitEvent event) {
        Player player = event.getPlayer();
        if (player instanceof CraftPlayer) {
            CraftPlayer player2 = (CraftPlayer)player;
            Set outgoingChannels = Bukkit.getMessenger().getOutgoingChannels((Plugin)Voicechat.INSTANCE);
            for (String channel : outgoingChannels) {
                player2.removeChannel(channel);
            }
        }
    }

    public static <T extends Packet<?>> void registerIncomingPacket(Class<T> packetClass) throws NoSuchMethodException, InvocationTargetException, InstantiationException, IllegalAccessException {
        Constructor c = packetClass.getDeclaredConstructor(new Class[0]);
        Bukkit.getMessenger().registerIncomingPluginChannel((Plugin)Voicechat.INSTANCE, ((Packet)c.newInstance(new Object[0])).getID().toString(), (s, player, bytes) -> {
            Packet packet;
            try {
                packet = (Packet)c.newInstance(new Object[0]);
            }
            catch (Exception e) {
                Voicechat.LOGGER.error("Failed to create new packet instance of {}: {}", (Object)packetClass.getSimpleName(), (Object)e.getMessage());
                return;
            }
            FriendlyByteBuf buffer = new FriendlyByteBuf(Unpooled.wrappedBuffer((byte[])bytes));
            packet.fromBytes(buffer);
            packet.onPacket(player);
        });
    }

    public static <T extends Packet<?>> void registerOutgoingPacket(Class<T> packetClass) throws NoSuchMethodException, InvocationTargetException, InstantiationException, IllegalAccessException {
        Bukkit.getMessenger().registerOutgoingPluginChannel((Plugin)Voicechat.INSTANCE, ((Packet)packetClass.getDeclaredConstructor(new Class[0]).newInstance(new Object[0])).getID().toString());
    }

    public static void sendToClient(Player player, Packet<?> p) {
        if (!Voicechat.SERVER.isCompatible(player)) {
            return;
        }
        try {
            FriendlyByteBuf buf = new FriendlyByteBuf();
            p.toBytes(buf);
            byte[] bytes = new byte[buf.readableBytes()];
            buf.readBytes(bytes);
            player.sendPluginMessage((Plugin)Voicechat.INSTANCE, p.getID().toString(), bytes);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static void sendMessage(Player p, Component component) {
        if (p instanceof CraftPlayer) {
            CraftPlayer player = (CraftPlayer)p;
            player.getHandle().b.a((net.minecraft.network.protocol.Packet)new PacketPlayOutChat(CraftChatMessage.fromJSON((String)((String)GsonComponentSerializer.gson().serialize(component))), ChatMessageType.b, NUL_UUID));
        }
    }
}

