/*
 * Decompiled with CFR 0.152.
 */
package de.maxhenkel.voicechat.net;

import de.maxhenkel.voicechat.Voicechat;
import de.maxhenkel.voicechat.net.Packet;
import de.maxhenkel.voicechat.util.FriendlyByteBuf;
import de.maxhenkel.voicechat.util.ResourceLocation;
import javax.annotation.Nullable;
import org.bukkit.entity.Player;

public class CreateGroupPacket
implements Packet<CreateGroupPacket> {
    public static final ResourceLocation CREATE_GROUP = new ResourceLocation("voicechat", "create_group");
    private String name;
    @Nullable
    private String password;

    public CreateGroupPacket() {
    }

    public CreateGroupPacket(String name, @Nullable String password) {
        this.name = name;
        this.password = password;
    }

    public String getName() {
        return this.name;
    }

    @Nullable
    public String getPassword() {
        return this.password;
    }

    @Override
    public ResourceLocation getID() {
        return CREATE_GROUP;
    }

    @Override
    public void onPacket(Player player) {
        Voicechat.SERVER.getServer().getGroupManager().onCreateGroupPacket(player, this);
    }

    @Override
    public CreateGroupPacket fromBytes(FriendlyByteBuf buf) {
        this.name = buf.readUtf(512);
        this.password = null;
        if (buf.readBoolean()) {
            this.password = buf.readUtf(512);
        }
        return this;
    }

    @Override
    public void toBytes(FriendlyByteBuf buf) {
        buf.writeUtf(this.name, 512);
        buf.writeBoolean(this.password != null);
        if (this.password != null) {
            buf.writeUtf(this.password, 512);
        }
    }
}

