/*
 * Decompiled with CFR 0.152.
 */
package de.maxhenkel.voicechat;

import de.maxhenkel.voicechat.api.BukkitVoicechatService;
import de.maxhenkel.voicechat.command.VoiceChatCommands;
import de.maxhenkel.voicechat.config.ServerConfig;
import de.maxhenkel.voicechat.configbuilder.ConfigBuilder;
import de.maxhenkel.voicechat.integration.placeholderapi.VoicechatExpansion;
import de.maxhenkel.voicechat.net.NetManager;
import de.maxhenkel.voicechat.plugins.PluginManager;
import de.maxhenkel.voicechat.plugins.impl.BukkitVoicechatServiceImpl;
import de.maxhenkel.voicechat.voice.server.ServerVoiceEvents;
import java.io.File;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.Map;
import java.util.Properties;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.bukkit.Bukkit;
import org.bukkit.command.CommandExecutor;
import org.bukkit.configuration.file.YamlConfiguration;
import org.bukkit.event.Listener;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.ServicePriority;
import org.bukkit.plugin.java.JavaPlugin;

public final class Voicechat
extends JavaPlugin {
    public static Voicechat INSTANCE;
    public static final String MODID = "voicechat";
    public static final Logger LOGGER;
    public static int COMPATIBILITY_VERSION;
    public static ServerConfig SERVER_CONFIG;
    private static YamlConfiguration TRANSLATIONS;
    private static YamlConfiguration DEFAULT_TRANSLATIONS;
    public static ServerVoiceEvents SERVER;
    public static BukkitVoicechatServiceImpl apiService;
    public static NetManager netManager;

    public void onEnable() {
        INSTANCE = this;
        try {
            InputStream in = ((Object)((Object)this)).getClass().getClassLoader().getResourceAsStream("compatibility.properties");
            Properties props = new Properties();
            props.load(in);
            COMPATIBILITY_VERSION = Integer.parseInt(props.getProperty("compatibility_version"));
            LOGGER.info("Compatibility version {}", (Object)COMPATIBILITY_VERSION);
        }
        catch (Exception e) {
            LOGGER.error("Failed to read compatibility version");
        }
        try {
            LOGGER.info("Loading translations");
            DEFAULT_TRANSLATIONS = YamlConfiguration.loadConfiguration((Reader)new InputStreamReader(this.getResource("translations.yml")));
            File file = new File(this.getDataFolder(), "translations.yml");
            if (file.exists()) {
                TRANSLATIONS = YamlConfiguration.loadConfiguration((File)file);
                Voicechat.mergeConfigs(TRANSLATIONS, DEFAULT_TRANSLATIONS);
            } else {
                TRANSLATIONS = DEFAULT_TRANSLATIONS;
            }
            TRANSLATIONS.save(file);
        }
        catch (Exception e) {
            LOGGER.fatal("Failed to load translations");
            e.printStackTrace();
            this.getServer().shutdown();
            return;
        }
        netManager = new NetManager();
        netManager.onEnable();
        SERVER_CONFIG = ConfigBuilder.build(this.getDataFolder().toPath().resolve("voicechat-server.properties"), true, ServerConfig::new);
        apiService = new BukkitVoicechatServiceImpl();
        this.getServer().getServicesManager().register(BukkitVoicechatService.class, (Object)apiService, (Plugin)this, ServicePriority.Normal);
        this.getCommand(MODID).setExecutor((CommandExecutor)new VoiceChatCommands());
        try {
            if (Bukkit.getPluginManager().getPlugin("PlaceholderAPI") != null) {
                new VoicechatExpansion().register();
                LOGGER.info("Successfully registered PlaceholderAPI expansion");
            }
        }
        catch (Exception e) {
            LOGGER.error("Failed to register PlaceholderAPI expansion");
        }
        this.getServer().getScheduler().scheduleSyncDelayedTask((Plugin)this, () -> {
            PluginManager.instance().init((Plugin)this);
            SERVER = new ServerVoiceEvents(this.getServer());
            Bukkit.getPluginManager().registerEvents((Listener)SERVER, (Plugin)this);
            Bukkit.getPluginManager().registerEvents((Listener)SERVER.getServer().getPlayerStateManager(), (Plugin)this);
        });
    }

    private static void mergeConfigs(YamlConfiguration base, YamlConfiguration add) {
        Map values = add.getValues(true);
        for (Map.Entry entry : values.entrySet()) {
            if (base.contains((String)entry.getKey())) continue;
            base.set((String)entry.getKey(), entry.getValue());
        }
    }

    public void onDisable() {
        netManager.onDisable();
        this.getServer().getServicesManager().unregister((Object)apiService);
        if (SERVER != null) {
            SERVER.getServer().close();
        }
    }

    public static String translate(String key) {
        return (String)TRANSLATIONS.get(key);
    }

    static {
        LOGGER = LogManager.getLogger((String)MODID);
        COMPATIBILITY_VERSION = -1;
    }
}

