/*
 * Decompiled with CFR 0.152.
 */
package de.geheimagentnr1.auto_restart.task;

import de.geheimagentnr1.auto_restart.config.AutoRestartTime;
import de.geheimagentnr1.auto_restart.config.ServerConfig;
import de.geheimagentnr1.auto_restart.config.Timing;
import de.geheimagentnr1.auto_restart.util.ServerRestarter;
import de.geheimagentnr1.auto_restart.util.TpsHelper;
import java.time.Duration;
import java.time.LocalDateTime;
import java.util.TimerTask;
import net.minecraft.ChatFormatting;
import net.minecraft.Util;
import net.minecraft.network.chat.ChatType;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.Style;
import net.minecraft.network.chat.TextComponent;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerLevel;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class AutoRestartTask
extends TimerTask {
    private static final Logger LOGGER = LogManager.getLogger(AutoRestartTask.class);
    private final MinecraftServer server;
    private boolean isRestartRunning = false;
    private static LocalDateTime empty_time;
    private static long tpsProblemDuration;

    public AutoRestartTask(MinecraftServer _server) {
        this.server = _server;
    }

    @Override
    public void run() {
        if (this.isRestartRunning) {
            return;
        }
        LocalDateTime current_time = LocalDateTime.now();
        if (ServerConfig.getOnEmptyRestartEnabled() && empty_time != null && Duration.between(empty_time, current_time).getSeconds() >= ServerConfig.getOnEmptyRestartDelay().getSeconds()) {
            LOGGER.info("Auto restarting Server on empty server");
            this.restart();
            return;
        }
        if (ServerConfig.isLowTpsRestartEnabled()) {
            boolean foundTpsProblem = false;
            long[] serverTickTimes = this.server.f_129748_;
            if (TpsHelper.calculateTps(serverTickTimes) < ServerConfig.getLowTpsRestartMinimumTpsLevel()) {
                ++tpsProblemDuration;
                foundTpsProblem = true;
            }
            if (!foundTpsProblem) {
                for (ServerLevel serverLevel : this.server.m_129785_()) {
                    long[] tickTimes = this.server.getTickTime(serverLevel.m_46472_());
                    if (tickTimes == null || !(TpsHelper.calculateTps(tickTimes) < ServerConfig.getLowTpsRestartMinimumTpsLevel())) continue;
                    ++tpsProblemDuration;
                    foundTpsProblem = true;
                    break;
                }
            }
            if (foundTpsProblem) {
                if (tpsProblemDuration >= ServerConfig.getLowTpsRestartDelay().getSeconds()) {
                    LOGGER.info("Auto restarting Server on low tps");
                    this.restart();
                    return;
                }
            } else {
                tpsProblemDuration = 0L;
            }
        }
        if (ServerConfig.isAutoRestartEnabled()) {
            for (AutoRestartTime autoRestartTime : ServerConfig.getAutoRestartTimes()) {
                Duration difference = autoRestartTime.getDifferenceTo(current_time);
                for (Timing warning_time : ServerConfig.getAutoRestartWarningTimes()) {
                    if (difference.getSeconds() != warning_time.getSeconds()) continue;
                    this.server.m_6846_().m_11264_((Component)new TextComponent(String.format("Restarting in %s...", warning_time.getDisplayString())).m_6270_(Style.f_131099_.m_131140_(ChatFormatting.YELLOW)), ChatType.SYSTEM, Util.f_137441_);
                }
                if (autoRestartTime.getHour() != current_time.getHour() || autoRestartTime.getMinute() != current_time.getMinute()) continue;
                LOGGER.info("Auto restarting Server on auto restarting time");
                this.restart();
                return;
            }
        }
    }

    private void restart() {
        ServerRestarter.restart(this.server);
        this.isRestartRunning = true;
    }

    public static void resetEmptyTime() {
        empty_time = null;
        LOGGER.info("Empty server timer stopped");
    }

    public static void setEmptyTime() {
        empty_time = LocalDateTime.now();
        LOGGER.info("Empty server timer started");
    }

    static {
        tpsProblemDuration = 0L;
    }
}

