/*
 * Decompiled with CFR 0.152.
 */
package net.geforcemods.securitycraft.util;

import net.geforcemods.securitycraft.blockentities.InventoryScannerBlockEntity;
import net.geforcemods.securitycraft.blocks.InventoryScannerBlock;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.core.NonNullList;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.Style;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;

public class Utils {
    public static final Style GRAY_STYLE = Style.f_131099_.m_131140_(ChatFormatting.GRAY);
    public static final Component INVENTORY_TEXT = Utils.localize("container.inventory", new Object[0]);

    public static String removeLastChar(String line) {
        if (line == null || line.isEmpty()) {
            return "";
        }
        return line.substring(0, line.length() - 1);
    }

    public static TranslatableComponent getFormattedCoordinates(BlockPos pos) {
        return new TranslatableComponent("messages.securitycraft:formattedCoordinates", new Object[]{pos.m_123341_(), pos.m_123342_(), pos.m_123343_()});
    }

    public static void setISinTEAppropriately(Level level, BlockPos pos, NonNullList<ItemStack> contents) {
        InventoryScannerBlockEntity connectedScanner = InventoryScannerBlock.getConnectedInventoryScanner(level, pos);
        if (connectedScanner == null) {
            return;
        }
        connectedScanner.setContents(contents);
    }

    public static TranslatableComponent localize(String key, Object ... params) {
        for (int i = 0; i < params.length; ++i) {
            Object object = params[i];
            if (object instanceof TranslatableComponent) {
                TranslatableComponent component = (TranslatableComponent)object;
                params[i] = Utils.localize(component.m_131328_(), component.m_131329_());
                continue;
            }
            object = params[i];
            if (!(object instanceof BlockPos)) continue;
            BlockPos pos = (BlockPos)object;
            params[i] = Utils.getFormattedCoordinates(pos);
        }
        return new TranslatableComponent(key, params);
    }
}

