/*
 * Decompiled with CFR 0.152.
 */
package net.geforcemods.securitycraft.util;

import java.util.ArrayList;
import java.util.List;
import net.geforcemods.securitycraft.api.IModuleInventory;
import net.geforcemods.securitycraft.api.IOwnable;
import net.geforcemods.securitycraft.api.LinkableBlockEntity;
import net.geforcemods.securitycraft.api.LinkedAction;
import net.geforcemods.securitycraft.items.ModuleItem;
import net.geforcemods.securitycraft.misc.ModuleType;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.entity.BlockEntity;

public class ModuleUtils {
    public static List<String> getPlayersFromModule(ItemStack stack) {
        ArrayList<String> list = new ArrayList<String>();
        if (stack.m_41720_() instanceof ModuleItem) {
            for (int i = 1; i <= 50; ++i) {
                if (stack.m_41783_() == null || stack.m_41783_().m_128461_("Player" + i) == null || stack.m_41783_().m_128461_("Player" + i).isEmpty()) continue;
                list.add(stack.m_41783_().m_128461_("Player" + i).toLowerCase());
            }
        }
        return list;
    }

    public static boolean isAllowed(IModuleInventory inv, Entity entity) {
        return ModuleUtils.isAllowed(inv, entity.m_7755_().getString());
    }

    public static boolean isAllowed(IModuleInventory inv, String name) {
        ItemStack stack = inv.getModule(ModuleType.ALLOWLIST);
        if (stack.m_41782_() && stack.m_41783_().m_128471_("affectEveryone")) {
            return true;
        }
        return ModuleUtils.getPlayersFromModule(stack).contains(name.toLowerCase());
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static boolean isDenied(IModuleInventory inv, Entity entity) {
        ItemStack stack = inv.getModule(ModuleType.DENYLIST);
        if (!stack.m_41782_() || !stack.m_41783_().m_128471_("affectEveryone")) return ModuleUtils.getPlayersFromModule(stack).contains(entity.m_7755_().getString().toLowerCase());
        BlockEntity blockEntity = inv.getBlockEntity();
        if (!(blockEntity instanceof IOwnable)) return true;
        IOwnable ownable = (IOwnable)blockEntity;
        if (!(entity instanceof Player)) return true;
        Player player = (Player)entity;
        if (ownable.getOwner().isOwner(player)) return ModuleUtils.getPlayersFromModule(stack).contains(entity.m_7755_().getString().toLowerCase());
        return true;
    }

    public static void createLinkedAction(LinkedAction action, ItemStack stack, LinkableBlockEntity be) {
        if (action == LinkedAction.MODULE_INSERTED) {
            be.createLinkedBlockAction(action, new Object[]{stack, (ModuleItem)stack.m_41720_()}, be);
        } else if (action == LinkedAction.MODULE_REMOVED) {
            be.createLinkedBlockAction(action, new Object[]{stack, ((ModuleItem)stack.m_41720_()).getModuleType()}, be);
        }
    }
}

