/*
 * Decompiled with CFR 0.152.
 */
package net.geforcemods.securitycraft.util;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.BufferBuilder;
import com.mojang.blaze3d.vertex.BufferUploader;
import com.mojang.blaze3d.vertex.DefaultVertexFormat;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.Tesselator;
import com.mojang.blaze3d.vertex.VertexFormat;
import com.mojang.math.Matrix4f;
import java.util.Arrays;
import net.geforcemods.securitycraft.SecurityCraft;
import net.geforcemods.securitycraft.misc.ModuleType;
import net.geforcemods.securitycraft.network.server.UpdateNBTTagOnServer;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;

public class ClientUtils {
    private static final ResourceLocation[] MODULE_TEXTURES = new ResourceLocation[]{new ResourceLocation("securitycraft", "textures/item/module_background.png"), new ResourceLocation("securitycraft", "textures/item/whitelist_module.png"), new ResourceLocation("securitycraft", "textures/item/blacklist_module.png"), new ResourceLocation("securitycraft", "textures/item/harming_module.png"), new ResourceLocation("securitycraft", "textures/item/smart_module.png"), new ResourceLocation("securitycraft", "textures/item/storage_module.png"), new ResourceLocation("securitycraft", "textures/item/disguise_module.png"), new ResourceLocation("securitycraft", "textures/item/module_background.png")};
    private static final ResourceLocation REDSTONE_TEXTURE = new ResourceLocation("textures/item/redstone.png");
    private static final ResourceLocation SUGAR_TEXTURE = new ResourceLocation("textures/item/sugar.png");

    public static String getFormattedMinecraftTime() {
        Long time = Minecraft.m_91087_().f_91073_.m_46468_();
        int hours24 = (int)((float)time.longValue() / 1000.0f + 6.0f) % 24;
        int hours = hours24 % 12;
        int minutes = (int)((float)time.longValue() / 16.666666f % 60.0f);
        return String.format("%02d:%02d %s", hours < 1 ? 12 : hours, minutes, hours24 < 12 ? "AM" : "PM");
    }

    public static void syncItemNBT(ItemStack item) {
        SecurityCraft.channel.sendToServer((Object)new UpdateNBTTagOnServer(item));
    }

    public static void renderModuleInfo(PoseStack pose, ModuleType module, Component moduleTooltip, Component noModuleTooltip, boolean isModuleInstalled, int moduleLeft, int moduleTop, int screenWidth, int screenHeight, int mouseX, int mouseY) {
        Minecraft mc = Minecraft.m_91087_();
        float alpha = isModuleInstalled ? 1.0f : 0.5f;
        int moduleRight = moduleLeft + 16;
        int moduleBottom = moduleTop + 16;
        Matrix4f m4f = pose.m_85850_().m_85861_();
        BufferBuilder bufferBuilder = Tesselator.m_85913_().m_85915_();
        RenderSystem.m_69478_();
        RenderSystem.m_69453_();
        RenderSystem.m_157427_(GameRenderer::m_172814_);
        RenderSystem.m_157179_((int)0, (ResourceLocation)MODULE_TEXTURES[module.ordinal()]);
        ClientUtils.drawTexture(bufferBuilder, m4f, moduleLeft, moduleTop, moduleRight, moduleBottom, alpha);
        if (module == ModuleType.REDSTONE) {
            RenderSystem.m_157179_((int)0, (ResourceLocation)REDSTONE_TEXTURE);
            ClientUtils.drawTexture(bufferBuilder, m4f, moduleLeft, moduleTop, moduleRight, moduleBottom, alpha);
        } else if (module == ModuleType.SPEED) {
            RenderSystem.m_157179_((int)0, (ResourceLocation)SUGAR_TEXTURE);
            ClientUtils.drawTexture(bufferBuilder, m4f, moduleLeft, moduleTop, moduleRight, moduleBottom, alpha);
        }
        RenderSystem.m_69461_();
        if (mouseX >= moduleLeft && mouseX < moduleRight && mouseY >= moduleTop && mouseY <= moduleBottom) {
            Component text;
            Component component = text = isModuleInstalled ? moduleTooltip : noModuleTooltip;
            if (text != null && mc.f_91080_ != null) {
                mc.f_91080_.m_96597_(pose, Arrays.asList(text), mouseX, mouseY);
            }
        }
    }

    private static void drawTexture(BufferBuilder bufferBuilder, Matrix4f m4f, int moduleLeft, int moduleTop, int moduleRight, int moduleBottom, float alpha) {
        bufferBuilder.m_166779_(VertexFormat.Mode.QUADS, DefaultVertexFormat.f_85818_);
        bufferBuilder.m_85982_(m4f, (float)moduleLeft, (float)moduleBottom, 0.0f).m_85950_(1.0f, 1.0f, 1.0f, alpha).m_7421_(0.0f, 1.0f).m_5752_();
        bufferBuilder.m_85982_(m4f, (float)moduleRight, (float)moduleBottom, 0.0f).m_85950_(1.0f, 1.0f, 1.0f, alpha).m_7421_(1.0f, 1.0f).m_5752_();
        bufferBuilder.m_85982_(m4f, (float)moduleRight, (float)moduleTop, 0.0f).m_85950_(1.0f, 1.0f, 1.0f, alpha).m_7421_(1.0f, 0.0f).m_5752_();
        bufferBuilder.m_85982_(m4f, (float)moduleLeft, (float)moduleTop, 0.0f).m_85950_(1.0f, 1.0f, 1.0f, alpha).m_7421_(0.0f, 0.0f).m_5752_();
        bufferBuilder.m_85721_();
        BufferUploader.m_85761_((BufferBuilder)bufferBuilder);
    }
}

