/*
 * Decompiled with CFR 0.152.
 */
package net.geforcemods.securitycraft.screen;

import com.mojang.blaze3d.platform.InputConstants;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import net.geforcemods.securitycraft.SCContent;
import net.geforcemods.securitycraft.SecurityCraft;
import net.geforcemods.securitycraft.entity.Sentry;
import net.geforcemods.securitycraft.network.server.SetSentryMode;
import net.geforcemods.securitycraft.network.server.UpdateNBTTagOnServer;
import net.geforcemods.securitycraft.screen.components.IdButton;
import net.geforcemods.securitycraft.screen.components.TextHoverChecker;
import net.geforcemods.securitycraft.screen.components.TogglePictureButton;
import net.geforcemods.securitycraft.util.Utils;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.components.AbstractWidget;
import net.minecraft.client.gui.components.Widget;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.phys.AABB;

public class SentryRemoteAccessToolScreen
extends Screen {
    private static final ResourceLocation TEXTURE = new ResourceLocation("securitycraft", "textures/gui/container/srat.png");
    private static final ResourceLocation SENTRY_ICONS = new ResourceLocation("securitycraft", "textures/gui/container/sentry_icons.png");
    private final TranslatableComponent modifyAll = Utils.localize("gui.securitycraft:srat.modifyAll", new Object[0]);
    private ItemStack srat;
    private IdButton[][] guiButtons = new IdButton[12][3];
    private Component[] names = new Component[12];
    private IdButton[] guiButtonsGlobal = new IdButton[3];
    private static final int MODE = 0;
    private static final int TARGETS = 1;
    private static final int UNBIND = 2;
    private int xSize = 440;
    private int ySize = 215;
    private static final int SENTRY_TRACKING_RANGE = 256;
    private int viewDistance;
    private List<TextHoverChecker> hoverCheckers = new ArrayList<TextHoverChecker>();
    private final TranslatableComponent notBound = Utils.localize("gui.securitycraft:srat.notBound", new Object[0]);
    private final Component[] lines = new Component[12];
    private final int[] lengths = new int[12];

    public SentryRemoteAccessToolScreen(ItemStack item, int viewDistance) {
        super((Component)new TranslatableComponent(item.m_41778_()));
        this.srat = item;
        this.viewDistance = viewDistance;
    }

    public void m_7856_() {
        super.m_7856_();
        int startX = (this.f_96543_ - this.xSize) / 2;
        int startY = (this.f_96544_ - this.ySize) / 2;
        int paddingX = 22;
        int paddingY = 25;
        int[] coords = null;
        int id = 0;
        boolean foundSentry = false;
        int[] modeTextureX = new int[]{0, 16, 32};
        int[] targetTextureX = new int[]{48, 64, 80};
        int[] yStarts = new int[]{0, 0, 0};
        this.hoverCheckers.clear();
        for (int i = 0; i < 12; ++i) {
            int x = i / 6 * this.xSize / 2;
            int y = (i % 6 + 1) * 30 + paddingY;
            coords = this.getSentryCoordinates(i);
            for (int j = 0; j < 3; ++j) {
                int btnX = startX + j * paddingX + 147 + x;
                int btnY = startY + y - 48;
                switch (j) {
                    case 0: {
                        this.guiButtons[i][j] = new TogglePictureButton(id++, btnX, btnY, 20, 20, SENTRY_ICONS, modeTextureX, yStarts, 2, 3, this::actionPerformed);
                        this.guiButtons[i][j].f_93623_ = false;
                        break;
                    }
                    case 1: {
                        this.guiButtons[i][j] = new TogglePictureButton(id++, btnX, btnY, 20, 20, SENTRY_ICONS, targetTextureX, yStarts, 2, 3, this::actionPerformed);
                        this.guiButtons[i][j].f_93623_ = false;
                        break;
                    }
                    case 2: {
                        this.guiButtons[i][j] = new IdButton(id++, btnX, btnY, 20, 20, "X", this::clickUnbind);
                        this.guiButtons[i][j].f_93623_ = false;
                    }
                }
                this.m_142416_((GuiEventListener)this.guiButtons[i][j]);
            }
            BlockPos sentryPos = new BlockPos(coords[0], coords[1], coords[2]);
            if (coords[0] != 0 || coords[1] != 0 || coords[2] != 0) {
                this.guiButtons[i][2].f_93623_ = true;
                if (Minecraft.m_91087_().f_91074_.f_19853_.m_46749_(sentryPos) && this.isSentryVisibleToPlayer(sentryPos)) {
                    List sentries = Minecraft.m_91087_().f_91074_.f_19853_.m_45976_(Sentry.class, new AABB(sentryPos));
                    if (!sentries.isEmpty()) {
                        Sentry sentry = (Sentry)((Object)sentries.get(0));
                        Sentry.SentryMode mode = sentry.getMode();
                        if (sentry.m_8077_()) {
                            TranslatableComponent line = Utils.getFormattedCoordinates(new BlockPos(coords[0], coords[1], coords[2]));
                            int nameWidth = this.f_96547_.m_92852_((FormattedText)sentry.m_7770_());
                            int nameX = startX + this.xSize / 4 - nameWidth + 33 + i / 6 * this.xSize / 2;
                            int nameY = startY + i % 6 * 30 + 7;
                            TextHoverChecker posTooltipText = new TextHoverChecker(nameY + 4, nameY + 18, nameX, nameX + nameWidth + 2, (Component)line);
                            this.names[i] = sentry.m_7770_();
                            this.hoverCheckers.add(posTooltipText);
                        }
                        this.guiButtons[i][0].f_93623_ = true;
                        this.guiButtons[i][1].f_93623_ = mode != Sentry.SentryMode.IDLE;
                        this.guiButtons[i][2].f_93623_ = true;
                        ((TogglePictureButton)this.guiButtons[i][0]).setCurrentIndex(mode.ordinal() / 3);
                        ((TogglePictureButton)this.guiButtons[i][1]).setCurrentIndex(mode.ordinal() % 3);
                        this.hoverCheckers.add(new TextHoverChecker((AbstractWidget)this.guiButtons[i][0], Arrays.asList(Utils.localize("gui.securitycraft:srat.mode2", new Object[0]), Utils.localize("gui.securitycraft:srat.mode1", new Object[0]), Utils.localize("gui.securitycraft:srat.mode3", new Object[0]))));
                        this.hoverCheckers.add(new TextHoverChecker((AbstractWidget)this.guiButtons[i][1], Arrays.asList(Utils.localize("gui.securitycraft:srat.targets1", new Object[0]), Utils.localize("gui.securitycraft:srat.targets2", new Object[0]), Utils.localize("gui.securitycraft:srat.targets3", new Object[0]))));
                        this.hoverCheckers.add(new TextHoverChecker((AbstractWidget)this.guiButtons[i][2], (Component)Utils.localize("gui.securitycraft:srat.unbind", new Object[0])));
                        foundSentry = true;
                    } else {
                        this.removeTagFromToolAndUpdate(this.srat, coords[0], coords[1], coords[2]);
                        for (int j = 0; j < 3; ++j) {
                            this.guiButtons[i][j].f_93623_ = false;
                        }
                    }
                } else {
                    for (int j = 0; j < 2; ++j) {
                        this.hoverCheckers.add(new TextHoverChecker((AbstractWidget)this.guiButtons[i][j], (Component)Utils.localize("gui.securitycraft:srat.outOfRange", new Object[0])));
                    }
                    this.hoverCheckers.add(new TextHoverChecker((AbstractWidget)this.guiButtons[i][2], (Component)Utils.localize("gui.securitycraft:srat.unbind", new Object[0])));
                }
            }
            this.lines[i] = coords[0] == 0 && coords[1] == 0 && coords[2] == 0 ? this.notBound : (this.names[i] != null ? this.names[i] : Utils.getFormattedCoordinates(new BlockPos(coords[0], coords[1], coords[2])));
            this.lengths[i] = this.f_96547_.m_92852_((FormattedText)this.lines[i]);
        }
        this.guiButtonsGlobal[0] = new TogglePictureButton(1000, startX + 260, startY + 188, 20, 20, SENTRY_ICONS, modeTextureX, yStarts, 2, 3, this::actionPerformedGlobal);
        this.guiButtonsGlobal[1] = new TogglePictureButton(1001, startX + 22 + 260, startY + 188, 20, 20, SENTRY_ICONS, targetTextureX, yStarts, 2, 3, this::actionPerformedGlobal);
        this.guiButtonsGlobal[2] = new IdButton(1002, startX + 44 + 260, startY + 188, 20, 20, "X", this::clickGlobalUnbind);
        for (int j = 0; j < 3; ++j) {
            this.guiButtonsGlobal[j].f_93623_ = foundSentry;
            this.m_142416_((GuiEventListener)this.guiButtonsGlobal[j]);
        }
        this.hoverCheckers.add(new TextHoverChecker((AbstractWidget)this.guiButtonsGlobal[0], Arrays.asList(Utils.localize("gui.securitycraft:srat.mode2", new Object[0]), Utils.localize("gui.securitycraft:srat.mode1", new Object[0]), Utils.localize("gui.securitycraft:srat.mode3", new Object[0]))));
        this.hoverCheckers.add(new TextHoverChecker((AbstractWidget)this.guiButtonsGlobal[1], Arrays.asList(Utils.localize("gui.securitycraft:srat.targets1", new Object[0]), Utils.localize("gui.securitycraft:srat.targets2", new Object[0]), Utils.localize("gui.securitycraft:srat.targets3", new Object[0]))));
        this.hoverCheckers.add(new TextHoverChecker((AbstractWidget)this.guiButtonsGlobal[2], (Component)Utils.localize("gui.securitycraft:srat.unbind", new Object[0])));
    }

    public void m_6305_(PoseStack pose, int mouseX, int mouseY, float partialTicks) {
        int startX = (this.f_96543_ - this.xSize) / 2;
        int startY = (this.f_96544_ - this.ySize) / 2;
        this.m_7333_(pose);
        RenderSystem.m_157429_((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        RenderSystem.m_157179_((int)0, (ResourceLocation)TEXTURE);
        SentryRemoteAccessToolScreen.m_93133_((PoseStack)pose, (int)startX, (int)startY, (float)0.0f, (float)0.0f, (int)this.xSize, (int)this.ySize, (int)512, (int)256);
        super.m_6305_(pose, mouseX, mouseY, partialTicks);
        this.f_96547_.m_92889_(pose, (Component)Utils.localize(((Item)SCContent.REMOTE_ACCESS_SENTRY.get()).m_5524_(), new Object[0]), (float)(startX + 5), (float)(startY - 25 + 13), 0xFF0000);
        for (int i = 0; i < 12; ++i) {
            this.f_96547_.m_92889_(pose, this.lines[i], (float)(startX + this.xSize / 4 - this.lengths[i] + 35 + i / 6 * this.xSize / 2), (float)(startY + i % 6 * 30 + 13), 0x404040);
        }
        this.f_96547_.m_92889_(pose, (Component)this.modifyAll, (float)(startX + this.xSize / 2 - this.f_96547_.m_92852_((FormattedText)this.modifyAll) + 25), (float)(startY + 194), 0x404040);
        for (TextHoverChecker chc : this.hoverCheckers) {
            if (chc == null || !chc.checkHover(mouseX, mouseY)) continue;
            this.m_96602_(pose, chc.getName(), mouseX, mouseY);
        }
    }

    protected void performSingleAction(int sentry, int mode, int targets) {
        int[] coords = this.getSentryCoordinates(sentry);
        List sentries = Minecraft.m_91087_().f_91074_.f_19853_.m_45976_(Sentry.class, new AABB(new BlockPos(coords[0], coords[1], coords[2])));
        if (!sentries.isEmpty()) {
            int resultingMode = Math.max(0, Math.min(targets + mode * 3, 6));
            this.guiButtons[sentry][1].f_93623_ = Sentry.SentryMode.values()[resultingMode] != Sentry.SentryMode.IDLE;
            ((Sentry)((Object)sentries.get(0))).toggleMode((Player)Minecraft.m_91087_().f_91074_, resultingMode, false);
            SecurityCraft.channel.sendToServer((Object)new SetSentryMode(((Sentry)((Object)sentries.get(0))).m_142538_(), resultingMode));
        }
    }

    private void clickUnbind(IdButton button) {
        this.unbindSentry(button.id / 3);
    }

    private void clickGlobalUnbind(IdButton button) {
        for (int i = 0; i < 12; ++i) {
            this.unbindSentry(i);
        }
    }

    private void unbindSentry(int sentry) {
        int i;
        int[] coords = this.getSentryCoordinates(sentry);
        this.removeTagFromToolAndUpdate(this.srat, coords[0], coords[1], coords[2]);
        for (i = 0; i < 3; ++i) {
            this.guiButtons[sentry][i].f_93623_ = false;
        }
        for (i = 0; i < this.guiButtons.length; ++i) {
            if (!this.guiButtons[i][2].f_93623_) continue;
            return;
        }
        for (i = 0; i < 3; ++i) {
            this.guiButtonsGlobal[i].f_93623_ = false;
        }
    }

    protected void actionPerformed(IdButton button) {
        int mode;
        int sentry = button.id / 3;
        int type = button.id % 3;
        int targets = mode = ((TogglePictureButton)button).getCurrentIndex();
        if (type == 0) {
            targets = ((TogglePictureButton)this.guiButtons[sentry][1]).getCurrentIndex();
        } else if (type == 1) {
            mode = ((TogglePictureButton)this.guiButtons[sentry][0]).getCurrentIndex();
        }
        this.performSingleAction(sentry, mode, targets);
    }

    protected void actionPerformedGlobal(IdButton button) {
        for (int i = 0; i < this.f_169369_.size() / 3; ++i) {
            Widget widget = (Widget)this.f_169369_.get(i * 3);
            if (!(widget instanceof IdButton)) continue;
            IdButton idButton = (IdButton)widget;
            if (this.getSentryCoordinates(i)[1] == 0) continue;
            int sentry = idButton.id / 3;
            int mode = button.id == this.guiButtonsGlobal[0].id ? ((TogglePictureButton)this.guiButtonsGlobal[0]).getCurrentIndex() : ((TogglePictureButton)this.guiButtons[sentry][0]).getCurrentIndex();
            int targets = button.id == this.guiButtonsGlobal[1].id ? ((TogglePictureButton)this.guiButtonsGlobal[1]).getCurrentIndex() : ((TogglePictureButton)this.guiButtons[sentry][1]).getCurrentIndex();
            ((TogglePictureButton)this.guiButtons[sentry][0]).setCurrentIndex(mode);
            ((TogglePictureButton)this.guiButtons[sentry][1]).setCurrentIndex(targets);
            this.performSingleAction(sentry, mode, targets);
        }
    }

    private int[] getSentryCoordinates(int sentry) {
        if (this.srat.m_41720_() != null && this.srat.m_41720_() == SCContent.REMOTE_ACCESS_SENTRY.get() && this.srat.m_41783_() != null && this.srat.m_41783_().m_128465_("sentry" + ++sentry) != null && this.srat.m_41783_().m_128465_("sentry" + sentry).length > 0) {
            return this.srat.m_41783_().m_128465_("sentry" + sentry);
        }
        return new int[]{0, 0, 0};
    }

    private void removeTagFromToolAndUpdate(ItemStack stack, int x, int y, int z) {
        if (stack.m_41783_() == null) {
            return;
        }
        for (int i = 1; i <= 12; ++i) {
            int[] coords;
            if (stack.m_41783_().m_128465_("sentry" + i).length <= 0 || (coords = stack.m_41783_().m_128465_("sentry" + i))[0] != x || coords[1] != y || coords[2] != z) continue;
            stack.m_41783_().m_128385_("sentry" + i, new int[]{0, 0, 0});
            SecurityCraft.channel.sendToServer((Object)new UpdateNBTTagOnServer(stack));
            return;
        }
    }

    private boolean isSentryVisibleToPlayer(BlockPos sentryPos) {
        LocalPlayer player = Minecraft.m_91087_().f_91074_;
        double xDistance = player.m_20185_() - (double)sentryPos.m_123341_();
        double zDistance = player.m_20189_() - (double)sentryPos.m_123343_();
        int trackingRange = Math.min(256, this.viewDistance) - 1;
        return xDistance >= (double)(-trackingRange) && xDistance <= (double)trackingRange && zDistance >= (double)(-trackingRange) && zDistance <= (double)trackingRange;
    }

    public boolean m_7043_() {
        return false;
    }

    public boolean m_7933_(int keyCode, int scanCode, int modifiers) {
        if (this.f_96541_.f_91066_.f_92092_.isActiveAndMatches(InputConstants.m_84827_((int)keyCode, (int)scanCode))) {
            this.m_7861_();
            return true;
        }
        return super.m_7933_(keyCode, scanCode, modifiers);
    }
}

