/*
 * Decompiled with CFR 0.152.
 */
package net.geforcemods.securitycraft.screen;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.Tesselator;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import net.geforcemods.securitycraft.SCContent;
import net.geforcemods.securitycraft.api.ICustomizable;
import net.geforcemods.securitycraft.api.IExplosive;
import net.geforcemods.securitycraft.api.ILockable;
import net.geforcemods.securitycraft.api.IModuleInventory;
import net.geforcemods.securitycraft.api.IOwnable;
import net.geforcemods.securitycraft.api.IPasswordProtected;
import net.geforcemods.securitycraft.api.IViewActivated;
import net.geforcemods.securitycraft.api.Option;
import net.geforcemods.securitycraft.items.SCManualItem;
import net.geforcemods.securitycraft.misc.ModuleType;
import net.geforcemods.securitycraft.misc.SCManualPage;
import net.geforcemods.securitycraft.screen.components.HoverChecker;
import net.geforcemods.securitycraft.screen.components.IdButton;
import net.geforcemods.securitycraft.screen.components.IngredientDisplay;
import net.geforcemods.securitycraft.screen.components.TextHoverChecker;
import net.geforcemods.securitycraft.util.Utils;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.narration.NarratableEntry;
import net.minecraft.client.gui.narration.NarrationElementOutput;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.resources.language.I18n;
import net.minecraft.core.BlockPos;
import net.minecraft.core.NonNullList;
import net.minecraft.network.chat.ClickEvent;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.Style;
import net.minecraft.network.chat.TextComponent;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.FormattedCharSequence;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.ShapedRecipe;
import net.minecraft.world.item.crafting.ShapelessRecipe;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.EntityBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.client.gui.ScrollPanel;
import net.minecraftforge.fml.loading.FMLEnvironment;

@OnlyIn(value=Dist.CLIENT)
public class SCManualScreen
extends Screen {
    private ResourceLocation infoBookTexture = new ResourceLocation("securitycraft:textures/gui/info_book_texture.png");
    private ResourceLocation infoBookTextureSpecial = new ResourceLocation("securitycraft:textures/gui/info_book_texture_special.png");
    private ResourceLocation infoBookTitlePage = new ResourceLocation("securitycraft:textures/gui/info_book_title_page.png");
    private ResourceLocation infoBookIcons = new ResourceLocation("securitycraft:textures/gui/info_book_icons.png");
    private static ResourceLocation bookGuiTextures = new ResourceLocation("textures/gui/book.png");
    private List<HoverChecker> hoverCheckers = new ArrayList<HoverChecker>();
    private static int lastPage = -1;
    private int currentPage = lastPage;
    private NonNullList<Ingredient> recipe;
    private IngredientDisplay[] displays = new IngredientDisplay[9];
    private int startX = -1;
    private List<FormattedText> subpages = new ArrayList<FormattedText>();
    private List<FormattedCharSequence> author = new ArrayList<FormattedCharSequence>();
    private int currentSubpage = 0;
    private final int subpageLength = 1285;
    private final MutableComponent intro1 = Utils.localize("gui.securitycraft:scManual.intro.1", new Object[0]).m_6270_(Style.f_131099_.setUnderlined(Boolean.valueOf(true)));
    private final TranslatableComponent ourPatrons = Utils.localize("gui.securitycraft:scManual.patreon.title", new Object[0]);
    private List<FormattedCharSequence> intro2;
    private PatronList patronList;
    private Button patreonLinkButton;
    private Button nextSubpage;
    private Button previousSubpage;
    private boolean explosive;
    private boolean ownable;
    private boolean passwordProtected;
    private boolean viewActivated;
    private boolean customizable;
    private boolean lockable;
    private boolean moduleInventory;
    private ItemStack pageStack;
    private final TranslatableComponent reinforcedText = Utils.localize("gui.securitycraft:scManual.reinforced", new Object[0]);
    private TranslatableComponent pageTitle;
    private TranslatableComponent designedBy;

    public SCManualScreen() {
        super((Component)new TranslatableComponent(((Item)SCContent.SC_MANUAL.get()).m_5524_()));
    }

    public void m_7856_() {
        int startY = 2;
        this.startX = (this.f_96543_ - 256) / 2;
        this.f_96541_.f_91068_.m_90926_(true);
        this.m_142416_((GuiEventListener)new ChangePageButton(1, this.startX + 210, startY + 188, true, this::actionPerformed));
        this.m_142416_((GuiEventListener)new ChangePageButton(2, this.startX + 16, startY + 188, false, this::actionPerformed));
        this.nextSubpage = new ChangePageButton(3, this.startX + 180, startY + 97, true, this::actionPerformed);
        this.m_142416_((GuiEventListener)this.nextSubpage);
        this.previousSubpage = new ChangePageButton(4, this.startX + 155, startY + 97, false, this::actionPerformed);
        this.m_142416_((GuiEventListener)this.previousSubpage);
        this.patreonLinkButton = new HyperlinkButton(this.startX + 225, 143, 16, 16, TextComponent.f_131282_, b -> this.m_5561_(Style.f_131099_.m_131142_(new ClickEvent(ClickEvent.Action.OPEN_URL, "https://www.patreon.com/Geforce"))));
        this.m_142416_((GuiEventListener)this.patreonLinkButton);
        this.patronList = new PatronList(this.f_96541_, 115, 90, 50, this.startX + 125);
        this.m_142416_((GuiEventListener)this.patronList);
        for (int i = 0; i < 3; ++i) {
            for (int j = 0; j < 3; ++j) {
                this.displays[i * 3 + j] = new IngredientDisplay(this.startX + 101 + j * 19, 144 + i * 19);
            }
        }
        this.updateRecipeAndIcons();
        SCManualItem.PAGES.sort((page1, page2) -> {
            String key1 = Utils.localize(page1.item().m_5524_(), new Object[0]).getString();
            String key2 = Utils.localize(page2.item().m_5524_(), new Object[0]).getString();
            return key1.compareTo(key2);
        });
    }

    public void m_6305_(PoseStack pose, int mouseX, int mouseY, float partialTicks) {
        this.m_7333_(pose);
        RenderSystem.m_157429_((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        if (this.currentPage == -1) {
            RenderSystem.m_157179_((int)0, (ResourceLocation)this.infoBookTitlePage);
        } else if (this.recipe != null && this.recipe.size() > 0) {
            RenderSystem.m_157179_((int)0, (ResourceLocation)this.infoBookTexture);
        } else {
            RenderSystem.m_157179_((int)0, (ResourceLocation)this.infoBookTextureSpecial);
        }
        this.m_93228_(pose, this.startX, 5, 0, 0, 256, 250);
        for (IngredientDisplay[] widget : this.f_169369_) {
            widget.m_6305_(pose, mouseX, mouseY, partialTicks);
        }
        if (this.currentPage > -1) {
            pageNumberText = this.currentPage + 2 + "/" + (SCManualItem.PAGES.size() + 1);
            if (this.subpages.size() > 1) {
                this.f_96547_.m_92883_(pose, this.currentSubpage + 1 + "/" + this.subpages.size(), (float)(this.startX + 205), 102.0f, 9339504);
            }
            if (this.designedBy != null) {
                this.f_96547_.m_92857_((FormattedText)this.designedBy, this.startX + 18, 150, 75, 0);
            }
            this.f_96547_.m_92889_(pose, (Component)this.pageTitle, (float)(this.startX + 39), 27.0f, 0);
            this.f_96547_.m_92857_(this.subpages.get(this.currentSubpage), this.startX + 18, 45, 225, 0);
            this.f_96547_.m_92883_(pose, pageNumberText, (float)(this.startX + 240 - this.f_96547_.m_92895_(pageNumberText)), 182.0f, 9339504);
            this.f_96541_.m_91291_().m_115203_(this.pageStack, this.startX + 19, 22);
            RenderSystem.m_157179_((int)0, (ResourceLocation)this.infoBookIcons);
            if (this.ownable) {
                this.m_93228_(pose, this.startX + 29, 118, 1, 1, 16, 16);
            }
            if (this.passwordProtected) {
                this.m_93228_(pose, this.startX + 55, 118, 18, 1, 17, 16);
            }
            if (this.viewActivated) {
                this.m_93228_(pose, this.startX + 81, 118, 36, 1, 17, 16);
            }
            if (this.explosive) {
                this.m_93228_(pose, this.startX + 107, 117, 54, 1, 18, 18);
            }
            if (this.customizable) {
                this.m_93228_(pose, this.startX + 136, 118, 88, 1, 16, 16);
            }
            if (this.moduleInventory) {
                this.m_93228_(pose, this.startX + 163, 118, 105, 1, 16, 16);
            }
            if (this.lockable) {
                this.m_93228_(pose, this.startX + 189, 118, 154, 1, 16, 16);
            }
            if (this.customizable || this.moduleInventory) {
                this.m_93228_(pose, this.startX + 213, 118, 72, 1, 16, 16);
            }
            for (IngredientDisplay display : this.displays) {
                display.render(this.f_96541_, partialTicks);
            }
            for (int i = 0; i < this.hoverCheckers.size(); ++i) {
                TextHoverChecker thc;
                HoverChecker chc = this.hoverCheckers.get(i);
                if (chc == null || !chc.checkHover(mouseX, mouseY)) continue;
                if (chc instanceof TextHoverChecker && (thc = (TextHoverChecker)chc).getName() != null) {
                    this.m_96597_(pose, thc.getLines(), mouseX, mouseY);
                    continue;
                }
                if (i >= this.displays.length || this.displays[i].getCurrentStack().m_41619_()) continue;
                this.m_6057_(pose, this.displays[i].getCurrentStack(), mouseX, mouseY);
            }
        } else {
            FormattedCharSequence text;
            int i;
            pageNumberText = "1/" + (SCManualItem.PAGES.size() + 1);
            this.f_96547_.m_92889_(pose, (Component)this.intro1, (float)(this.f_96543_ / 2 - this.f_96547_.m_92852_((FormattedText)this.intro1) / 2), 22.0f, 0);
            for (i = 0; i < this.intro2.size(); ++i) {
                text = this.intro2.get(i);
                this.f_96547_.m_92877_(pose, text, (float)(this.f_96543_ / 2 - this.f_96547_.m_92724_(text) / 2), (float)(150 + 10 * i), 0);
            }
            for (i = 0; i < this.author.size(); ++i) {
                text = this.author.get(i);
                this.f_96547_.m_92877_(pose, text, (float)(this.f_96543_ / 2 - this.f_96547_.m_92724_(text) / 2), (float)(180 + 10 * i), 0);
            }
            this.f_96547_.m_92883_(pose, pageNumberText, (float)(this.startX + 240 - this.f_96547_.m_92895_(pageNumberText)), 182.0f, 9339504);
            this.f_96547_.m_92889_(pose, (Component)this.ourPatrons, (float)(this.f_96543_ / 2 - this.f_96547_.m_92852_((FormattedText)this.ourPatrons) / 2 + 30), 40.0f, 0);
        }
    }

    public void m_7861_() {
        super.m_7861_();
        lastPage = this.currentPage;
        this.f_96541_.f_91068_.m_90926_(false);
    }

    public boolean m_5534_(char typedChar, int keyCode) {
        if (keyCode == 263) {
            this.previousSubpage();
        } else if (keyCode == 262) {
            this.nextSubpage();
        }
        return super.m_5534_(typedChar, keyCode);
    }

    protected void actionPerformed(IdButton button) {
        if (button.id == 1) {
            this.nextPage();
        } else if (button.id == 2) {
            this.previousPage();
        } else if (button.id == 3) {
            this.nextSubpage();
        } else if (button.id == 4) {
            this.previousSubpage();
        }
        this.nextSubpage.f_93624_ = this.currentPage != -1 && this.subpages.size() > 1;
        this.previousSubpage.f_93624_ = this.currentPage != -1 && this.subpages.size() > 1;
    }

    public boolean m_6050_(double mouseX, double mouseY, double scroll) {
        super.m_6050_(mouseX, mouseY, scroll);
        if (this.currentPage == -1 && this.patronList != null && this.patronList.m_5953_(mouseX, mouseY) && !this.patronList.patrons.isEmpty()) {
            this.patronList.m_6050_(mouseX, mouseY, scroll);
            return true;
        }
        switch ((int)Math.signum(scroll)) {
            case -1: {
                this.nextPage();
                break;
            }
            case 1: {
                this.previousPage();
            }
        }
        this.nextSubpage.f_93624_ = this.currentPage != -1 && this.subpages.size() > 1;
        this.previousSubpage.f_93624_ = this.currentPage != -1 && this.subpages.size() > 1;
        return true;
    }

    private void nextPage() {
        ++this.currentPage;
        if (this.currentPage > SCManualItem.PAGES.size() - 1) {
            this.currentPage = -1;
        }
        this.updateRecipeAndIcons();
    }

    private void previousPage() {
        --this.currentPage;
        if (this.currentPage < -1) {
            this.currentPage = SCManualItem.PAGES.size() - 1;
        }
        this.updateRecipeAndIcons();
    }

    private void nextSubpage() {
        ++this.currentSubpage;
        if (this.currentSubpage == this.subpages.size()) {
            this.currentSubpage = 0;
        }
    }

    private void previousSubpage() {
        --this.currentSubpage;
        if (this.currentSubpage == -1) {
            this.currentSubpage = this.subpages.size() - 1;
        }
    }

    private void updateRecipeAndIcons() {
        TranslatableComponent helpInfo;
        boolean reinforcedPage;
        this.currentSubpage = 0;
        this.hoverCheckers.clear();
        boolean bl = this.patreonLinkButton.f_93624_ = this.currentPage == -1;
        if (this.currentPage < 0) {
            this.recipe = null;
            this.nextSubpage.f_93624_ = false;
            this.previousSubpage.f_93624_ = false;
            if (I18n.m_118936_((String)"gui.securitycraft:scManual.author")) {
                this.author = this.f_96547_.m_92923_((FormattedText)Utils.localize("gui.securitycraft:scManual.author", new Object[0]), 180);
            } else {
                this.author.clear();
            }
            this.intro2 = this.f_96547_.m_92923_((FormattedText)Utils.localize("gui.securitycraft:scManual.intro.2", new Object[0]), 225);
            this.patronList.fetchPatrons();
            return;
        }
        SCManualPage page = SCManualItem.PAGES.get(this.currentPage);
        String designedBy = page.designedBy();
        this.designedBy = designedBy != null && !designedBy.isEmpty() ? Utils.localize("gui.securitycraft:scManual.designedBy", designedBy) : null;
        this.recipe = null;
        for (Recipe object : Minecraft.m_91087_().f_91073_.m_7465_().m_44051_()) {
            ShapelessRecipe recipe;
            if (object instanceof ShapedRecipe) {
                ShapedRecipe recipe2 = (ShapedRecipe)object;
                if (recipe2.m_8043_().m_41619_() || recipe2.m_8043_().m_41720_() != page.item()) continue;
                NonNullList ingredients = recipe2.m_7527_();
                NonNullList recipeItems = NonNullList.m_122780_((int)9, (Object)Ingredient.f_43901_);
                for (int i = 0; i < ingredients.size(); ++i) {
                    recipeItems.set(this.getCraftMatrixPosition(i, recipe2.m_44220_(), recipe2.m_44221_()), (Object)((Ingredient)ingredients.get(i)));
                }
                this.recipe = recipeItems;
                break;
            }
            if (!(object instanceof ShapelessRecipe) || (recipe = (ShapelessRecipe)object).m_8043_().m_41619_() || recipe.m_8043_().m_41720_() != page.item() || recipe.m_6423_().m_135815_().endsWith("_reset")) continue;
            NonNullList recipeItems = NonNullList.m_122780_((int)recipe.m_7527_().size(), (Object)Ingredient.f_43901_);
            for (int i = 0; i < recipeItems.size(); ++i) {
                recipeItems.set(i, (Object)((Ingredient)recipe.m_7527_().get(i)));
            }
            this.recipe = recipeItems;
            break;
        }
        boolean bl2 = reinforcedPage = (helpInfo = page.helpInfo()).m_131328_().equals("help.securitycraft:reinforced.info") || helpInfo.m_131328_().contains("reinforced_hopper");
        if (page.hasRecipeDescription()) {
            String name = page.item().getRegistryName().m_135815_();
            this.hoverCheckers.add(new TextHoverChecker(144, 200, this.startX + 100, this.startX + 100 + 40 + 16, (Component)Utils.localize("gui.securitycraft:scManual.recipe." + name, new Object[0])));
        } else if (reinforcedPage) {
            this.recipe = null;
            this.hoverCheckers.add(new TextHoverChecker(144, 200, this.startX + 100, this.startX + 100 + 40 + 16, (Component)Utils.localize("gui.securitycraft:scManual.recipe.reinforced", new Object[0])));
        } else if (this.recipe != null) {
            for (int i = 0; i < 3; ++i) {
                for (int j = 0; j < 3; ++j) {
                    this.hoverCheckers.add(new HoverChecker(144 + i * 19, 144 + i * 19 + 16, this.startX + 101 + j * 19, this.startX + 101 + j * 19 + 16));
                }
            }
        } else {
            this.hoverCheckers.add(new TextHoverChecker(144, 200, this.startX + 100, this.startX + 100 + 40 + 16, (Component)Utils.localize("gui.securitycraft:scManual.disabled", new Object[0])));
        }
        Item item = page.item();
        this.pageTitle = page.helpInfo().m_131328_().equals("help.securitycraft:reinforced.info") ? this.reinforcedText : Utils.localize(item.m_5524_(), new Object[0]);
        this.pageStack = new ItemStack((ItemLike)item);
        this.resetBlockEntityInfo();
        if (item instanceof BlockItem) {
            Block block = ((BlockItem)item).m_40614_();
            this.explosive = block instanceof IExplosive;
            if (this.explosive) {
                this.hoverCheckers.add(new TextHoverChecker(118, 134, this.startX + 107, this.startX + 107 + 16, (Component)Utils.localize("gui.securitycraft:scManual.explosiveBlock", new Object[0])));
            }
            if (block.m_49966_().m_155947_()) {
                IModuleInventory moduleInv;
                ICustomizable customizableBe;
                BlockEntity te = ((EntityBlock)block).m_142194_(BlockPos.f_121853_, block.m_49966_());
                this.ownable = te instanceof IOwnable;
                if (this.ownable) {
                    this.hoverCheckers.add(new TextHoverChecker(118, 134, this.startX + 29, this.startX + 29 + 16, (Component)Utils.localize("gui.securitycraft:scManual.ownableBlock", new Object[0])));
                }
                if (this.passwordProtected = te instanceof IPasswordProtected) {
                    this.hoverCheckers.add(new TextHoverChecker(118, 134, this.startX + 55, this.startX + 55 + 16, (Component)Utils.localize("gui.securitycraft:scManual.passwordProtectedBlock", new Object[0])));
                }
                if (this.viewActivated = te instanceof IViewActivated) {
                    this.hoverCheckers.add(new TextHoverChecker(118, 134, this.startX + 81, this.startX + 81 + 16, (Component)Utils.localize("gui.securitycraft:scManual.viewActivatedBlock", new Object[0])));
                }
                if (te instanceof ICustomizable && (customizableBe = (ICustomizable)te).customOptions() != null && customizableBe.customOptions().length > 0) {
                    ArrayList<Component> display = new ArrayList<Component>();
                    this.customizable = true;
                    display.add((Component)Utils.localize("gui.securitycraft:scManual.options", new Object[0]));
                    display.add((Component)new TextComponent("---"));
                    for (Option<?> option : customizableBe.customOptions()) {
                        display.add((Component)new TextComponent("- ").m_7220_((Component)Utils.localize("option" + block.m_7705_().substring(5) + "." + option.getName() + ".description", new Object[0])));
                        display.add(TextComponent.f_131282_);
                    }
                    display.remove(display.size() - 1);
                    this.hoverCheckers.add(new TextHoverChecker(118, 134, this.startX + 136, this.startX + 136 + 16, display));
                }
                if (te instanceof IModuleInventory && (moduleInv = (IModuleInventory)te).acceptedModules() != null && moduleInv.acceptedModules().length > 0) {
                    ArrayList<Component> display = new ArrayList<Component>();
                    this.moduleInventory = true;
                    display.add((Component)Utils.localize("gui.securitycraft:scManual.modules", new Object[0]));
                    display.add((Component)new TextComponent("---"));
                    for (ModuleType moduleType : moduleInv.acceptedModules()) {
                        display.add((Component)new TextComponent("- ").m_7220_((Component)Utils.localize("module" + block.m_7705_().substring(5) + "." + moduleType.getItem().m_5524_().substring(5).replace("securitycraft.", "") + ".description", new Object[0])));
                        display.add(TextComponent.f_131282_);
                    }
                    display.remove(display.size() - 1);
                    this.hoverCheckers.add(new TextHoverChecker(118, 134, this.startX + 163, this.startX + 163 + 16, display));
                }
                if (this.lockable = te instanceof ILockable) {
                    this.hoverCheckers.add(new TextHoverChecker(118, 134, this.startX + 189, this.startX + 189 + 16, (Component)Utils.localize("gui.securitycraft:scManual.lockable", new Object[0])));
                }
                if (this.customizable || this.moduleInventory) {
                    this.hoverCheckers.add(new TextHoverChecker(118, 134, this.startX + 213, this.startX + 213 + 16, (Component)Utils.localize("gui.securitycraft:scManual.customizableBlock", new Object[0])));
                }
            }
        }
        if (this.recipe != null && this.recipe.size() > 0) {
            for (int i = 0; i < 3; ++i) {
                for (int j = 0; j < 3; ++j) {
                    int index = i * 3 + j;
                    if (index >= this.recipe.size()) {
                        this.displays[index].setIngredient(Ingredient.f_43901_);
                        continue;
                    }
                    this.displays[index].setIngredient((Ingredient)this.recipe.get(index));
                }
            }
        } else {
            for (IngredientDisplay display : this.displays) {
                display.setIngredient(Ingredient.f_43901_);
            }
        }
        this.subpages = this.f_96547_.m_92865_().m_92414_((FormattedText)helpInfo, 1285, Style.f_131099_);
        this.nextSubpage.f_93624_ = this.currentPage != -1 && this.subpages.size() > 1;
        this.previousSubpage.f_93624_ = this.currentPage != -1 && this.subpages.size() > 1;
    }

    private void resetBlockEntityInfo() {
        this.explosive = false;
        this.ownable = false;
        this.passwordProtected = false;
        this.viewActivated = false;
        this.customizable = false;
        this.lockable = false;
        this.moduleInventory = false;
    }

    public boolean m_6375_(double mouseX, double mouseY, int button) {
        if (this.patronList != null) {
            this.patronList.m_6375_(mouseX, mouseY, button);
        }
        return super.m_6375_(mouseX, mouseY, button);
    }

    public boolean m_6348_(double mouseX, double mouseY, int button) {
        if (this.patronList != null) {
            this.patronList.m_6348_(mouseX, mouseY, button);
        }
        return super.m_6348_(mouseX, mouseY, button);
    }

    public boolean m_7979_(double mouseX, double mouseY, int button, double deltaX, double deltaY) {
        if (this.patronList != null) {
            this.patronList.m_7979_(mouseX, mouseY, button, deltaX, deltaY);
        }
        return super.m_7979_(mouseX, mouseY, button, deltaX, deltaY);
    }

    private int getCraftMatrixPosition(int i, int width, int height) {
        int index;
        if (width == 1) {
            index = height == 3 ? i * 3 + 1 : (height == 2 ? i * 3 + 1 : 4);
        } else if (height == 1) {
            index = i + 3;
        } else if (width == 2) {
            index = i;
            if (i > 1) {
                ++index;
                if (i > 3) {
                    ++index;
                }
            }
        } else {
            index = height == 2 ? i + 3 : i;
        }
        return index;
    }

    static class ChangePageButton
    extends IdButton {
        private final int textureY;

        public ChangePageButton(int index, int xPos, int yPos, boolean forward, Consumer<IdButton> onClick) {
            super(index, xPos, yPos, 23, 13, "", onClick);
            this.textureY = forward ? 192 : 205;
        }

        public void m_6305_(PoseStack pose, int mouseX, int mouseY, float partialTicks) {
            if (this.f_93624_) {
                boolean isHovering = mouseX >= this.f_93620_ && mouseY >= this.f_93621_ && mouseX < this.f_93620_ + this.f_93618_ && mouseY < this.f_93621_ + this.f_93619_;
                RenderSystem.m_157429_((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
                RenderSystem.m_157179_((int)0, (ResourceLocation)bookGuiTextures);
                this.m_93228_(pose, this.f_93620_, this.f_93621_, isHovering ? 23 : 0, this.textureY, 23, 13);
            }
        }
    }

    class HyperlinkButton
    extends Button {
        public HyperlinkButton(int xPos, int yPos, int width, int height, Component displayString, Button.OnPress handler) {
            super(xPos, yPos, width, height, displayString, handler);
        }

        public void m_6303_(PoseStack pose, int mouseX, int mouseY, float partial) {
            RenderSystem.m_157179_((int)0, (ResourceLocation)SCManualScreen.this.infoBookIcons);
            boolean bl = this.f_93622_ = mouseX >= this.f_93620_ && mouseY >= this.f_93621_ && mouseX < this.f_93620_ + this.f_93618_ && mouseY < this.f_93621_ + this.f_93619_;
            if (this.f_93622_) {
                this.m_93228_(pose, this.f_93620_, this.f_93621_, 138, 1, 16, 16);
            } else {
                this.m_93228_(pose, this.f_93620_, this.f_93621_, 122, 1, 16, 16);
            }
        }
    }

    class PatronList
    extends ScrollPanel {
        private static final String PATRON_LIST_LINK = FMLEnvironment.production ? "https://gist.githubusercontent.com/bl4ckscor3/bdda6596012b1206816db034350b5717/raw" : "https://gist.githubusercontent.com/bl4ckscor3/3196e6740774e386871a74a9606eaa61/raw";
        private final int slotHeight = 12;
        private final ExecutorService executor;
        private Future<List<String>> patronRequestFuture;
        private List<String> patrons;
        private boolean patronsAvailable;
        private boolean error;
        private boolean patronsRequested;
        private final List<FormattedCharSequence> fetchErrorLines;
        private final List<FormattedCharSequence> noPatronsLines;
        private final Component loadingText;

        public PatronList(Minecraft client, int width, int height, int top, int left) {
            super(client, width, height, top, left, 4, 6, -1061176398, -792740942, -7437712, -8359851, -3031135);
            this.slotHeight = 12;
            this.executor = Executors.newSingleThreadExecutor();
            this.patrons = new ArrayList<String>();
            this.patronsAvailable = false;
            this.error = false;
            this.loadingText = Utils.localize("gui.securitycraft:scManual.patreon.loading", new Object[0]);
            this.fetchErrorLines = SCManualScreen.this.f_96547_.m_92923_((FormattedText)Utils.localize("gui.securitycraft:scManual.patreon.error", new Object[0]), width);
            this.noPatronsLines = SCManualScreen.this.f_96547_.m_92923_((FormattedText)Utils.localize("advancements.empty", new Object[0]), width - 10);
        }

        protected int getContentHeight() {
            int n = this.patrons.size();
            Objects.requireNonNull(SCManualScreen.this.f_96547_);
            int height = 50 + n * 9;
            if (height < this.bottom - this.top - 8) {
                height = this.bottom - this.top - 8;
            }
            return height;
        }

        public void m_6305_(PoseStack pose, int mouseX, int mouseY, float partialTicks) {
            if (SCManualScreen.this.currentPage == -1) {
                if (this.patronsAvailable) {
                    super.m_6305_(pose, mouseX, mouseY, partialTicks);
                    int mouseListY = (int)((float)(mouseY - this.top) + this.scrollDistance - (float)this.border);
                    int slotIndex = mouseListY / 12;
                    if (mouseX >= this.left && mouseX < this.right - 6 && slotIndex >= 0 && mouseListY >= 0 && slotIndex < this.patrons.size() && mouseY >= this.top && mouseY <= this.bottom) {
                        String patron = this.patrons.get(slotIndex);
                        int length = SCManualScreen.this.f_96547_.m_92895_(patron);
                        int baseY = this.top + this.border - (int)this.scrollDistance;
                        if (length >= this.width - 6) {
                            SCManualScreen.this.m_96602_(pose, (Component)new TextComponent(patron), this.left - 10, baseY + (12 * slotIndex + 12));
                        }
                    }
                    if (this.patrons.isEmpty()) {
                        for (int i = 0; i < this.noPatronsLines.size(); ++i) {
                            FormattedCharSequence line = this.noPatronsLines.get(i);
                            SCManualScreen.this.f_96547_.m_92877_(pose, line, (float)(this.left + this.width / 2 - SCManualScreen.this.f_96547_.m_92724_(line) / 2), (float)(this.top + 30 + i * 10), -13421773);
                        }
                    }
                } else if (this.error) {
                    for (int i = 0; i < this.fetchErrorLines.size(); ++i) {
                        FormattedCharSequence line = this.fetchErrorLines.get(i);
                        SCManualScreen.this.f_96547_.m_92877_(pose, line, (float)(this.left + this.width / 2 - SCManualScreen.this.f_96547_.m_92724_(line) / 2), (float)(this.top + 30 + i * 10), -5242623);
                    }
                } else if (this.patronRequestFuture != null && this.patronRequestFuture.isDone()) {
                    try {
                        this.patrons = this.patronRequestFuture.get();
                        this.executor.shutdown();
                        this.patronsAvailable = true;
                    }
                    catch (InterruptedException | ExecutionException e) {
                        this.error = true;
                    }
                } else {
                    SCManualScreen.this.f_96547_.m_92889_(pose, this.loadingText, (float)(this.left + this.width / 2 - SCManualScreen.this.f_96547_.m_92852_((FormattedText)this.loadingText) / 2), (float)(this.top + 30), 0);
                }
            }
        }

        protected void drawPanel(PoseStack pose, int entryRight, int relativeY, Tesselator tesselator, int mouseX, int mouseY) {
            for (int i = 0; i < this.patrons.size(); ++i) {
                String patron = this.patrons.get(i);
                if (patron == null || patron.isEmpty()) continue;
                SCManualScreen.this.f_96547_.m_92883_(pose, patron, (float)(this.left + 2), (float)(relativeY + 12 * i), 0);
            }
        }

        public void fetchPatrons() {
            if (!this.patronsRequested) {
                this.patronRequestFuture = this.executor.submit(() -> {
                    List list;
                    BufferedReader reader = new BufferedReader(new InputStreamReader(new URL(PATRON_LIST_LINK).openStream()));
                    try {
                        list = reader.lines().collect(Collectors.toList());
                    }
                    catch (Throwable throwable) {
                        try {
                            try {
                                reader.close();
                            }
                            catch (Throwable throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                            throw throwable;
                        }
                        catch (IOException e) {
                            this.error = true;
                            return new ArrayList();
                        }
                    }
                    reader.close();
                    return list;
                });
                this.patronsRequested = true;
            }
        }

        public NarratableEntry.NarrationPriority m_142684_() {
            return NarratableEntry.NarrationPriority.NONE;
        }

        public void m_142291_(NarrationElementOutput narrationElementOutput) {
        }
    }
}

