/*
 * Decompiled with CFR 0.152.
 */
package net.geforcemods.securitycraft.screen;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import java.util.Arrays;
import net.geforcemods.securitycraft.SecurityCraft;
import net.geforcemods.securitycraft.blockentities.ProjectorBlockEntity;
import net.geforcemods.securitycraft.inventory.ProjectorMenu;
import net.geforcemods.securitycraft.network.server.SyncProjector;
import net.geforcemods.securitycraft.screen.components.NamedSlider;
import net.geforcemods.securitycraft.screen.components.TextHoverChecker;
import net.geforcemods.securitycraft.screen.components.TogglePictureButton;
import net.geforcemods.securitycraft.util.Utils;
import net.minecraft.client.gui.components.AbstractWidget;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.inventory.AbstractContainerScreen;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.TextComponent;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class ProjectorScreen
extends AbstractContainerScreen<ProjectorMenu> {
    private static final ResourceLocation TEXTURE = new ResourceLocation("securitycraft:textures/gui/container/projector.png");
    private static final TranslatableComponent SLOT_TOOLTIP = Utils.localize("gui.securitycraft:projector.block", new Object[0]);
    private ProjectorBlockEntity be;
    private TranslatableComponent blockName;
    private TextHoverChecker[] hoverCheckers = new TextHoverChecker[5];
    private TextHoverChecker slotHoverChecker;
    private NamedSlider projectionWidthSlider;
    private NamedSlider projectionHeightSlider;
    private NamedSlider projectionRangeSlider;
    private NamedSlider projectionOffsetSlider;
    private TogglePictureButton toggleButton;
    private int sliderWidth = 120;

    public ProjectorScreen(ProjectorMenu menu, Inventory inv, Component text) {
        super((AbstractContainerMenu)menu, inv, text);
        this.be = menu.be;
        this.blockName = Utils.localize(this.be.m_58900_().m_60734_().m_7705_(), new Object[0]);
        this.f_97727_ = 225;
    }

    public void m_7856_() {
        super.m_7856_();
        int id = 0;
        int left = this.f_97735_ + (this.f_97726_ - this.sliderWidth) / 2;
        this.projectionWidthSlider = (NamedSlider)this.m_142416_((GuiEventListener)new NamedSlider((Component)Utils.localize("gui.securitycraft:projector.width", this.be.getProjectionWidth()), (Component)this.blockName, id, left, this.f_97736_ + 47, this.sliderWidth, 20, (Component)Utils.localize("gui.securitycraft:projector.width", ""), "", 1, 10, this.be.getProjectionWidth(), false, true, null, this::sliderReleased));
        this.projectionWidthSlider.setFGColor(0xE0E0E0);
        this.hoverCheckers[id++] = new TextHoverChecker((AbstractWidget)this.projectionWidthSlider, (Component)Utils.localize("gui.securitycraft:projector.width.description", new Object[0]));
        this.projectionHeightSlider = (NamedSlider)this.m_142416_((GuiEventListener)new NamedSlider((Component)Utils.localize("gui.securitycraft:projector.height", this.be.getProjectionHeight()), (Component)this.blockName, id, left, this.f_97736_ + 68, this.sliderWidth, 20, (Component)Utils.localize("gui.securitycraft:projector.height", ""), "", 1, 10, this.be.getProjectionHeight(), false, true, null, this::sliderReleased));
        this.projectionHeightSlider.setFGColor(0xE0E0E0);
        this.hoverCheckers[id++] = new TextHoverChecker((AbstractWidget)this.projectionHeightSlider, (Component)Utils.localize("gui.securitycraft:projector.height.description", new Object[0]));
        this.projectionRangeSlider = (NamedSlider)this.m_142416_((GuiEventListener)new NamedSlider((Component)Utils.localize("gui.securitycraft:projector.range", this.be.getProjectionRange()), (Component)this.blockName, id, left, this.f_97736_ + 89, this.sliderWidth, 20, (Component)Utils.localize("gui.securitycraft:projector.range", ""), "", 1, 30, this.be.getProjectionRange(), false, true, slider -> {
            if (this.be.isHorizontal()) {
                slider.m_93666_((Component)new TextComponent("").m_7220_(slider.dispString).m_130946_(Integer.toString((int)Math.round(slider.sliderValue * (slider.maxValue - slider.minValue) + slider.minValue) - 16)));
            }
        }, this::sliderReleased));
        this.projectionRangeSlider.setFGColor(0xE0E0E0);
        this.hoverCheckers[id++] = new TextHoverChecker((AbstractWidget)this.projectionRangeSlider, (Component)Utils.localize("gui.securitycraft:projector.range.description", new Object[0]));
        this.projectionOffsetSlider = (NamedSlider)this.m_142416_((GuiEventListener)new NamedSlider((Component)Utils.localize("gui.securitycraft:projector.offset", this.be.getProjectionOffset()), (Component)this.blockName, id, left, this.f_97736_ + 110, this.sliderWidth, 20, (Component)Utils.localize("gui.securitycraft:projector.offset", ""), "", -10, 10, this.be.getProjectionOffset(), false, true, null, this::sliderReleased));
        this.projectionOffsetSlider.setFGColor(0xE0E0E0);
        this.hoverCheckers[id++] = new TextHoverChecker((AbstractWidget)this.projectionOffsetSlider, (Component)Utils.localize("gui.securitycraft:projector.offset.description", new Object[0]));
        this.toggleButton = (TogglePictureButton)this.m_142416_((GuiEventListener)new TogglePictureButton(id, left, this.f_97736_ + 26, 20, 20, TEXTURE, new int[]{176, 192}, new int[]{0, 0}, 2, 2, b -> {
            this.be.setHorizontal(!this.be.isHorizontal());
            this.projectionRangeSlider.updateSlider();
            SecurityCraft.channel.sendToServer((Object)new SyncProjector(this.be.m_58899_(), this.be.isHorizontal() ? 1 : 0, SyncProjector.DataType.HORIZONTAL));
        }));
        this.toggleButton.setCurrentIndex(this.be.isHorizontal() ? 1 : 0);
        this.hoverCheckers[id++] = new TextHoverChecker((AbstractWidget)this.toggleButton, Arrays.asList(Utils.localize("gui.securitycraft:projector.vertical", new Object[0]), Utils.localize("gui.securitycraft:projector.horizontal", new Object[0])));
        this.projectionRangeSlider.updateSlider();
        this.slotHoverChecker = new TextHoverChecker(this.f_97736_ + 22, this.f_97736_ + 39, this.f_97735_ + 78, this.f_97735_ + 95, (Component)SLOT_TOOLTIP);
    }

    public void m_6305_(PoseStack pose, int mouseX, int mouseY, float partialTicks) {
        super.m_6305_(pose, mouseX, mouseY, partialTicks);
        this.m_7025_(pose, mouseX, mouseY);
        for (TextHoverChecker thc : this.hoverCheckers) {
            if (!thc.checkHover(mouseX, mouseY)) continue;
            this.m_96602_(pose, thc.getName(), mouseX, mouseY);
        }
        if (this.slotHoverChecker.checkHover(mouseX, mouseY) && ((ProjectorMenu)this.f_97732_).be.m_7983_()) {
            this.m_96602_(pose, this.slotHoverChecker.getName(), mouseX, mouseY);
        }
    }

    protected void m_7027_(PoseStack pose, int mouseX, int mouseY) {
        this.f_96547_.m_92889_(pose, (Component)this.blockName, (float)(this.f_97726_ / 2 - this.f_96547_.m_92852_((FormattedText)this.blockName) / 2), 6.0f, 0x404040);
    }

    protected void m_7286_(PoseStack pose, float partialTicks, int mouseX, int mouseY) {
        int startX = (this.f_96543_ - this.f_97726_) / 2;
        int startY = (this.f_96544_ - this.f_97727_) / 2;
        this.m_7333_(pose);
        RenderSystem.m_157429_((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        RenderSystem.m_157179_((int)0, (ResourceLocation)TEXTURE);
        this.m_93228_(pose, startX, startY, 0, 0, this.f_97726_, this.f_97727_);
    }

    public boolean m_6348_(double mouseX, double mouseY, int button) {
        if (this.projectionWidthSlider.dragging) {
            this.projectionWidthSlider.m_6348_(mouseX, mouseY, button);
        }
        if (this.projectionHeightSlider.dragging) {
            this.projectionWidthSlider.m_6348_(mouseX, mouseY, button);
        }
        if (this.projectionRangeSlider.dragging) {
            this.projectionRangeSlider.m_6348_(mouseX, mouseY, button);
        }
        if (this.projectionOffsetSlider.dragging) {
            this.projectionOffsetSlider.m_6348_(mouseX, mouseY, button);
        }
        return super.m_6348_(mouseX, mouseY, button);
    }

    public void sliderReleased(NamedSlider slider) {
        int data = 0;
        SyncProjector.DataType dataType = SyncProjector.DataType.INVALID;
        if (slider.id == this.projectionWidthSlider.id) {
            data = slider.getValueInt();
            this.be.setProjectionWidth(data);
            dataType = SyncProjector.DataType.WIDTH;
        } else if (slider.id == this.projectionHeightSlider.id) {
            data = slider.getValueInt();
            this.be.setProjectionHeight(data);
            dataType = SyncProjector.DataType.HEIGHT;
        } else if (slider.id == this.projectionRangeSlider.id) {
            data = slider.getValueInt();
            this.be.setProjectionRange(data);
            dataType = SyncProjector.DataType.RANGE;
        } else if (slider.id == this.projectionOffsetSlider.id) {
            data = slider.getValueInt();
            this.be.setProjectionOffset(data);
            dataType = SyncProjector.DataType.OFFSET;
        }
        SecurityCraft.channel.sendToServer((Object)new SyncProjector(this.be.m_58899_(), data, dataType));
    }
}

