/*
 * Decompiled with CFR 0.152.
 */
package net.geforcemods.securitycraft.renderers;

import com.google.common.collect.ImmutableMap;
import com.mojang.blaze3d.platform.NativeImage;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.math.Vector3f;
import java.util.List;
import java.util.Map;
import net.geforcemods.securitycraft.blockentities.SecretSignBlockEntity;
import net.geforcemods.securitycraft.blocks.SecretStandingSignBlock;
import net.geforcemods.securitycraft.blocks.SecretWallSignBlock;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.model.geom.EntityModelSet;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.Sheets;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderer;
import net.minecraft.client.renderer.blockentity.BlockEntityRendererProvider;
import net.minecraft.client.renderer.blockentity.SignRenderer;
import net.minecraft.client.resources.model.Material;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.util.FormattedCharSequence;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.block.state.properties.WoodType;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class SecretSignRenderer
implements BlockEntityRenderer<SecretSignBlockEntity> {
    public static final int MAX_LINE_WIDTH = 90;
    private static final int LINE_HEIGHT = 10;
    private static final int BLACK_TEXT_OUTLINE_COLOR = -988212;
    private static final int OUTLINE_RENDER_DISTANCE = Mth.m_144944_((int)16);
    private final Map<WoodType, SignRenderer.SignModel> signModels = (Map)WoodType.m_61843_().collect(ImmutableMap.toImmutableMap(woodType -> woodType, woodType -> SignRenderer.m_173646_((EntityModelSet)ctx.m_173585_(), (WoodType)woodType)));
    private final Font font;

    public SecretSignRenderer(BlockEntityRendererProvider.Context ctx) {
        this.font = ctx.m_173586_();
    }

    public void render(SecretSignBlockEntity be, float partialTicks, PoseStack pose, MultiBufferSource buffer, int combinedLight, int combinedOverlay) {
        BlockState state = be.m_58900_();
        WoodType woodType = SignRenderer.m_173637_((Block)state.m_60734_());
        SignRenderer.SignModel model = this.signModels.get(woodType);
        Material material = Sheets.m_173381_((WoodType)woodType);
        pose.m_85836_();
        if (state.m_60734_() instanceof SecretStandingSignBlock) {
            pose.m_85837_(0.5, 0.5, 0.5);
            pose.m_85845_(Vector3f.f_122225_.m_122240_(-((float)((Integer)state.m_61143_((Property)SecretStandingSignBlock.f_56987_) * 360) / 16.0f)));
            model.f_112507_.f_104207_ = true;
        } else {
            pose.m_85837_(0.5, 0.5, 0.5);
            pose.m_85845_(Vector3f.f_122225_.m_122240_(-((Direction)state.m_61143_((Property)SecretWallSignBlock.f_58064_)).m_122435_()));
            pose.m_85837_(0.0, -0.3125, -0.4375);
            model.f_112507_.f_104207_ = false;
        }
        pose.m_85836_();
        pose.m_85841_(0.6666667f, -0.6666667f, -0.6666667f);
        VertexConsumer builder = material.m_119194_(buffer, arg_0 -> ((SignRenderer.SignModel)model).m_103119_(arg_0));
        model.f_173655_.m_104301_(pose, builder, combinedLight, combinedOverlay);
        pose.m_85849_();
        pose.m_85837_(0.0, 0.3333333432674408, 0.046666666865348816);
        pose.m_85841_(0.010416667f, -0.010416667f, 0.010416667f);
        if (be.isPlayerAllowedToSeeText((Player)Minecraft.m_91087_().f_91074_)) {
            int packedLightCoords;
            boolean drawOutline;
            int textColor;
            int darkColor = SecretSignRenderer.getDarkColor(be);
            FormattedCharSequence[] text = be.m_155717_(Minecraft.m_91087_().m_167974_(), line -> {
                List list = this.font.m_92923_((FormattedText)line, 90);
                return list.isEmpty() ? FormattedCharSequence.f_13691_ : (FormattedCharSequence)list.get(0);
            });
            if (be.m_155727_()) {
                textColor = be.m_59753_().m_41071_();
                drawOutline = SecretSignRenderer.isOutlineVisible(be, textColor);
                packedLightCoords = 0xF000F0;
            } else {
                textColor = darkColor;
                drawOutline = false;
                packedLightCoords = combinedLight;
            }
            for (int lineIndex = 0; lineIndex < 4; ++lineIndex) {
                FormattedCharSequence line2 = text[lineIndex];
                float xPos = -this.font.m_92724_(line2) / 2;
                if (drawOutline) {
                    this.font.m_168645_(line2, xPos, (float)(lineIndex * 10 - 20), textColor, darkColor, pose.m_85850_().m_85861_(), buffer, packedLightCoords);
                    continue;
                }
                this.font.m_92733_(line2, xPos, (float)(lineIndex * 10 - 20), textColor, false, pose.m_85850_().m_85861_(), buffer, false, 0, packedLightCoords);
            }
        }
        pose.m_85849_();
    }

    private static boolean isOutlineVisible(SecretSignBlockEntity be, int textColor) {
        if (textColor == DyeColor.BLACK.m_41071_()) {
            return true;
        }
        Minecraft mc = Minecraft.m_91087_();
        LocalPlayer player = mc.f_91074_;
        if (player != null && mc.f_91066_.m_92176_().m_90612_() && player.m_150108_()) {
            return true;
        }
        Entity entity = mc.m_91288_();
        return entity != null && entity.m_20238_(Vec3.m_82512_((Vec3i)be.m_58899_())) < (double)OUTLINE_RENDER_DISTANCE;
    }

    private static int getDarkColor(SecretSignBlockEntity be) {
        int textColor = be.m_59753_().m_41071_();
        int r = (int)((double)NativeImage.m_85085_((int)textColor) * 0.4);
        int g = (int)((double)NativeImage.m_85103_((int)textColor) * 0.4);
        int b = (int)((double)NativeImage.m_85119_((int)textColor) * 0.4);
        return textColor == DyeColor.BLACK.m_41071_() && be.m_155727_() ? -988212 : NativeImage.m_84992_((int)0, (int)b, (int)g, (int)r);
    }
}

