/*
 * Decompiled with CFR 0.152.
 */
package net.geforcemods.securitycraft.network.server;

import java.util.function.Supplier;
import net.geforcemods.securitycraft.api.CustomizableBlockEntity;
import net.geforcemods.securitycraft.api.ICustomizable;
import net.geforcemods.securitycraft.api.IOwnable;
import net.geforcemods.securitycraft.api.Option;
import net.minecraft.core.BlockPos;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraftforge.network.NetworkEvent;

public class UpdateSliderValue {
    private BlockPos pos;
    private int id;
    private double value;

    public UpdateSliderValue() {
    }

    public UpdateSliderValue(BlockPos pos, int id, double v) {
        this.pos = pos;
        this.id = id;
        this.value = v;
    }

    public static void encode(UpdateSliderValue message, FriendlyByteBuf buf) {
        buf.m_130064_(message.pos);
        buf.writeInt(message.id);
        buf.writeDouble(message.value);
    }

    public static UpdateSliderValue decode(FriendlyByteBuf buf) {
        UpdateSliderValue message = new UpdateSliderValue();
        message.pos = buf.m_130135_();
        message.id = buf.readInt();
        message.value = buf.readDouble();
        return message;
    }

    public static void onMessage(UpdateSliderValue message, Supplier<NetworkEvent.Context> ctx) {
        ctx.get().enqueueWork(() -> {
            BlockPos pos = message.pos;
            int id = message.id;
            double value = message.value;
            ServerPlayer player = ((NetworkEvent.Context)ctx.get()).getSender();
            BlockEntity be = player.f_19853_.m_7702_(pos);
            if (be instanceof ICustomizable) {
                IOwnable ownable;
                ICustomizable customizable = (ICustomizable)be;
                if (!(be instanceof IOwnable) || (ownable = (IOwnable)be).getOwner().isOwner((Player)player)) {
                    Option<?> option = customizable.customOptions()[id];
                    if (option instanceof Option.DoubleOption) {
                        Option.DoubleOption o = (Option.DoubleOption)option;
                        o.setValue(value);
                    } else if (option instanceof Option.IntOption) {
                        Option.IntOption o = (Option.IntOption)option;
                        o.setValue((int)value);
                    }
                    customizable.onOptionChanged(customizable.customOptions()[id]);
                    if (be instanceof CustomizableBlockEntity) {
                        player.f_19853_.m_7260_(pos, be.m_58900_(), be.m_58900_(), 3);
                    }
                }
            }
        });
        ctx.get().setPacketHandled(true);
    }
}

