/*
 * Decompiled with CFR 0.152.
 */
package net.geforcemods.securitycraft.network.server;

import java.util.function.Supplier;
import net.geforcemods.securitycraft.blockentities.ProjectorBlockEntity;
import net.minecraft.core.BlockPos;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.network.NetworkEvent;

public class SyncProjector {
    private BlockPos pos;
    private int data;
    private DataType dataType;

    public SyncProjector() {
    }

    public SyncProjector(BlockPos pos, int data, DataType dataType) {
        this.pos = pos;
        this.data = data;
        this.dataType = dataType;
    }

    public static void encode(SyncProjector message, FriendlyByteBuf buf) {
        buf.m_130064_(message.pos);
        buf.m_130068_((Enum)message.dataType);
        if (message.dataType == DataType.HORIZONTAL) {
            buf.writeBoolean(message.data == 1);
        } else {
            buf.m_130130_(message.data);
        }
    }

    public static SyncProjector decode(FriendlyByteBuf buf) {
        SyncProjector message = new SyncProjector();
        message.pos = buf.m_130135_();
        message.dataType = (DataType)buf.m_130066_(DataType.class);
        message.data = message.dataType == DataType.HORIZONTAL ? (buf.readBoolean() ? 1 : 0) : buf.m_130242_();
        return message;
    }

    public static void onMessage(SyncProjector message, Supplier<NetworkEvent.Context> ctx) {
        ctx.get().enqueueWork(() -> {
            ProjectorBlockEntity be;
            BlockEntity patt1674$temp;
            BlockPos pos = message.pos;
            ServerPlayer player = ((NetworkEvent.Context)ctx.get()).getSender();
            Level level = player.f_19853_;
            if (level.m_46749_(pos) && (patt1674$temp = level.m_7702_(pos)) instanceof ProjectorBlockEntity && (be = (ProjectorBlockEntity)patt1674$temp).getOwner().isOwner((Player)player)) {
                BlockState state = level.m_8055_(pos);
                switch (message.dataType) {
                    case WIDTH: {
                        be.setProjectionWidth(message.data);
                        break;
                    }
                    case HEIGHT: {
                        be.setProjectionHeight(message.data);
                        break;
                    }
                    case RANGE: {
                        be.setProjectionRange(message.data);
                        break;
                    }
                    case OFFSET: {
                        be.setProjectionOffset(message.data);
                        break;
                    }
                    case HORIZONTAL: {
                        be.setHorizontal(message.data == 1);
                        break;
                    }
                }
                level.m_7260_(pos, state, state, 2);
            }
        });
        ctx.get().setPacketHandled(true);
    }

    public static enum DataType {
        WIDTH,
        HEIGHT,
        RANGE,
        OFFSET,
        HORIZONTAL,
        INVALID;

    }
}

