/*
 * Decompiled with CFR 0.152.
 */
package net.geforcemods.securitycraft.network.client;

import java.util.function.Supplier;
import net.geforcemods.securitycraft.ClientHandler;
import net.geforcemods.securitycraft.entity.camera.CameraController;
import net.geforcemods.securitycraft.entity.camera.SecurityCamera;
import net.geforcemods.securitycraft.util.Utils;
import net.minecraft.client.CameraType;
import net.minecraft.client.Minecraft;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraftforge.client.gui.ForgeIngameGui;
import net.minecraftforge.client.gui.IIngameOverlay;
import net.minecraftforge.client.gui.OverlayRegistry;
import net.minecraftforge.network.NetworkEvent;

public class SetCameraView {
    private int id;

    public SetCameraView() {
    }

    public SetCameraView(Entity camera) {
        this.id = camera.m_142049_();
    }

    public static void encode(SetCameraView message, FriendlyByteBuf buf) {
        buf.m_130130_(message.id);
    }

    public static SetCameraView decode(FriendlyByteBuf buf) {
        SetCameraView message = new SetCameraView();
        message.id = buf.m_130242_();
        return message;
    }

    public static void onMessage(SetCameraView message, Supplier<NetworkEvent.Context> ctx) {
        ctx.get().enqueueWork(() -> {
            Minecraft mc = Minecraft.m_91087_();
            Entity entity = mc.f_91073_.m_6815_(message.id);
            boolean isCamera = entity instanceof SecurityCamera;
            if (isCamera || entity instanceof Player) {
                mc.m_91118_(entity);
                if (isCamera) {
                    CameraController.previousCameraType = mc.f_91066_.m_92176_();
                    mc.f_91066_.m_92157_(CameraType.FIRST_PERSON);
                    mc.f_91065_.m_93063_((Component)Utils.localize("mount.onboard", mc.f_91066_.f_92090_.m_90863_()), false);
                    CameraController.setRenderPosition(entity);
                } else if (CameraController.previousCameraType != null) {
                    mc.f_91066_.m_92157_(CameraController.previousCameraType);
                }
                mc.f_91060_.m_109818_();
                OverlayRegistry.enableOverlay((IIngameOverlay)ForgeIngameGui.EXPERIENCE_BAR_ELEMENT, (!isCamera ? 1 : 0) != 0);
                OverlayRegistry.enableOverlay((IIngameOverlay)ForgeIngameGui.JUMP_BAR_ELEMENT, (!isCamera ? 1 : 0) != 0);
                OverlayRegistry.enableOverlay((IIngameOverlay)ForgeIngameGui.POTION_ICONS_ELEMENT, (!isCamera ? 1 : 0) != 0);
                OverlayRegistry.enableOverlay((IIngameOverlay)ClientHandler.cameraOverlay, (boolean)isCamera);
                OverlayRegistry.enableOverlay((IIngameOverlay)ClientHandler.hotbarBindOverlay, (!isCamera ? 1 : 0) != 0);
            }
        });
        ctx.get().setPacketHandled(true);
    }
}

