/*
 * Decompiled with CFR 0.152.
 */
package net.geforcemods.securitycraft.models;

import com.google.common.collect.ImmutableList;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import net.geforcemods.securitycraft.entity.camera.SecurityCamera;
import net.minecraft.client.model.EntityModel;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.model.geom.PartPose;
import net.minecraft.client.model.geom.builders.CubeListBuilder;
import net.minecraft.client.model.geom.builders.LayerDefinition;
import net.minecraft.client.model.geom.builders.MeshDefinition;
import net.minecraft.client.model.geom.builders.PartDefinition;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class SecurityCameraModel
extends EntityModel<SecurityCamera> {
    public ModelPart shape1;
    public ModelPart shape2;
    public ModelPart cameraRotationPoint;
    private final ImmutableList<ModelPart> partList;

    public SecurityCameraModel(ModelPart modelPart) {
        this.shape1 = modelPart.m_171324_("shape1");
        this.shape2 = modelPart.m_171324_("shape2");
        this.setRotateAngle(this.shape2, -0.5235988f, 0.0f, 0.0f);
        this.cameraRotationPoint = modelPart.m_171324_("camera_rotation_point");
        this.setRotateAngle(this.cameraRotationPoint, 0.2617994f, 0.0f, 0.0f);
        this.setRotateAngle(this.cameraRotationPoint.m_171324_("camera_body"), 0.2617994f, 0.0f, 0.0f);
        this.partList = ImmutableList.of((Object)this.cameraRotationPoint, (Object)this.shape1, (Object)this.shape2);
    }

    public static LayerDefinition createLayer() {
        MeshDefinition meshDefinition = new MeshDefinition();
        PartDefinition rootDefinition = meshDefinition.m_171576_();
        PartDefinition shape2Definition = rootDefinition.m_171599_("shape2", CubeListBuilder.m_171558_().m_171514_(2, 12).m_171481_(0.0f, 0.0f, 0.0f, 2.0f, 1.0f, 6.0f), PartPose.m_171419_((float)-1.0f, (float)13.75f, (float)2.25f));
        PartDefinition cameraRotationPointDefinition = rootDefinition.m_171599_("camera_rotation_point", CubeListBuilder.m_171558_().m_171514_(0, 25).m_171481_(0.0f, 0.0f, 0.0f, 1.0f, 1.0f, 1.0f), PartPose.m_171419_((float)0.0f, (float)14.0f, (float)3.0f));
        PartDefinition cameraBodyDefinition = cameraRotationPointDefinition.m_171599_("camera_body", CubeListBuilder.m_171558_().m_171514_(0, 25).m_171481_(-2.0f, 0.0f, -2.0f, 4.0f, 3.0f, 8.0f), PartPose.m_171419_((float)0.0f, (float)0.0f, (float)-5.0f));
        rootDefinition.m_171599_("shape1", CubeListBuilder.m_171558_().m_171514_(0, 0).m_171481_(0.0f, 0.0f, 0.0f, 6.0f, 6.0f, 1.0f), PartPose.m_171419_((float)-3.0f, (float)13.0f, (float)7.0f));
        shape2Definition.m_171599_("shape3", CubeListBuilder.m_171558_().m_171514_(1, 12).m_171481_(0.0f, 0.0f, 0.0f, 2.0f, 1.0f, 7.0f), PartPose.m_171419_((float)0.0f, (float)1.0f, (float)0.0f));
        cameraBodyDefinition.m_171599_("camera_lens_right", CubeListBuilder.m_171558_().m_171514_(10, 40).m_171481_(-2.0f, 0.0f, 0.0f, 1.0f, 3.0f, 1.0f), PartPose.m_171419_((float)3.0f, (float)0.0f, (float)-3.0f));
        cameraBodyDefinition.m_171599_("camera_lens_left", CubeListBuilder.m_171558_().m_171514_(0, 40).m_171481_(0.0f, 0.0f, 0.0f, 1.0f, 3.0f, 1.0f), PartPose.m_171419_((float)-2.0f, (float)0.0f, (float)-3.0f));
        cameraBodyDefinition.m_171599_("camera_lens_top", CubeListBuilder.m_171558_().m_171514_(20, 40).m_171481_(0.0f, 0.0f, 0.0f, 2.0f, 1.0f, 1.0f), PartPose.m_171419_((float)-1.0f, (float)0.0f, (float)-3.0f));
        return LayerDefinition.m_171565_((MeshDefinition)meshDefinition, (int)64, (int)64);
    }

    public void m_7695_(PoseStack pose, VertexConsumer builder, int packedLight, int packedOverlay, float red, float green, float blue, float alpha) {
        this.partList.forEach(part -> part.m_104301_(pose, builder, packedLight, packedOverlay));
    }

    public void setRotateAngle(ModelPart modelRenderer, float x, float y, float z) {
        modelRenderer.f_104203_ = x;
        modelRenderer.f_104204_ = y;
        modelRenderer.f_104205_ = z;
    }

    public void setupAnim(SecurityCamera entity, float limbSwing, float limbSwingAmount, float ageInTicks, float netHeadYaw, float headPitch) {
    }
}

