/*
 * Decompiled with CFR 0.152.
 */
package net.geforcemods.securitycraft.models;

import java.util.List;
import java.util.Random;
import javax.annotation.Nonnull;
import net.geforcemods.securitycraft.blocks.DisguisableBlock;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.client.renderer.block.model.ItemOverrides;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.BlockAndTintGetter;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.client.model.data.IDynamicBakedModel;
import net.minecraftforge.client.model.data.IModelData;
import net.minecraftforge.client.model.data.ModelProperty;
import net.minecraftforge.registries.ForgeRegistries;

public class DisguisableDynamicBakedModel
implements IDynamicBakedModel {
    public static final ModelProperty<ResourceLocation> DISGUISED_BLOCK_RL = new ModelProperty();
    private final ResourceLocation defaultStateRl;
    private final BakedModel oldModel;

    public DisguisableDynamicBakedModel(ResourceLocation defaultStateRl, BakedModel oldModel) {
        this.defaultStateRl = defaultStateRl;
        this.oldModel = oldModel;
    }

    public List<BakedQuad> getQuads(BlockState state, Direction side, Random rand, IModelData modelData) {
        BakedModel model;
        Block block;
        ResourceLocation rl = (ResourceLocation)modelData.getData(DISGUISED_BLOCK_RL);
        if (rl != this.defaultStateRl && (block = (Block)ForgeRegistries.BLOCKS.getValue(rl)) != null && (model = Minecraft.m_91087_().m_91289_().m_110910_(block.m_49966_())) != null && model != this) {
            return model.getQuads(block.m_49966_(), side, rand, modelData);
        }
        return this.oldModel.getQuads(state, side, rand, modelData);
    }

    public TextureAtlasSprite getParticleIcon(IModelData modelData) {
        Block block;
        ResourceLocation rl = (ResourceLocation)modelData.getData(DISGUISED_BLOCK_RL);
        if (rl != this.defaultStateRl && (block = (Block)ForgeRegistries.BLOCKS.getValue(rl)) != null && !(block instanceof DisguisableBlock)) {
            return Minecraft.m_91087_().m_91289_().m_110910_(block.m_49966_()).getParticleIcon(modelData);
        }
        return this.oldModel.getParticleIcon(modelData);
    }

    @Nonnull
    public IModelData getModelData(BlockAndTintGetter level, BlockPos pos, BlockState state, IModelData tileData) {
        DisguisableBlock disguisedBlock;
        BlockState disguisedState;
        Block block = level.m_7702_(pos).m_58900_().m_60734_();
        if (block instanceof DisguisableBlock && (disguisedState = (disguisedBlock = (DisguisableBlock)block).getDisguisedBlockState((BlockGetter)level, pos)) != null) {
            tileData.setData(DISGUISED_BLOCK_RL, (Object)disguisedState.m_60734_().getRegistryName());
            return tileData;
        }
        tileData.setData(DISGUISED_BLOCK_RL, (Object)this.defaultStateRl);
        return tileData;
    }

    public TextureAtlasSprite m_6160_() {
        return this.oldModel.m_6160_();
    }

    public boolean m_7539_() {
        return false;
    }

    public boolean m_7521_() {
        return false;
    }

    public boolean m_7541_() {
        return true;
    }

    public ItemOverrides m_7343_() {
        return null;
    }

    public boolean m_7547_() {
        return false;
    }
}

