/*
 * Decompiled with CFR 0.152.
 */
package net.geforcemods.securitycraft.misc;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import net.geforcemods.securitycraft.blockentities.SonicSecuritySystemBlockEntity;
import net.minecraft.core.BlockPos;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.phys.AABB;

public class SonicSecuritySystemTracker {
    private static final Map<ResourceKey<Level>, Collection<BlockPos>> trackedSonicSecuritySystems = new HashMap<ResourceKey<Level>, Collection<BlockPos>>();

    public static void track(SonicSecuritySystemBlockEntity be) {
        SonicSecuritySystemTracker.getTrackedSonicSecuritySystems(be.m_58904_()).add(be.m_58899_().m_7949_());
    }

    public static void stopTracking(SonicSecuritySystemBlockEntity be) {
        SonicSecuritySystemTracker.getTrackedSonicSecuritySystems(be.m_58904_()).remove(be.m_58899_());
    }

    public static List<SonicSecuritySystemBlockEntity> getSonicSecuritySystemsInRange(Level level, BlockPos pos) {
        return SonicSecuritySystemTracker.getSonicSecuritySystemsInRange(level, pos, 30);
    }

    public static List<SonicSecuritySystemBlockEntity> getSonicSecuritySystemsInRange(Level level, BlockPos pos, int range) {
        Collection<BlockPos> sonicSecuritySystems = SonicSecuritySystemTracker.getTrackedSonicSecuritySystems(level);
        ArrayList<SonicSecuritySystemBlockEntity> returnValue = new ArrayList<SonicSecuritySystemBlockEntity>();
        Iterator<BlockPos> it = sonicSecuritySystems.iterator();
        while (it.hasNext()) {
            BlockEntity blockEntity;
            BlockPos sonicSecuritySystemPos = it.next();
            if (sonicSecuritySystemPos != null && (blockEntity = level.m_7702_(sonicSecuritySystemPos)) instanceof SonicSecuritySystemBlockEntity) {
                SonicSecuritySystemBlockEntity sss = (SonicSecuritySystemBlockEntity)blockEntity;
                if (!SonicSecuritySystemTracker.canSonicSecuritySystemReach(sss, pos)) continue;
                returnValue.add(sss);
                continue;
            }
            it.remove();
        }
        return returnValue;
    }

    private static Collection<BlockPos> getTrackedSonicSecuritySystems(Level level) {
        Collection<BlockPos> sonicSecuritySystems = trackedSonicSecuritySystems.get(level.m_46472_());
        if (sonicSecuritySystems == null) {
            sonicSecuritySystems = new HashSet<BlockPos>();
            trackedSonicSecuritySystems.put((ResourceKey<Level>)level.m_46472_(), sonicSecuritySystems);
        }
        return sonicSecuritySystems;
    }

    public static boolean canSonicSecuritySystemReach(SonicSecuritySystemBlockEntity be, BlockPos pos) {
        AABB sssRange = new AABB(be.m_58899_()).m_82400_(30.0);
        return sssRange.f_82288_ <= (double)pos.m_123341_() && sssRange.f_82289_ <= (double)pos.m_123342_() && sssRange.f_82290_ <= (double)pos.m_123343_() && sssRange.f_82291_ >= (double)pos.m_123341_() && sssRange.f_82292_ >= (double)pos.m_123342_() && sssRange.f_82293_ >= (double)pos.m_123343_();
    }
}

