/*
 * Decompiled with CFR 0.152.
 */
package net.geforcemods.securitycraft.items;

import net.geforcemods.securitycraft.api.LinkableBlockEntity;
import net.geforcemods.securitycraft.util.BlockUtils;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.DoorBlock;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.DoorHingeSide;
import net.minecraft.world.level.block.state.properties.DoubleBlockHalf;
import net.minecraft.world.level.block.state.properties.Property;

public class SpecialDoorItem
extends BlockItem {
    public SpecialDoorItem(Block block, Item.Properties properties) {
        super(block, properties);
    }

    public InteractionResult m_6225_(UseOnContext ctx) {
        return this.onItemUse(ctx.m_43723_(), ctx.m_43725_(), ctx.m_8083_(), ctx.m_43722_(), ctx.m_43719_(), ctx.m_43720_().f_82479_, ctx.m_43720_().f_82480_, ctx.m_43720_().f_82481_, ctx);
    }

    public InteractionResult onItemUse(Player player, Level level, BlockPos pos, ItemStack stack, Direction facing, double hitX, double hitY, double hitZ, UseOnContext ctx) {
        BlockState state = level.m_8055_(pos);
        Block block = state.m_60734_();
        if (!block.m_6864_(state, new BlockPlaceContext(ctx))) {
            pos = pos.m_142300_(facing);
        }
        if (player.m_36204_(pos, facing, stack) && BlockUtils.isSideSolid((LevelReader)level, pos.m_7495_(), Direction.UP)) {
            BlockEntity blockEntity;
            boolean flag;
            Direction angleFacing = Direction.m_122364_((double)player.m_146908_());
            int offsetX = angleFacing.m_122429_();
            int offsetZ = angleFacing.m_122431_();
            boolean bl = flag = offsetX < 0 && hitZ < 0.5 || offsetX > 0 && hitZ > 0.5 || offsetZ < 0 && hitX > 0.5 || offsetZ > 0 && hitX < 0.5;
            if (!this.placeDoor(level, pos, angleFacing, this.m_40614_(), flag, ctx)) {
                return InteractionResult.FAIL;
            }
            state = level.m_8055_(pos);
            block = state.m_60734_();
            SoundType soundType = block.getSoundType(state, (LevelReader)level, pos, (Entity)player);
            level.m_5594_(null, pos, soundType.m_56777_(), SoundSource.BLOCKS, (soundType.m_56773_() + 1.0f) / 2.0f, soundType.m_56774_() * 0.8f);
            if (!player.m_7500_()) {
                stack.m_41774_(1);
            }
            if ((blockEntity = level.m_7702_(pos)) instanceof LinkableBlockEntity) {
                LinkableBlockEntity lowerBe = (LinkableBlockEntity)blockEntity;
                LinkableBlockEntity upperBe = (LinkableBlockEntity)level.m_7702_(pos.m_7494_());
                lowerBe.setOwner(player.m_36316_().getId().toString(), player.m_7755_().getString());
                upperBe.setOwner(player.m_36316_().getId().toString(), player.m_7755_().getString());
                LinkableBlockEntity.link(lowerBe, upperBe);
            }
            return InteractionResult.SUCCESS;
        }
        return InteractionResult.FAIL;
    }

    public boolean placeDoor(Level level, BlockPos pos, Direction facing, Block door, boolean isRightHinge, UseOnContext ctx) {
        boolean isLeftDoor;
        BlockPos posAbove = pos.m_7494_();
        if (!level.m_8055_(posAbove).m_60629_(new BlockPlaceContext(ctx))) {
            return false;
        }
        BlockPos left = pos.m_142300_(facing.m_122427_());
        BlockPos right = pos.m_142300_(facing.m_122428_());
        int rightNormalCubeAmount = (level.m_8055_(right).m_60796_((BlockGetter)level, pos) ? 1 : 0) + (level.m_8055_(right.m_7494_()).m_60796_((BlockGetter)level, pos) ? 1 : 0);
        int leftNormalCubeAmount = (level.m_8055_(left).m_60796_((BlockGetter)level, pos) ? 1 : 0) + (level.m_8055_(left.m_7494_()).m_60796_((BlockGetter)level, pos) ? 1 : 0);
        boolean isRightDoor = level.m_8055_(right).m_60734_() == door || level.m_8055_(right.m_7494_()).m_60734_() == door;
        boolean bl = isLeftDoor = level.m_8055_(left).m_60734_() == door || level.m_8055_(left.m_7494_()).m_60734_() == door;
        if ((!isRightDoor || isLeftDoor) && leftNormalCubeAmount <= rightNormalCubeAmount) {
            if (isLeftDoor && !isRightDoor || leftNormalCubeAmount < rightNormalCubeAmount) {
                isRightHinge = false;
            }
        } else {
            isRightHinge = true;
        }
        BlockState state = (BlockState)((BlockState)door.m_49966_().m_61124_((Property)DoorBlock.f_52726_, (Comparable)facing)).m_61124_((Property)DoorBlock.f_52728_, (Comparable)(isRightHinge ? DoorHingeSide.RIGHT : DoorHingeSide.LEFT));
        level.m_7731_(pos, (BlockState)state.m_61124_((Property)DoorBlock.f_52730_, (Comparable)DoubleBlockHalf.LOWER), 2);
        level.m_7731_(posAbove, (BlockState)state.m_61124_((Property)DoorBlock.f_52730_, (Comparable)DoubleBlockHalf.UPPER), 2);
        level.m_46672_(pos, door);
        level.m_46672_(posAbove, door);
        return true;
    }
}

