/*
 * Decompiled with CFR 0.152.
 */
package net.geforcemods.securitycraft.items;

import java.util.List;
import net.geforcemods.securitycraft.SCContent;
import net.geforcemods.securitycraft.SecurityCraft;
import net.geforcemods.securitycraft.entity.Sentry;
import net.geforcemods.securitycraft.network.client.OpenSRATGui;
import net.geforcemods.securitycraft.network.client.UpdateNBTTagOnClient;
import net.geforcemods.securitycraft.util.BlockUtils;
import net.geforcemods.securitycraft.util.PlayerUtils;
import net.geforcemods.securitycraft.util.Utils;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.TextComponent;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.AABB;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.network.PacketDistributor;

public class SentryRemoteAccessToolItem
extends Item {
    public SentryRemoteAccessToolItem(Item.Properties properties) {
        super(properties);
    }

    public InteractionResultHolder<ItemStack> m_7203_(Level level, Player player, InteractionHand hand) {
        ItemStack stack = player.m_21120_(hand);
        if (!level.f_46443_) {
            SecurityCraft.channel.send(PacketDistributor.PLAYER.with(() -> (ServerPlayer)player), (Object)new OpenSRATGui((player.m_20194_().m_6846_().m_11312_() - 1) * 16));
        }
        return InteractionResultHolder.m_19096_((Object)stack);
    }

    public InteractionResult m_6225_(UseOnContext ctx) {
        return this.onItemUse(ctx.m_43723_(), ctx.m_43725_(), ctx.m_8083_(), ctx.m_43722_(), ctx.m_43719_(), ctx.m_43720_().f_82479_, ctx.m_43720_().f_82480_, ctx.m_43720_().f_82481_);
    }

    public InteractionResult onItemUse(Player player, Level level, BlockPos pos, ItemStack stack, Direction facing, double hitX, double hitY, double hitZ) {
        List sentries = level.m_45976_(Sentry.class, new AABB(pos));
        if (!sentries.isEmpty()) {
            Sentry sentry = (Sentry)((Object)sentries.get(0));
            BlockPos sentryPos = sentry.m_142538_();
            if (!this.isSentryAdded(stack, sentryPos)) {
                int availSlot = this.getNextAvailableSlot(stack);
                if (availSlot == 0) {
                    PlayerUtils.sendMessageToPlayer(player, (MutableComponent)Utils.localize(((Item)SCContent.REMOTE_ACCESS_SENTRY.get()).m_5524_(), new Object[0]), (MutableComponent)Utils.localize("messages.securitycraft:srat.noSlots", new Object[0]), ChatFormatting.RED);
                    return InteractionResult.FAIL;
                }
                if (!sentry.getOwner().isOwner(player)) {
                    PlayerUtils.sendMessageToPlayer(player, (MutableComponent)Utils.localize(((Item)SCContent.REMOTE_ACCESS_SENTRY.get()).m_5524_(), new Object[0]), (MutableComponent)Utils.localize("messages.securitycraft:srat.cantBind", new Object[0]), ChatFormatting.RED);
                    return InteractionResult.FAIL;
                }
                if (stack.m_41783_() == null) {
                    stack.m_41751_(new CompoundTag());
                }
                stack.m_41783_().m_128385_("sentry" + availSlot, BlockUtils.posToIntArray(sentryPos));
                if (!level.f_46443_) {
                    SecurityCraft.channel.send(PacketDistributor.PLAYER.with(() -> (ServerPlayer)player), (Object)new UpdateNBTTagOnClient(stack));
                }
                PlayerUtils.sendMessageToPlayer(player, (MutableComponent)Utils.localize(((Item)SCContent.REMOTE_ACCESS_SENTRY.get()).m_5524_(), new Object[0]), (MutableComponent)Utils.localize("messages.securitycraft:srat.bound", sentryPos), ChatFormatting.GREEN);
            } else {
                this.removeTagFromItemAndUpdate(stack, sentryPos, player);
                PlayerUtils.sendMessageToPlayer(player, (MutableComponent)Utils.localize(((Item)SCContent.REMOTE_ACCESS_SENTRY.get()).m_5524_(), new Object[0]), (MutableComponent)Utils.localize("messages.securitycraft:srat.unbound", sentryPos), ChatFormatting.RED);
            }
            return InteractionResult.SUCCESS;
        }
        if (!level.f_46443_) {
            SecurityCraft.channel.send(PacketDistributor.PLAYER.with(() -> (ServerPlayer)player), (Object)new OpenSRATGui((player.m_20194_().m_6846_().m_11312_() - 1) * 16));
        }
        return InteractionResult.SUCCESS;
    }

    @OnlyIn(value=Dist.CLIENT)
    public void m_7373_(ItemStack stack, Level level, List<Component> tooltip, TooltipFlag flag) {
        if (stack.m_41783_() == null) {
            return;
        }
        for (int i = 1; i <= 12; ++i) {
            if (stack.m_41783_().m_128465_("sentry" + i).length > 0) {
                int[] coords = stack.m_41783_().m_128465_("sentry" + i);
                if (coords[0] == 0 && coords[1] == 0 && coords[2] == 0) {
                    tooltip.add((Component)new TextComponent(ChatFormatting.GRAY + "---"));
                    continue;
                }
                BlockPos pos = new BlockPos(coords[0], coords[1], coords[2]);
                List sentries = Minecraft.m_91087_().f_91074_.f_19853_.m_45976_(Sentry.class, new AABB(pos));
                Object nameToShow = !sentries.isEmpty() && ((Sentry)((Object)sentries.get(0))).m_8077_() ? ((Sentry)((Object)sentries.get(0))).m_7770_().getString() : Utils.localize("tooltip.securitycraft:sentry", new Object[0]).getString() + " " + i;
                tooltip.add((Component)new TextComponent(ChatFormatting.GRAY + (String)nameToShow + ": " + Utils.getFormattedCoordinates(pos).getString()));
                continue;
            }
            tooltip.add((Component)new TextComponent(ChatFormatting.GRAY + "---"));
        }
    }

    private void removeTagFromItemAndUpdate(ItemStack stack, BlockPos pos, Player player) {
        if (stack.m_41783_() == null) {
            return;
        }
        for (int i = 1; i <= 12; ++i) {
            int[] coords;
            if (stack.m_41783_().m_128465_("sentry" + i).length <= 0 || (coords = stack.m_41783_().m_128465_("sentry" + i))[0] != pos.m_123341_() || coords[1] != pos.m_123342_() || coords[2] != pos.m_123343_()) continue;
            stack.m_41783_().m_128385_("sentry" + i, new int[]{0, 0, 0});
            if (!player.f_19853_.f_46443_) {
                SecurityCraft.channel.send(PacketDistributor.PLAYER.with(() -> (ServerPlayer)player), (Object)new UpdateNBTTagOnClient(stack));
            }
            return;
        }
    }

    private boolean isSentryAdded(ItemStack stack, BlockPos pos) {
        if (stack.m_41783_() == null) {
            return false;
        }
        for (int i = 1; i <= 12; ++i) {
            int[] coords;
            if (stack.m_41783_().m_128465_("sentry" + i).length <= 0 || (coords = stack.m_41783_().m_128465_("sentry" + i))[0] != pos.m_123341_() || coords[1] != pos.m_123342_() || coords[2] != pos.m_123343_()) continue;
            return true;
        }
        return false;
    }

    private int getNextAvailableSlot(ItemStack stack) {
        if (stack.m_41783_() == null) {
            return 1;
        }
        for (int i = 1; i <= 12; ++i) {
            int[] pos = stack.m_41783_().m_128465_("sentry" + i);
            if (pos.length != 0 && (pos[0] != 0 || pos[1] != 0 || pos[2] != 0)) continue;
            return i;
        }
        return 0;
    }
}

