/*
 * Decompiled with CFR 0.152.
 */
package net.geforcemods.securitycraft.items;

import java.util.ArrayDeque;
import java.util.Deque;
import java.util.List;
import net.geforcemods.securitycraft.SCContent;
import net.geforcemods.securitycraft.SCEventHandler;
import net.geforcemods.securitycraft.api.IModuleInventory;
import net.geforcemods.securitycraft.blockentities.SonicSecuritySystemBlockEntity;
import net.geforcemods.securitycraft.util.ModuleUtils;
import net.geforcemods.securitycraft.util.Utils;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.Level;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.apache.commons.lang3.tuple.MutablePair;

public class PortableTunePlayerItem
extends Item {
    public PortableTunePlayerItem(Item.Properties properties) {
        super(properties);
    }

    public InteractionResult m_6225_(UseOnContext ctx) {
        BlockPos pos;
        Level level = ctx.m_43725_();
        if (level.m_8055_(pos = ctx.m_8083_()).m_60734_() == SCContent.SONIC_SECURITY_SYSTEM.get()) {
            SonicSecuritySystemBlockEntity be = (SonicSecuritySystemBlockEntity)level.m_7702_(pos);
            Player player = ctx.m_43723_();
            if (be.getOwner().isOwner(player) || ModuleUtils.isAllowed((IModuleInventory)be, (Entity)player)) {
                if (be.getNumberOfNotes() > 0) {
                    be.saveNotes(ctx.m_43722_().m_41784_());
                    player.m_5661_((Component)Utils.localize("messages.securitycraft:portable_tune_player.tune_saved", new Object[0]), true);
                } else {
                    player.m_5661_((Component)Utils.localize("messages.securitycraft:portable_tune_player.no_tune", new Object[0]), true);
                }
                return InteractionResult.SUCCESS;
            }
        }
        return InteractionResult.PASS;
    }

    public InteractionResultHolder<ItemStack> m_7203_(Level level, Player player, InteractionHand hand) {
        ItemStack stack = player.m_21120_(hand);
        if (!level.f_46443_) {
            CompoundTag tag = stack.m_41784_();
            boolean isTunePlaying = SCEventHandler.PLAYING_TUNES.containsKey(player);
            if (!isTunePlaying && tag.m_128441_("Notes")) {
                ArrayDeque notes = new ArrayDeque();
                SonicSecuritySystemBlockEntity.loadNotes(stack.m_41783_(), notes);
                SCEventHandler.PLAYING_TUNES.put(player, (MutablePair<Integer, Deque<SonicSecuritySystemBlockEntity.NoteWrapper>>)MutablePair.of((Object)0, notes));
                return InteractionResultHolder.m_19090_((Object)stack);
            }
            if (isTunePlaying) {
                SCEventHandler.PLAYING_TUNES.remove(player);
                return InteractionResultHolder.m_19090_((Object)stack);
            }
        }
        return InteractionResultHolder.m_19098_((Object)stack);
    }

    @OnlyIn(value=Dist.CLIENT)
    public void m_7373_(ItemStack stack, Level level, List<Component> tooltip, TooltipFlag flag) {
        if (!stack.m_41782_()) {
            return;
        }
        int notesCount = stack.m_41783_().m_128437_("Notes", 10).size();
        if (notesCount > 0) {
            tooltip.add((Component)Utils.localize("tooltip.securitycraft:portableTunePlayer.noteCount", notesCount).m_130948_(Utils.GRAY_STYLE));
        }
    }
}

